/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.tropicraft.core.common.dimension.feature.TropicraftStructureTypes;

public class HomeTreeStructure
extends Structure {
    public static final Codec<HomeTreeStructure> CODEC = RecordCodecBuilder.create(i -> i.group((App)HomeTreeStructure.m_226567_((RecordCodecBuilder.Instance)i), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(s -> s.startPool), (App)Codec.intRange((int)0, (int)7).fieldOf("size").forGetter(s -> s.maxDepth)).apply((Applicative)i, HomeTreeStructure::new));
    private final Holder<StructureTemplatePool> startPool;
    private final int maxDepth;

    public HomeTreeStructure(Structure.StructureSettings settings, Holder<StructureTemplatePool> startPool, int maxDepth) {
        super(settings);
        this.startPool = startPool;
        this.maxDepth = maxDepth;
    }

    private static boolean isValid(ChunkGenerator generator, BlockPos pos, int startY, LevelHeightAccessor level, RandomState randomState) {
        int y = generator.m_214096_(pos.m_123341_(), pos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, level, randomState);
        return y >= generator.m_6337_() && Math.abs(y - startY) < 10 && y < 150 && y > generator.m_6337_() + 2;
    }

    private static boolean checkLocation(Structure.GenerationContext context, BlockPos pos) {
        ChunkGenerator generator = context.f_226622_();
        RandomState randomState = context.f_226624_();
        LevelHeightAccessor level = context.f_226629_();
        int y = generator.m_214096_(pos.m_123341_(), pos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, level, randomState);
        return HomeTreeStructure.isValid(generator, pos.m_7918_(-4, 0, -4), y, level, randomState) && HomeTreeStructure.isValid(generator, pos.m_7918_(-4, 0, 4), y, level, randomState) && HomeTreeStructure.isValid(generator, pos.m_7918_(4, 0, 4), y, level, randomState) && HomeTreeStructure.isValid(generator, pos.m_7918_(4, 0, -4), y, level, randomState);
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        ChunkPos chunkPos = context.f_226628_();
        BlockPos startPos = new BlockPos(chunkPos.m_45604_(), 0, chunkPos.m_45605_());
        if (!HomeTreeStructure.checkLocation(context, startPos)) {
            return Optional.empty();
        }
        return JigsawPlacement.m_227238_((Structure.GenerationContext)context, this.startPool, Optional.empty(), (int)this.maxDepth, (BlockPos)startPos, (boolean)false, Optional.of(Heightmap.Types.WORLD_SURFACE_WG), (int)80);
    }

    public StructureType<?> m_213658_() {
        return (StructureType)TropicraftStructureTypes.HOME_TREE.get();
    }
}

