/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature;

import java.util.Arrays;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatureUtil;

public class TropicraftPlacementUtil {
    @SafeVarargs
    public static Holder.Reference<PlacedFeature> registerRandomChecked(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<PlacedFeature> ... choices) {
        Holder randomConfigured = Holder.m_205709_(TropicraftFeatureUtil.randomFeature(Arrays.asList(choices)));
        return context.m_255272_(key, (Object)new PlacedFeature(randomConfigured, List.of()));
    }

    public static Holder.Reference<PlacedFeature> register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, ResourceKey<ConfiguredFeature<?, ?>> featureKey, List<PlacementModifier> placement) {
        Holder.Reference feature = context.m_255420_(Registries.f_256911_).m_255043_(featureKey);
        return context.m_255272_(key, (Object)new PlacedFeature((Holder)feature, placement));
    }

    public static List<PlacementModifier> sparseTreePlacement(float chance) {
        return TropicraftPlacementUtil.treePlacement(0, chance, 1);
    }

    public static List<PlacementModifier> treePlacement(int count, float extraChance, int extraCount) {
        return List.of(PlacementUtils.m_195364_((int)count, (float)extraChance, (int)extraCount), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_());
    }

    public static List<PlacementModifier> orePlacement(PlacementModifier count, PlacementModifier height) {
        return List.of(count, InSquarePlacement.m_191715_(), height, BiomeFilter.m_191561_());
    }

    public static List<PlacementModifier> commonOrePlacement(int count, PlacementModifier height) {
        return TropicraftPlacementUtil.orePlacement((PlacementModifier)CountPlacement.m_191628_((int)count), height);
    }
}

