/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.jigsaw;

import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.dimension.feature.jigsaw.AdjustBuildingHeightProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.AirToCaveAirProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.SinkInGroundProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.SmoothingGravityProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.SteepPathProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.StructureSupportsProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.StructureVoidProcessor;

public final class TropicraftProcessorLists {
    public static final ResourceKey<StructureProcessorList> KOA_TOWN_CENTERS = TropicraftProcessorLists.createKey("koa_village/town_centers");
    public static final ResourceKey<StructureProcessorList> KOA_BUILDINGS = TropicraftProcessorLists.createKey("koa_village/buildings");
    public static final ResourceKey<StructureProcessorList> KOA_PATH = TropicraftProcessorLists.createKey("koa_village/koa_path");
    public static final ResourceKey<StructureProcessorList> HOME_TREE_BASE = TropicraftProcessorLists.createKey("home_tree/base");
    public static final ResourceKey<StructureProcessorList> HOME_TREE_START = TropicraftProcessorLists.createKey("home_tree/start");

    public static void bootstrap(BootstapContext<StructureProcessorList> context) {
        StructureSupportsProcessor fenceExtender = new StructureSupportsProcessor(false, (HolderSet<Block>)TropicraftProcessorLists.holderSet(TropicraftBlocks.BAMBOO_FENCE));
        context.m_255272_(KOA_TOWN_CENTERS, (Object)new StructureProcessorList(List.of(fenceExtender, new StructureVoidProcessor())));
        context.m_255272_(KOA_BUILDINGS, (Object)new StructureProcessorList(List.of(new AdjustBuildingHeightProcessor(126), fenceExtender, new StructureVoidProcessor())));
        context.m_255272_(KOA_PATH, (Object)new StructureProcessorList(List.of(new SmoothingGravityProcessor(Heightmap.Types.WORLD_SURFACE_WG, -1), new SinkInGroundProcessor(), new SteepPathProcessor(), fenceExtender)));
        context.m_255272_(HOME_TREE_BASE, (Object)new StructureProcessorList(List.of(new AirToCaveAirProcessor())));
        context.m_255272_(HOME_TREE_START, (Object)new StructureProcessorList(List.of(new AirToCaveAirProcessor(), new StructureSupportsProcessor(true, (HolderSet<Block>)TropicraftProcessorLists.holderSet(TropicraftBlocks.MAHOGANY_LOG)))));
    }

    @SafeVarargs
    private static HolderSet.Direct<Block> holderSet(BlockEntry<? extends Block> ... blocks) {
        return HolderSet.m_205809_((Holder[])((Holder[])Arrays.stream(blocks).map(object -> (Holder)object.getHolder().orElseThrow()).toArray(Holder[]::new)));
    }

    private static ResourceKey<StructureProcessorList> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_257011_, (ResourceLocation)new ResourceLocation("tropicraft", name));
    }
}

