/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.jigsaw.piece;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.dimension.feature.jigsaw.piece.IntersectionAllowedPiece;

public final class HomeTreeBranchPiece
extends StructurePoolElement
implements IntersectionAllowedPiece {
    public static final Codec<HomeTreeBranchPiece> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.FLOAT.fieldOf("min_angle").forGetter(c -> Float.valueOf(c.minAngle)), (App)Codec.FLOAT.fieldOf("max_angle").forGetter(c -> Float.valueOf(c.maxAngle))).apply((Applicative)i, HomeTreeBranchPiece::new));
    private static final int MAX_RADIUS = 48;
    private static final Direction.Axis[] ALL_AXIS = Direction.Axis.values();
    private static final StructurePoolElementType<HomeTreeBranchPiece> TYPE = StructurePoolElementType.m_210550_((String)"tropicraft:home_tree_branch", CODEC);
    private static final CompoundTag JIGSAW_NBT = HomeTreeBranchPiece.createJigsawNbt();
    public final float minAngle;
    public final float maxAngle;

    public HomeTreeBranchPiece(float minAngle, float maxAngle) {
        super(StructureTemplatePool.Projection.RIGID);
        this.minAngle = minAngle;
        this.maxAngle = maxAngle;
    }

    public static Function<StructureTemplatePool.Projection, HomeTreeBranchPiece> create(float minAngle, float maxAngle) {
        return placementBehaviour -> new HomeTreeBranchPiece(minAngle, maxAngle);
    }

    private static CompoundTag createJigsawNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("name", "minecraft:bottom");
        nbt.m_128359_("final_state", "minecraft:air");
        nbt.m_128359_("pool", "minecraft:empty");
        nbt.m_128359_("target", "minecraft:empty");
        nbt.m_128359_("joint", JigsawBlockEntity.JointType.ROLLABLE.m_7912_());
        return nbt;
    }

    public List<StructureTemplate.StructureBlockInfo> m_213638_(StructureTemplateManager templates, BlockPos pos, Rotation rotation, RandomSource random) {
        FrontAndTop orientation = FrontAndTop.m_122622_((Direction)Direction.DOWN, (Direction)Direction.SOUTH);
        BlockState state = (BlockState)Blocks.f_50678_.m_49966_().m_61124_((Property)JigsawBlock.f_54222_, (Comparable)orientation);
        return List.of(new StructureTemplate.StructureBlockInfo(pos, state, JIGSAW_NBT));
    }

    public Vec3i m_213577_(StructureTemplateManager templates, Rotation rotation) {
        return Vec3i.f_123288_;
    }

    public BoundingBox m_214015_(StructureTemplateManager templates, BlockPos pos, Rotation rotation) {
        return new BoundingBox(pos.m_123341_() - 48, pos.m_123342_() - 48, pos.m_123343_() - 48, pos.m_123341_() + 48, pos.m_123342_() + 48, pos.m_123343_() + 48);
    }

    public boolean m_213695_(StructureTemplateManager templates, WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, BlockPos origin, BlockPos p_227341_, Rotation rotation, BoundingBox chunkBounds, RandomSource random, boolean p_227345_) {
        WorldgenRandom rand = new WorldgenRandom((RandomSource)new LegacyRandomSource(level.m_7328_()));
        rand.m_64690_(level.m_7328_(), origin.m_123341_(), origin.m_123343_());
        int branchLength = rand.m_188503_(10) + 15;
        int branchX1 = origin.m_123341_();
        int branchZ1 = origin.m_123343_();
        double minAngle = Math.toRadians(this.minAngle);
        double maxAngle = Math.toRadians(this.maxAngle);
        double angle = minAngle + (double)rand.m_188501_() * (maxAngle - minAngle);
        int branchX2 = (int)((double)branchLength * Math.sin(angle) + (double)branchX1);
        int branchZ2 = (int)((double)branchLength * Math.cos(angle) + (double)branchZ1);
        int branchY2 = rand.m_188503_(4) + 4;
        BlockState wood = ((RotatedPillarBlock)TropicraftBlocks.MAHOGANY_LOG.get()).m_49966_();
        BlockState leaf = ((LeavesBlock)TropicraftBlocks.MAHOGANY_LEAVES.get()).m_49966_();
        int leafCircleSizeConstant = 3;
        int y2 = origin.m_123342_() + branchY2;
        this.placeBlockLine(level, new BlockPos(branchX1, origin.m_123342_(), branchZ1), new BlockPos(branchX2, y2, branchZ2), wood, chunkBounds);
        this.placeBlockLine(level, new BlockPos(branchX1 + 1, origin.m_123342_(), branchZ1), new BlockPos(branchX2 + 1, y2, branchZ2), wood, chunkBounds);
        this.placeBlockLine(level, new BlockPos(branchX1 - 1, origin.m_123342_(), branchZ1), new BlockPos(branchX2 - 1, y2, branchZ2), wood, chunkBounds);
        this.placeBlockLine(level, new BlockPos(branchX1, origin.m_123342_(), branchZ1 + 1), new BlockPos(branchX2, y2, branchZ2 + 1), wood, chunkBounds);
        this.placeBlockLine(level, new BlockPos(branchX1, origin.m_123342_(), branchZ1 - 1), new BlockPos(branchX2, y2, branchZ2 - 1), wood, chunkBounds);
        this.placeBlockLine(level, new BlockPos(branchX1, origin.m_123342_() - 1, branchZ1), new BlockPos(branchX2, y2 - 1, branchZ2), wood, chunkBounds);
        this.placeBlockLine(level, new BlockPos(branchX1, origin.m_123342_() + 1, branchZ1), new BlockPos(branchX2, y2 + 1, branchZ2), wood, chunkBounds);
        this.genLeafCircle(level, branchX2, y2 - 1, branchZ2, 8, 6, leaf, chunkBounds);
        this.genLeafCircle(level, branchX2, y2, branchZ2, 9, 0, leaf, chunkBounds);
        this.genLeafCircle(level, branchX2, y2 + 1, branchZ2, 13, 0, leaf, chunkBounds);
        this.genLeafCircle(level, branchX2, y2 + 2, branchZ2, 12, 0, leaf, chunkBounds);
        return true;
    }

    public void genLeafCircle(WorldGenLevel world, int x, int y, int z, int outerRadius, int innerRadius, BlockState state, BoundingBox chunkBounds) {
        int outerRadiusSquared = outerRadius * outerRadius;
        int innerRadiusSquared = innerRadius * innerRadius;
        BlockPos origin = new BlockPos(x, y, z);
        BoundingBox outerBounds = BoundingBox.m_162375_((Vec3i)origin.m_7918_(-outerRadius, 0, -outerRadius), (Vec3i)origin.m_7918_(outerRadius, 0, outerRadius));
        BoundingBox bounds = HomeTreeBranchPiece.intersection(chunkBounds, outerBounds);
        if (bounds == null) {
            return;
        }
        for (BlockPos pos : BlockPos.m_121976_((int)bounds.m_162395_(), (int)bounds.m_162396_(), (int)bounds.m_162398_(), (int)bounds.m_162399_(), (int)bounds.m_162400_(), (int)bounds.m_162401_())) {
            double distanceSquared = pos.m_123331_((Vec3i)origin);
            if (!(distanceSquared <= (double)outerRadiusSquared) || !(distanceSquared >= (double)innerRadiusSquared) || !world.m_46859_(pos) && world.m_8055_(pos).m_60734_() != state.m_60734_()) continue;
            world.m_7731_(pos, state, 3);
        }
    }

    private void placeBlockLine(WorldGenLevel world, BlockPos from, BlockPos to, BlockState state, BoundingBox chunkBounds) {
        Direction.Axis primaryAxis;
        BoundingBox lineBounds = BoundingBox.m_162375_((Vec3i)from, (Vec3i)to);
        if (!chunkBounds.m_71049_(lineBounds)) {
            return;
        }
        BlockPos delta = to.m_121996_((Vec3i)from);
        int maxLength = Math.abs(HomeTreeBranchPiece.getCoordinateAlong((Vec3i)delta, primaryAxis = this.getLongestAxis(delta)));
        if (maxLength == 0) {
            return;
        }
        double stepX = (double)HomeTreeBranchPiece.getCoordinateAlong((Vec3i)delta, Direction.Axis.X) / (double)maxLength;
        double stepY = (double)HomeTreeBranchPiece.getCoordinateAlong((Vec3i)delta, Direction.Axis.Y) / (double)maxLength;
        double stepZ = (double)HomeTreeBranchPiece.getCoordinateAlong((Vec3i)delta, Direction.Axis.Z) / (double)maxLength;
        for (int length = 0; length <= maxLength; ++length) {
            BlockPos pos = BlockPos.m_274561_((double)((double)from.m_123341_() + (double)length * stepX + 0.5), (double)((double)from.m_123342_() + (double)length * stepY + 0.5), (double)((double)from.m_123343_() + (double)length * stepZ + 0.5));
            if (!chunkBounds.m_71051_((Vec3i)pos)) continue;
            world.m_7731_(pos, state, 3);
        }
    }

    private Direction.Axis getLongestAxis(BlockPos delta) {
        Direction.Axis longestAxis = Direction.Axis.X;
        int longestLength = 0;
        for (Direction.Axis axis : ALL_AXIS) {
            int length = Math.abs(HomeTreeBranchPiece.getCoordinateAlong((Vec3i)delta, axis));
            if (length <= longestLength) continue;
            longestAxis = axis;
            longestLength = length;
        }
        return longestAxis;
    }

    @Nullable
    private static BoundingBox intersection(BoundingBox left, BoundingBox right) {
        if (!left.m_71049_(right)) {
            return null;
        }
        return new BoundingBox(Math.max(left.m_162395_(), right.m_162395_()), Math.max(left.m_162396_(), right.m_162396_()), Math.max(left.m_162398_(), right.m_162398_()), Math.min(left.m_162399_(), right.m_162399_()), Math.min(left.m_162400_(), right.m_162400_()), Math.min(left.m_162401_(), right.m_162401_()));
    }

    private static int getCoordinateAlong(Vec3i pos, Direction.Axis axis) {
        return axis.m_7863_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public StructurePoolElementType<?> m_207234_() {
        return TYPE;
    }
}

