/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.tree;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.tropicraft.core.common.block.FruitingBranchBlock;
import net.tropicraft.core.common.dimension.feature.tree.TropicraftTreeDecorators;

public class BranchTreeDecorator
extends TreeDecorator {
    public static final Codec<BranchTreeDecorator> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(d -> Float.valueOf(d.probability)), (App)BlockStateProvider.f_68747_.fieldOf("branch").forGetter(d -> d.branch), (App)ExtraCodecs.f_144628_.fieldOf("min_height").forGetter(d -> d.minHeight)).apply((Applicative)i, BranchTreeDecorator::new));
    private final float probability;
    private final BlockStateProvider branch;
    private final int minHeight;

    public BranchTreeDecorator(float probability, BlockStateProvider branch, int minHeight) {
        this.probability = probability;
        this.branch = branch;
        this.minHeight = minHeight;
    }

    protected TreeDecoratorType<?> m_6663_() {
        return (TreeDecoratorType)TropicraftTreeDecorators.BRANCH.get();
    }

    public void m_214187_(TreeDecorator.Context context) {
        RandomSource random = context.m_226067_();
        ObjectArrayList logs = context.m_226068_();
        int bottomLogY = ((BlockPos)logs.get(0)).m_123342_();
        for (BlockPos log : logs) {
            if (log.m_123342_() - bottomLogY < this.minHeight) continue;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos pos;
                if (!(random.m_188501_() <= this.probability) || !context.m_226059_(pos = log.m_121945_(direction.m_122424_()))) continue;
                context.m_226061_(pos, (BlockState)this.branch.m_213972_(random, pos).m_263224_(FruitingBranchBlock.FACING, (Comparable)direction.m_122424_()));
            }
        }
    }
}

