/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.tree;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedRW;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatureUtil;
import net.tropicraft.core.common.dimension.feature.tree.RainforestTreeFeature;

public class TualungFeature
extends RainforestTreeFeature {
    private int baseHeight;
    private int maxHeight;

    public TualungFeature(Codec<NoneFeatureConfiguration> codec, int maxHeight, int baseHeight) {
        super(codec);
        this.baseHeight = baseHeight;
        this.maxHeight = maxHeight;
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel world = context.m_159774_();
        RandomSource rand = context.m_225041_();
        BlockPos pos = context.m_159777_();
        pos = pos.m_7949_();
        int i = pos.m_123341_();
        int j = pos.m_123342_();
        int k = pos.m_123343_();
        int height = rand.m_188503_(this.maxHeight - this.baseHeight) + this.baseHeight + j;
        int branches = rand.m_188503_(3) + 3;
        if (TropicraftFeatureUtil.goesBeyondWorldSize(world, pos.m_123342_(), height - j)) {
            return false;
        }
        if (height + 6 > world.m_151558_()) {
            return false;
        }
        if (!TropicraftFeatureUtil.isBBAvailable(world, pos, height - j)) {
            return false;
        }
        if (!this.getSapling().m_7898_(this.getSapling().m_49966_(), (LevelReader)world, pos)) {
            return false;
        }
        this.setState((LevelWriter)world, new BlockPos(i, j - 1, k), Blocks.f_50493_.m_49966_());
        this.setState((LevelWriter)world, new BlockPos(i - 1, j - 1, k), Blocks.f_50493_.m_49966_());
        this.setState((LevelWriter)world, new BlockPos(i + 1, j - 1, k), Blocks.f_50493_.m_49966_());
        this.setState((LevelWriter)world, new BlockPos(i, j - 1, k - 1), Blocks.f_50493_.m_49966_());
        this.setState((LevelWriter)world, new BlockPos(i, j - 1, k + 1), Blocks.f_50493_.m_49966_());
        for (int y = j; y < height; ++y) {
            this.placeLog((LevelSimulatedRW)world, i, y, k);
            this.placeLog((LevelSimulatedRW)world, i - 1, y, k);
            this.placeLog((LevelSimulatedRW)world, i + 1, y, k);
            this.placeLog((LevelSimulatedRW)world, i, y, k - 1);
            this.placeLog((LevelSimulatedRW)world, i, y, k + 1);
        }
        for (int x = 0; x < branches; ++x) {
            int branchHeight = rand.m_188503_(4) + 2 + height;
            int bx = rand.m_188503_(15) - 8 + i;
            int bz = rand.m_188503_(15) - 8 + k;
            this.placeBlockLine((LevelSimulatedRW)world, new int[]{i + this.sign((bx - i) / 2), height, k + this.sign((bz - k) / 2)}, new int[]{bx, branchHeight, bz}, this.getLog());
            this.genCircle((LevelSimulatedRW)world, bx, branchHeight, bz, 2.0, 1.0, this.getLeaf(), false);
            this.genCircle((LevelSimulatedRW)world, bx, branchHeight + 1, bz, 3.0, 2.0, this.getLeaf(), false);
        }
        return true;
    }

    private int sign(int i) {
        return i == 0 ? 0 : (i <= 0 ? -1 : 1);
    }
}

