/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.tree.mangrove;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.stateproviders.RuleBasedBlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.tropicraft.core.common.Util;
import net.tropicraft.core.common.dimension.feature.tree.TropicraftTreeDecorators;

public class ReplaceInSoilDecorator
extends TreeDecorator {
    public static final Codec<ReplaceInSoilDecorator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("count").forGetter(c -> c.count), (App)Codec.INT.fieldOf("spread").forGetter(c -> c.spread), (App)RuleBasedBlockStateProvider.f_225924_.fieldOf("state_provider").forGetter(c -> c.stateProvider), (App)BlockPredicate.f_190392_.fieldOf("target").forGetter(c -> c.target)).apply((Applicative)instance, ReplaceInSoilDecorator::new));
    private final int count;
    private final int spread;
    private final RuleBasedBlockStateProvider stateProvider;
    private final BlockPredicate target;

    public ReplaceInSoilDecorator(int count, int spread, RuleBasedBlockStateProvider stateProvider, BlockPredicate target) {
        this.count = count;
        this.spread = spread;
        this.stateProvider = stateProvider;
        this.target = target;
    }

    protected TreeDecoratorType<?> m_6663_() {
        return (TreeDecoratorType)TropicraftTreeDecorators.REPLACE_IN_SOIL.get();
    }

    public void m_214187_(TreeDecorator.Context context) {
        BlockPos lowestLog = Util.findLowestBlock((List<BlockPos>)context.m_226068_());
        if (lowestLog == null) {
            return;
        }
        WorldGenLevel level = (WorldGenLevel)context.m_226058_();
        RandomSource random = context.m_226067_();
        for (int i = 0; i < this.count; ++i) {
            int x = lowestLog.m_123341_() + random.m_188503_(this.spread) - random.m_188503_(this.spread);
            int z = lowestLog.m_123343_() + random.m_188503_(this.spread) - random.m_188503_(this.spread);
            int y = lowestLog.m_123342_() - random.m_188503_(this.spread);
            BlockPos pos = new BlockPos(x, y, z);
            if (!this.target.test((Object)level, (Object)pos)) continue;
            context.m_226061_(pos, this.stateProvider.m_225932_(level, random, pos));
        }
    }
}

