/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.volcano;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.synth.ImprovedNoise;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.block.VolcanicSandBlock;
import net.tropicraft.core.common.block.VolcanoBlock;
import net.tropicraft.core.common.block.tileentity.VolcanoBlockEntity;
import net.tropicraft.core.common.dimension.feature.jigsaw.piece.TropicraftStructurePieceTypes;

public class VolcanoStructurePiece
extends StructurePiece {
    private static final int CALDERA_CUTOFF = 194;
    private static final int VOLCANO_TOP = 187;
    public static final int VOLCANO_CRUST = 184;
    public static final int LAVA_LEVEL = 149;
    private static final int CRUST_HOLE_CHANCE = 15;
    private static final float STEEPNESS = 10.2f;
    private final int radiusX;
    private final int radiusZ;
    private final long noiseSeed;
    private final ImprovedNoise noise;

    protected VolcanoStructurePiece(LevelHeightAccessor heightAccessor, BlockPos pos, int radiusX, int radiusZ, long noiseSeed) {
        super((StructurePieceType)TropicraftStructurePieceTypes.VOLCANO.get(), 0, VolcanoStructurePiece.boundingBox(heightAccessor, pos, radiusX, radiusZ));
        this.radiusX = radiusX;
        this.radiusZ = radiusZ;
        this.noiseSeed = noiseSeed;
        this.noise = VolcanoStructurePiece.createNoise(noiseSeed);
    }

    public VolcanoStructurePiece(StructurePieceSerializationContext context, CompoundTag tag) {
        super((StructurePieceType)TropicraftStructurePieceTypes.VOLCANO.get(), tag);
        this.radiusX = tag.m_128451_("radius_x");
        this.radiusZ = tag.m_128451_("radius_z");
        this.noiseSeed = tag.m_128454_("noise_seed");
        this.noise = VolcanoStructurePiece.createNoise(this.noiseSeed);
    }

    private static BoundingBox boundingBox(LevelHeightAccessor heightAccessor, BlockPos pos, int radiusX, int radiusZ) {
        return new BoundingBox(pos.m_123341_() - radiusX - 1, pos.m_123342_(), pos.m_123343_() - radiusZ - 1, pos.m_123341_() + radiusX + 1, heightAccessor.m_151558_(), pos.m_123343_() + radiusZ + 1);
    }

    private static ImprovedNoise createNoise(long seed) {
        return new ImprovedNoise(RandomSource.m_216335_((long)seed));
    }

    protected void m_183620_(StructurePieceSerializationContext context, CompoundTag tag) {
        tag.m_128405_("radius_x", this.radiusX);
        tag.m_128405_("radius_z", this.radiusZ);
        tag.m_128356_("noise_seed", this.noiseSeed);
    }

    public void m_213694_(WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, BoundingBox chunkBox, ChunkPos chunkPos, BlockPos pos) {
        int calderaCutoffY = pos.m_123342_() + 194;
        int lavaY = pos.m_123342_() + 149;
        int topY = pos.m_123342_() + 187;
        int crustY = pos.m_123342_() + 184;
        BlockPos corePos = new BlockPos(pos.m_123341_(), level.m_141937_() + 1, pos.m_123343_());
        if (chunkBox.m_71051_((Vec3i)corePos)) {
            level.m_7731_(corePos, ((VolcanoBlock)((Object)TropicraftBlocks.VOLCANO.get())).m_49966_(), 2);
            BlockEntity blockEntity = level.m_7702_(corePos);
            if (blockEntity instanceof VolcanoBlockEntity) {
                VolcanoBlockEntity volcano = (VolcanoBlockEntity)blockEntity;
                volcano.setHeightOffset(pos.m_123342_());
            }
        }
        for (int z = chunkBox.m_162398_(); z <= chunkBox.m_162401_(); ++z) {
            for (int x = chunkBox.m_162395_(); x <= chunkBox.m_162399_(); ++x) {
                float height = this.getColumnHeight(x - pos.m_123341_(), z - pos.m_123343_());
                if (Float.isNaN(height)) continue;
                this.placeColumn(level, random, x, z, calderaCutoffY, lavaY, topY, crustY, height);
            }
        }
    }

    private void placeColumn(WorldGenLevel level, RandomSource random, int x, int z, int calderaCutoffY, int lavaY, int topY, int crustY, float height) {
        BlockState volcanoState = ((Block)TropicraftBlocks.CHUNK.get()).m_49966_();
        BlockState sandState = ((VolcanicSandBlock)((Object)TropicraftBlocks.VOLCANIC_SAND.get())).m_49966_();
        BlockState lavaState = Blocks.f_49991_.m_49966_();
        BlockState airState = Blocks.f_50016_.m_49966_();
        int terrainY = Math.min(level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, x, z), lavaY - 3);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int y = level.m_151558_(); y > level.m_141937_(); --y) {
            mutablePos.m_122178_(x, y, z);
            if (height + (float)terrainY < (float)calderaCutoffY) {
                if (height + (float)terrainY <= (float)topY) {
                    if (!((float)y <= height + (float)terrainY)) continue;
                    if (y > terrainY) {
                        level.m_7731_((BlockPos)mutablePos, volcanoState, 2);
                        continue;
                    }
                    if (y <= terrainY - 2) continue;
                    level.m_7731_((BlockPos)mutablePos, sandState, 2);
                    continue;
                }
                if (y == crustY - 1) {
                    if (random.m_188503_(3) == 0) continue;
                    level.m_7731_((BlockPos)mutablePos, volcanoState, 2);
                    continue;
                }
                if (y > topY) continue;
                level.m_7731_((BlockPos)mutablePos, volcanoState, 2);
                continue;
            }
            if (y == crustY && random.m_188503_(15) != 0) {
                level.m_7731_((BlockPos)mutablePos, volcanoState, 2);
                continue;
            }
            if (y <= lavaY) {
                level.m_7731_((BlockPos)mutablePos, lavaState, 2);
                continue;
            }
            level.m_7731_((BlockPos)mutablePos, airState, 2);
        }
    }

    private float getColumnHeight(float x, float z) {
        float distanceSquared = (float)Mth.m_211589_((double)(x / (float)this.radiusX), (double)(z / (float)this.radiusZ));
        if (distanceSquared >= 1.0f) {
            return Float.NaN;
        }
        float noiseValue = (float)Math.abs(this.noise.m_164308_((double)x * 0.21 + 0.01, 0.0, (double)z * 0.21 + 0.01)) * 0.45f + 1.0f;
        return 10.2f / distanceSquared * noiseValue - 10.2f - 2.0f;
    }
}

