/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.drinks;

import com.tterrag.registrate.providers.RegistrateLangProvider;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.tropicraft.core.common.dimension.TropicraftDimension;
import net.tropicraft.core.common.drinks.DrinkAction;
import net.tropicraft.core.common.drinks.DrinkActionPotion;
import net.tropicraft.core.common.entity.placeable.ChairEntity;
import net.tropicraft.core.common.item.TropicraftItems;

public class Drink {
    public static final Int2ObjectMap<Drink> DRINKS = new Int2ObjectOpenHashMap();
    public static final Drink LEMONADE = new Drink(1, 16440129, "lemonade", ChatFormatting.YELLOW).addAction(new DrinkActionPotion(MobEffects.f_19596_, 5, 1));
    public static final Drink LIMEADE = new Drink(2, 8710282, "limeade", ChatFormatting.GREEN).addAction(new DrinkActionPotion(MobEffects.f_19596_, 5, 1));
    public static final Drink ORANGEADE = new Drink(3, 15973942, "orangeade", ChatFormatting.GOLD).addAction(new DrinkActionPotion(MobEffects.f_19596_, 5, 1));
    public static final Drink CAIPIRINHA = new Drink(4, 9764662, "caipirinha", ChatFormatting.GREEN).addAction(new DrinkActionPotion(MobEffects.f_19596_, 5, 1)).setHasUmbrella(true);
    public static final Drink BLACK_COFFEE = new Drink(5, 6833196, "black_coffee", ChatFormatting.WHITE).addAction(new DrinkActionPotion(MobEffects.f_19605_, 5, 1)).addAction(new DrinkActionPotion(MobEffects.f_19596_, 5, 2));
    public static final Drink PINA_COLADA = new Drink(6, 0xEFEFEF, "pina_colada", ChatFormatting.GOLD).addAction(new DrinkActionPotion(MobEffects.f_19604_, 10, 0)).addAction(new DrinkAction(){

        @Override
        public void onDrink(Player player) {
            if (!player.m_9236_().f_46443_ && this.isSunset(player.m_9236_()) && player.m_20202_() instanceof ChairEntity) {
                TropicraftDimension.teleportPlayerWithPortal((ServerPlayer)player, TropicraftDimension.WORLD);
            }
        }

        private boolean isSunset(Level world) {
            long timeDay = world.m_46468_() % 24000L;
            return timeDay > 12200L && timeDay < 14000L;
        }
    }).setAlwaysEdible(true);
    public static final Drink COCONUT_WATER = new Drink(7, 0xDFDFDF, "coconut_water", ChatFormatting.WHITE).addAction(new DrinkActionPotion(MobEffects.f_19596_, 5, 1));
    public static final Drink MAI_TAI = new Drink(8, 16742190, "mai_tai", ChatFormatting.GOLD).addAction(new DrinkActionPotion(MobEffects.f_19604_, 5, 0));
    public static final Drink COCKTAIL = new Drink(9, 0, "cocktail", ChatFormatting.WHITE);
    public int drinkId;
    public int color;
    public String name;
    public boolean alwaysEdible;
    public boolean hasUmbrella;
    public ChatFormatting textFormatting;
    public List<DrinkAction> actions = new ArrayList<DrinkAction>();

    public Drink(int id, int color, String name, ChatFormatting textFormatting) {
        DRINKS.put(id, (Object)this);
        this.drinkId = id;
        this.color = color;
        this.name = name;
        this.textFormatting = textFormatting;
        this.alwaysEdible = true;
    }

    public Drink setHasUmbrella(boolean has) {
        this.hasUmbrella = has;
        return this;
    }

    public Drink setAlwaysEdible(boolean edible) {
        this.alwaysEdible = edible;
        return this;
    }

    public Drink addAction(DrinkAction action) {
        this.actions.add(action);
        return this;
    }

    public void onDrink(Player player) {
        for (DrinkAction action : this.actions) {
            action.onDrink(player);
        }
    }

    public static boolean isDrink(Item item) {
        return TropicraftItems.COCKTAILS.values().stream().anyMatch(ri -> ri.get() == item);
    }

    public String getName() {
        return this == PINA_COLADA ? "Pi\u00f1a Colada" : RegistrateLangProvider.toEnglishName((String)this.name);
    }
}

