/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai.ashen;

import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.item.ItemStack;
import net.tropicraft.core.common.entity.hostile.AshenEntity;
import net.tropicraft.core.common.item.AshenMaskItem;

public class EntityAIMeleeAndRangedAttack
extends Goal {
    private final AshenEntity entityHost;
    private final RangedAttackMob rangedAttackEntityHost;
    private LivingEntity attackTarget;
    private int rangedAttackTime = -1;
    private final double entityMoveSpeed;
    private int seeTime;
    private final int maxMeleeAttackTime;
    private final int maxRangedAttackTime;
    private final float shootCutoffRange;
    private final float shootCutoffRangeSqr;
    private float meleeHitRange = 2.0f;

    public EntityAIMeleeAndRangedAttack(AshenEntity attacker, double movespeed, int maxMeleeAttackTime, int maxRangedAttackTime, float maxAttackDistanceIn) {
        this(attacker, movespeed, maxMeleeAttackTime, maxRangedAttackTime, maxAttackDistanceIn, 2.0f);
    }

    public EntityAIMeleeAndRangedAttack(AshenEntity attacker, double movespeed, int maxMeleeAttackTime, int maxRangedAttackTime, float maxAttackDistanceIn, float meleeHitRange) {
        this.rangedAttackEntityHost = attacker;
        this.entityHost = attacker;
        this.entityMoveSpeed = movespeed;
        this.maxMeleeAttackTime = maxMeleeAttackTime;
        this.maxRangedAttackTime = maxRangedAttackTime;
        this.shootCutoffRange = maxAttackDistanceIn;
        this.shootCutoffRangeSqr = maxAttackDistanceIn * maxAttackDistanceIn;
        this.meleeHitRange = meleeHitRange;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity entitylivingbase = this.entityHost.m_21188_();
        if (entitylivingbase == null) {
            return false;
        }
        this.attackTarget = entitylivingbase;
        return true;
    }

    public boolean m_8045_() {
        return this.m_8036_() || !this.entityHost.m_21573_().m_26571_();
    }

    public void m_8041_() {
        this.attackTarget = null;
        this.seeTime = 0;
        this.rangedAttackTime = -1;
    }

    public void m_8037_() {
        ItemStack headGear;
        if (this.attackTarget != null && (headGear = this.attackTarget.m_6844_(EquipmentSlot.HEAD)).m_41720_() instanceof AshenMaskItem) {
            return;
        }
        double d0 = this.entityHost.m_20275_(this.attackTarget.m_20185_(), this.attackTarget.m_20191_().f_82289_, this.attackTarget.m_20189_());
        boolean flag = this.entityHost.m_21574_().m_148306_((Entity)this.attackTarget);
        this.seeTime = flag ? ++this.seeTime : 0;
        if (!(d0 <= (double)this.shootCutoffRangeSqr) || this.seeTime >= 20) {
            // empty if block
        }
        if (this.seeTime >= 20) {
            this.entityHost.m_21573_().m_5624_((Entity)this.attackTarget, this.entityMoveSpeed);
        }
        this.entityHost.m_21563_().m_24960_((Entity)this.attackTarget, 30.0f, 30.0f);
        if (--this.rangedAttackTime <= 0) {
            float f;
            float f1 = f = Mth.m_14116_((float)((float)d0)) / this.shootCutoffRange;
            if (f < 0.1f) {
                f1 = 0.1f;
            }
            if (f1 > 1.0f) {
                f1 = 1.0f;
            }
            if (d0 >= (double)this.shootCutoffRange * (double)this.shootCutoffRange) {
                this.rangedAttackEntityHost.m_6504_(this.attackTarget, f1);
                this.rangedAttackTime = this.maxRangedAttackTime;
            } else if (d0 <= (double)(this.meleeHitRange * this.meleeHitRange)) {
                this.entityHost.m_7327_((Entity)this.attackTarget);
                this.entityHost.m_6674_(InteractionHand.MAIN_HAND);
                this.rangedAttackTime = this.maxMeleeAttackTime;
            }
        }
    }
}

