/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.neutral;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.TierSortingRegistry;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.entity.hostile.TropicraftCreatureEntity;
import net.tropicraft.core.common.sound.Sounds;

public class EIHEntity
extends TropicraftCreatureEntity {
    private static final EntityDataAccessor<Byte> STATE = SynchedEntityData.m_135353_(EIHEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public int FLAG_SLEEP = 1;
    public int FLAG_AWARE = 2;
    public int FLAG_ANGRY = 4;

    public EIHEntity(EntityType<? extends PathfinderMob> type, Level world) {
        super(type, world);
        this.f_21364_ = 10;
    }

    public void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(STATE, (Object)0);
    }

    public byte getState() {
        return (Byte)this.m_20088_().m_135370_(STATE);
    }

    private void setState(byte state) {
        this.m_20088_().m_135381_(STATE, (Object)state);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return PathfinderMob.m_21552_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22278_, 100.0).m_22268_(Attributes.f_22281_, 7.0);
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal(this, 1.0, false){

            public boolean m_8036_() {
                if (!EIHEntity.this.isAngry()) {
                    return false;
                }
                return super.m_8036_();
            }
        });
        LeapAtTargetGoal leap = new LeapAtTargetGoal((Mob)this, 0.4f);
        this.f_21345_.m_25352_(3, (Goal)leap);
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal(this, 0.8){

            public boolean m_8036_() {
                if (!EIHEntity.this.isAngry()) {
                    return false;
                }
                return super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new TargetAggressorGoal(this));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128344_("State", this.getState());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setState(compound.m_128445_("State"));
    }

    public int m_5792_() {
        return 1;
    }

    public void m_6075_() {
        super.m_6075_();
        if (this.isAsleep()) {
            this.m_20256_(Vec3.f_82478_);
        }
        if (!this.isAsleep()) {
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
        if (this.f_19797_ % 20 == 0) {
            LivingEntity attackTarget = this.m_5448_();
            if (attackTarget == null) {
                Player closestPlayer = this.m_9236_().m_45930_((Entity)this, 10.0);
                if (closestPlayer != null && !closestPlayer.m_150110_().f_35937_ && !closestPlayer.m_5833_()) {
                    this.m_6710_((LivingEntity)closestPlayer);
                }
            } else if (this.m_20270_((Entity)attackTarget) > 16.0f) {
                this.m_6710_(null);
                this.setAwake(false);
                this.setImmobile(true);
                this.setAngry(false);
            }
            if (attackTarget != null && !this.m_21691_() && !this.isAngry() && attackTarget instanceof Player) {
                Player player = (Player)attackTarget;
                if (!player.m_150110_().f_35937_ && !player.m_5833_()) {
                    float distance = this.m_20270_((Entity)player);
                    if (distance < 10.0f) {
                        this.setAwake(true);
                        ItemStack itemstack = player.m_150109_().m_36056_();
                        if (!itemstack.m_41619_() && this.isAware() && itemstack.m_41720_() == ((Block)TropicraftBlocks.CHUNK.get()).m_5456_()) {
                            this.setAngry(true);
                            this.setImmobile(false);
                        }
                    }
                    if (this.m_20270_((Entity)player) < 3.0f && this.m_9236_().m_46791_() != Difficulty.PEACEFUL) {
                        this.setAwake(false);
                        this.setImmobile(false);
                        this.setAngry(true);
                    }
                } else {
                    this.setImmobile(true);
                    this.setAngry(false);
                    this.setAwake(false);
                    this.m_20334_(0.0, -0.1, 0.0);
                    this.m_19915_(this.f_19859_, this.f_19860_);
                }
            }
            if (this.isAsleep()) {
                this.m_19915_(this.f_19859_, this.f_19860_);
            } else {
                this.setAwake(false);
            }
        }
    }

    public boolean isAngry() {
        return this.getEIHFlag(this.FLAG_ANGRY);
    }

    public void setAngry(boolean angry) {
        this.setEIHFlag(this.FLAG_ANGRY, angry);
    }

    public boolean isAware() {
        return this.getEIHFlag(this.FLAG_AWARE);
    }

    public void setAwake(boolean aware) {
        this.setEIHFlag(this.FLAG_AWARE, aware);
    }

    public boolean isAsleep() {
        return this.getEIHFlag(this.FLAG_SLEEP);
    }

    public void setImmobile(boolean asleep) {
        this.setEIHFlag(this.FLAG_SLEEP, asleep);
    }

    public void setEIHFlag(int id, boolean flag) {
        if (flag) {
            this.f_19804_.m_135381_(STATE, (Object)((byte)((Byte)this.f_19804_.m_135370_(STATE) | id)));
        } else {
            this.f_19804_.m_135381_(STATE, (Object)((byte)((Byte)this.f_19804_.m_135370_(STATE) & ~id)));
        }
    }

    private boolean getEIHFlag(int id) {
        return ((Byte)this.f_19804_.m_135370_(STATE) & id) != 0;
    }

    protected SoundEvent m_7515_() {
        if (this.isAware()) {
            return this.f_19796_.m_188503_(10) == 0 ? (SoundEvent)Sounds.HEAD_MED.get() : null;
        }
        if (this.isAngry()) {
            return this.f_19796_.m_188503_(10) == 0 ? (SoundEvent)Sounds.HEAD_SHORT.get() : null;
        }
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)Sounds.HEAD_PAIN.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Sounds.HEAD_DEATH.get();
    }

    protected float m_6121_() {
        return 0.4f;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_269533_(DamageTypeTags.f_268738_)) {
            return super.m_6469_(source, amount);
        }
        Entity entity = source.m_7640_();
        if (entity instanceof Player) {
            PickaxeItem pickaxe;
            Item item;
            Player player = (Player)entity;
            if (player.m_150110_().f_35937_ || player.m_5833_()) {
                return super.m_6469_(source, amount);
            }
            ItemStack heldItem = player.m_21205_();
            if (!heldItem.m_41619_() && (item = heldItem.m_41720_()) instanceof PickaxeItem && EIHEntity.isValidPickaxeTier((pickaxe = (PickaxeItem)item).m_43314_())) {
                return super.m_6469_(source, amount);
            }
            this.m_5496_((SoundEvent)Sounds.HEAD_LAUGHING.get(), this.m_6121_(), this.m_6100_());
            this.m_6703_((LivingEntity)player);
            this.setAngry(true);
            this.setImmobile(false);
        }
        return true;
    }

    private static boolean isValidPickaxeTier(Tier tier) {
        List sorted = TierSortingRegistry.getSortedTiers();
        return sorted.indexOf(tier) >= sorted.indexOf(Tiers.STONE);
    }

    private static class TargetAggressorGoal
    extends NearestAttackableTargetGoal<Player> {
        public TargetAggressorGoal(EIHEntity eih) {
            super((Mob)eih, Player.class, true);
        }

        public boolean m_8036_() {
            return ((EIHEntity)this.f_26135_).isAngry() && super.m_8036_();
        }
    }
}

