/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.passive;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.entity.passive.EntityKoaBase;

public class FishingBobberEntity
extends Entity
implements IEntityAdditionalSpawnData {
    private static final EntityDataAccessor<Integer> DATA_HOOKED_ENTITY = SynchedEntityData.m_135353_(FishingBobberEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private boolean inGround;
    private int ticksInGround;
    private EntityKoaBase angler;
    private int ticksInAir;
    private int ticksCatchable;
    private int ticksCaughtDelay;
    private int ticksCatchableDelay;
    private float fishApproachAngle;
    public Entity caughtEntity;
    private State currentState = State.FLYING;
    private int luck;
    private int lureSpeed;

    private FishingBobberEntity(Level p_i50219_1_, EntityKoaBase koaBase, int luck, int lureSpeed) {
        super((EntityType)TropicraftEntities.FISHING_BOBBER.get(), p_i50219_1_);
        this.f_19811_ = true;
        this.angler = koaBase;
        this.angler.setLure(this);
        this.luck = Math.max(0, luck);
        this.lureSpeed = Math.max(0, lureSpeed);
    }

    public FishingBobberEntity(EntityKoaBase p_i50220_1_, Level p_i50220_2_, int p_i50220_3_, int p_i50220_4_) {
        this(p_i50220_2_, p_i50220_1_, p_i50220_3_, p_i50220_4_);
        float f = this.angler.m_146909_();
        float f1 = this.angler.m_146908_();
        float f2 = Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        double d0 = this.angler.m_20185_() - (double)f3 * 0.3;
        double d1 = this.angler.m_20186_() + (double)this.angler.m_20192_();
        double d2 = this.angler.m_20189_() - (double)f2 * 0.3;
        this.m_7678_(d0, d1, d2, f1, f);
        Vec3 Vector3d = new Vec3((double)(-f3), (double)Mth.m_14036_((float)(-(f5 / f4)), (float)-5.0f, (float)5.0f), (double)(-f2));
        double d3 = Vector3d.m_82553_();
        Vector3d = Vector3d.m_82542_(0.6 / d3 + 0.5 + this.f_19796_.m_188583_() * 0.0045, 0.6 / d3 + 0.5 + this.f_19796_.m_188583_() * 0.0045, 0.6 / d3 + 0.5 + this.f_19796_.m_188583_() * 0.0045);
        this.m_20256_(Vector3d);
        this.m_146922_((float)(Mth.m_14136_((double)Vector3d.f_82479_, (double)Vector3d.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)Vector3d.f_82480_, (double)Mth.m_14116_((float)((float)this.m_20238_(Vector3d)))) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    public FishingBobberEntity(EntityType<FishingBobberEntity> type, Level world) {
        super(type, world);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_HOOKED_ENTITY, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (DATA_HOOKED_ENTITY.equals(key)) {
            int i = (Integer)this.m_20088_().m_135370_(DATA_HOOKED_ENTITY);
            this.caughtEntity = i > 0 ? this.m_9236_().m_6815_(i - 1) : null;
        }
        super.m_7350_(key);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6783_(double distance) {
        double d0 = 64.0;
        return distance < 4096.0;
    }

    public AABB m_6921_() {
        return this.m_20191_().m_82377_(8.0, 5.0, 8.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6453_(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.angler == null) {
            if (this.f_19797_ > 40) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            return;
        }
        if (this.angler == null) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        } else if (this.m_9236_().f_46443_ || !this.shouldStopFishing()) {
            if (this.inGround) {
                ++this.ticksInGround;
                if (this.ticksInGround >= 1200) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                    return;
                }
            }
            float f = 0.0f;
            BlockPos blockpos = this.m_20183_();
            FluidState ifluidstate = this.m_9236_().m_6425_(blockpos);
            if (ifluidstate.m_205070_(FluidTags.f_13131_)) {
                f = ifluidstate.m_76155_((BlockGetter)this.m_9236_(), blockpos);
            }
            if (this.currentState == State.FLYING) {
                if (this.caughtEntity != null) {
                    this.m_20256_(Vec3.f_82478_);
                    this.currentState = State.HOOKED_IN_ENTITY;
                    return;
                }
                if (f > 0.0f) {
                    this.m_20256_(this.m_20184_().m_82542_(0.3, 0.2, 0.3));
                    this.currentState = State.BOBBING;
                    return;
                }
                if (!this.m_9236_().f_46443_) {
                    this.checkCollision();
                }
                if (!(this.inGround || this.m_20096_() || this.f_19862_)) {
                    ++this.ticksInAir;
                } else {
                    this.ticksInAir = 0;
                    this.m_20256_(Vec3.f_82478_);
                }
            } else {
                if (this.currentState == State.HOOKED_IN_ENTITY) {
                    if (this.caughtEntity != null) {
                        if (this.caughtEntity.m_213877_()) {
                            this.caughtEntity = null;
                            this.currentState = State.FLYING;
                        } else {
                            this.m_6034_(this.caughtEntity.m_20185_(), this.caughtEntity.m_20191_().f_82289_ + (double)this.caughtEntity.m_20206_() * 0.8, this.caughtEntity.m_20189_());
                            this.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                        }
                    }
                    return;
                }
                if (this.currentState == State.BOBBING) {
                    Vec3 Vector3d = this.m_20184_();
                    double d0 = this.m_20186_() + Vector3d.f_82480_ - (double)blockpos.m_123342_() - (double)f;
                    if (Math.abs(d0) < 0.01) {
                        d0 += Math.signum(d0) * 0.1;
                    }
                    this.m_20334_(Vector3d.f_82479_ * 0.9, Vector3d.f_82480_ - d0 * (double)this.f_19796_.m_188501_() * 0.2, Vector3d.f_82481_ * 0.9);
                    if (!this.m_9236_().f_46443_ && f > 0.0f) {
                        this.catchingFish(blockpos);
                    }
                }
            }
            if (!ifluidstate.m_205070_(FluidTags.f_13131_)) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.03, 0.0));
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.updateRotation();
            double d1 = 0.92;
            this.m_20256_(this.m_20184_().m_82490_(0.92));
            this.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
    }

    private boolean shouldStopFishing() {
        ItemStack itemstack = this.angler.m_21205_();
        ItemStack itemstack1 = this.angler.m_21206_();
        boolean flag = itemstack.m_41720_() instanceof FishingRodItem;
        boolean flag1 = itemstack1.m_41720_() instanceof FishingRodItem;
        if (!this.angler.m_213877_() && this.angler.m_6084_() && (flag || flag1) && !(this.m_20280_((Entity)this.angler) > 1024.0)) {
            return false;
        }
        this.m_142687_(Entity.RemovalReason.DISCARDED);
        return true;
    }

    private void updateRotation() {
        Vec3 Vector3d = this.m_20184_();
        float f = Mth.m_14116_((float)((float)this.m_20238_(Vector3d)));
        this.m_146922_((float)(Mth.m_14136_((double)Vector3d.f_82479_, (double)Vector3d.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)Vector3d.f_82480_, (double)f) * 57.2957763671875));
        while (this.m_146909_() - this.f_19860_ < -180.0f) {
            this.f_19860_ -= 360.0f;
        }
        while (this.m_146909_() - this.f_19860_ >= 180.0f) {
            this.f_19860_ += 360.0f;
        }
        while (this.m_146908_() - this.f_19859_ < -180.0f) {
            this.f_19859_ -= 360.0f;
        }
        while (this.m_146908_() - this.f_19859_ >= 180.0f) {
            this.f_19859_ += 360.0f;
        }
        this.m_146926_(Mth.m_14179_((float)0.2f, (float)this.f_19860_, (float)this.m_146909_()));
        this.m_146922_(Mth.m_14179_((float)0.2f, (float)this.f_19859_, (float)this.m_146908_()));
    }

    private void checkCollision() {
        HitResult result = ProjectileUtil.m_278158_((Entity)this, entity -> !(entity.m_5833_() || !entity.m_6087_() && !(entity instanceof ItemEntity) || entity == this.angler && this.ticksInAir < 5));
        if (result.m_6662_() != HitResult.Type.MISS) {
            if (result.m_6662_() == HitResult.Type.ENTITY) {
                this.caughtEntity = ((EntityHitResult)result).m_82443_();
                this.setHookedEntity();
            } else {
                this.inGround = true;
            }
        }
    }

    private void setHookedEntity() {
        this.m_20088_().m_135381_(DATA_HOOKED_ENTITY, (Object)(this.caughtEntity.m_19879_() + 1));
    }

    private void catchingFish(BlockPos p_190621_1_) {
        ServerLevel level = (ServerLevel)this.m_9236_();
        int i = 1;
        BlockPos blockpos = p_190621_1_.m_7494_();
        if (this.f_19796_.m_188501_() < 0.25f && this.m_9236_().m_46758_(blockpos)) {
            ++i;
        }
        if (this.f_19796_.m_188501_() < 0.5f && !this.m_9236_().m_46861_(blockpos)) {
            --i;
        }
        if (this.ticksCatchable > 0) {
            --this.ticksCatchable;
            if (this.ticksCatchable <= 0) {
                this.ticksCaughtDelay = 0;
                this.ticksCatchableDelay = 0;
            } else {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.2 * (double)this.f_19796_.m_188501_() * (double)this.f_19796_.m_188501_(), 0.0));
            }
        } else if (this.ticksCatchableDelay > 0) {
            this.ticksCatchableDelay -= i;
            if (this.ticksCatchableDelay > 0) {
                double d2;
                double d1;
                this.fishApproachAngle = (float)((double)this.fishApproachAngle + this.f_19796_.m_188583_() * 4.0);
                float f = this.fishApproachAngle * ((float)Math.PI / 180);
                float f1 = Mth.m_14031_((float)f);
                float f2 = Mth.m_14089_((float)f);
                double d0 = this.m_20185_() + (double)(f1 * (float)this.ticksCatchableDelay * 0.1f);
                if (level.m_6425_(BlockPos.m_274561_((double)d0, (double)((d1 = (double)((float)Mth.m_14107_((double)this.m_20191_().f_82289_) + 1.0f)) - 1.0), (double)(d2 = this.m_20185_() + (double)(f2 * (float)this.ticksCatchableDelay * 0.1f)))).m_205070_(FluidTags.f_13131_)) {
                    if (this.f_19796_.m_188501_() < 0.15f) {
                        level.m_8767_((ParticleOptions)ParticleTypes.f_123795_, d0, d1 - (double)0.1f, d2, 1, (double)f1, 0.1, (double)f2, 0.0);
                    }
                    float f3 = f1 * 0.04f;
                    float f4 = f2 * 0.04f;
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123816_, d0, d1, d2, 0, (double)f4, 0.01, (double)(-f3), 1.0);
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123816_, d0, d1, d2, 0, (double)(-f4), 0.01, (double)f3, 1.0);
                }
            } else {
                Vec3 Vector3d = this.m_20184_();
                this.m_20334_(Vector3d.f_82479_, -0.4f * Mth.m_216267_((RandomSource)this.f_19796_, (float)0.6f, (float)1.0f), Vector3d.f_82481_);
                this.m_5496_(SoundEvents.f_11940_, 0.25f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.4f);
                double d3 = this.m_20191_().f_82289_ + 0.5;
                level.m_8767_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_(), d3, this.m_20189_(), (int)(1.0f + this.m_20205_() * 20.0f), (double)this.m_20205_(), 0.0, (double)this.m_20205_(), (double)0.2f);
                level.m_8767_((ParticleOptions)ParticleTypes.f_123816_, this.m_20185_(), d3, this.m_20189_(), (int)(1.0f + this.m_20205_() * 20.0f), (double)this.m_20205_(), 0.0, (double)this.m_20205_(), (double)0.2f);
                this.ticksCatchable = Mth.m_216271_((RandomSource)this.f_19796_, (int)20, (int)40);
            }
        } else if (this.ticksCaughtDelay > 0) {
            this.ticksCaughtDelay -= i;
            float f5 = 0.15f;
            if (this.ticksCaughtDelay < 20) {
                f5 = (float)((double)f5 + (double)(20 - this.ticksCaughtDelay) * 0.05);
            } else if (this.ticksCaughtDelay < 40) {
                f5 = (float)((double)f5 + (double)(40 - this.ticksCaughtDelay) * 0.02);
            } else if (this.ticksCaughtDelay < 60) {
                f5 = (float)((double)f5 + (double)(60 - this.ticksCaughtDelay) * 0.01);
            }
            if (this.f_19796_.m_188501_() < f5) {
                double d6;
                double d5;
                float f6 = Mth.m_216267_((RandomSource)this.f_19796_, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float f7 = Mth.m_216267_((RandomSource)this.f_19796_, (float)25.0f, (float)60.0f);
                double d4 = this.m_20185_() + (double)(Mth.m_14031_((float)f6) * f7 * 0.1f);
                if (level.m_6425_(BlockPos.m_274561_((double)d4, (double)((d5 = (double)((float)Mth.m_14107_((double)this.m_20191_().f_82289_) + 1.0f)) - 1.0), (double)(d6 = this.m_20189_() + (double)(Mth.m_14089_((float)f6) * f7 * 0.1f)))).m_205070_(FluidTags.f_13131_)) {
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123769_, d4, d5, d6, 2 + this.f_19796_.m_188503_(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                }
            }
            if (this.ticksCaughtDelay <= 0) {
                this.fishApproachAngle = Mth.m_216267_((RandomSource)this.f_19796_, (float)0.0f, (float)360.0f);
                this.ticksCatchableDelay = Mth.m_216271_((RandomSource)this.f_19796_, (int)20, (int)80);
            }
        } else {
            this.ticksCaughtDelay = Mth.m_216271_((RandomSource)this.f_19796_, (int)100, (int)600);
            this.ticksCaughtDelay -= this.lureSpeed * 20 * 5;
        }
    }

    public void m_7380_(CompoundTag compound) {
    }

    public void m_7378_(CompoundTag compound) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 31 && this.m_9236_().f_46443_ && this.caughtEntity instanceof Player && ((Player)this.caughtEntity).m_7578_()) {
            this.bringInHookedEntity();
        }
        super.m_7822_(id);
    }

    protected void bringInHookedEntity() {
        if (this.angler != null) {
            Vec3 Vector3d = new Vec3(this.angler.m_20185_() - this.m_20185_(), this.angler.m_20186_() - this.m_20186_(), this.angler.m_20189_() - this.m_20189_()).m_82490_(0.1);
            this.caughtEntity.m_20256_(this.caughtEntity.m_20184_().m_82549_(Vector3d));
        }
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public void m_142687_(Entity.RemovalReason reason) {
        super.m_142687_(reason);
        if (this.angler != null) {
            this.angler.setLure(null);
        }
    }

    @Nullable
    public EntityKoaBase getAngler() {
        return this.angler;
    }

    public boolean m_6072_() {
        return false;
    }

    public void writeSpawnData(FriendlyByteBuf data) {
        EntityKoaBase entity = this.getAngler();
        data.writeInt(entity == null ? -1 : entity.m_19879_());
    }

    public void readSpawnData(FriendlyByteBuf data) {
        Entity entity;
        int anglerID = data.readInt();
        if (anglerID != -1 && (entity = this.m_9236_().m_6815_(anglerID)) instanceof EntityKoaBase) {
            this.angler = (EntityKoaBase)entity;
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return AbstractFish.m_27495_().m_22268_(Attributes.f_22276_, 10.0);
    }

    static enum State {
        FLYING,
        HOOKED_IN_ENTITY,
        BOBBING;

    }
}

