/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.passive;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class HummingbirdEntity
extends Animal
implements FlyingAnimal {
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    private static final int POLLINATE_THRESHOLD = 5;
    private int pollenCollected;

    public HummingbirdEntity(EntityType<? extends HummingbirdEntity> type, Level world) {
        super(type, world);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.COCOA, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.FENCE, -1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22280_, 0.4).m_22268_(Attributes.f_22279_, 0.2);
    }

    protected PathNavigation m_6037_(Level world) {
        FlyingPathNavigation navigator = new FlyingPathNavigation((Mob)this, world);
        navigator.m_26440_(false);
        navigator.m_7008_(true);
        navigator.m_26443_(true);
        return navigator;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new FlyAwayInPanicGoal());
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42501_}), false));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new FeedFromPlantsGoal());
        this.f_21345_.m_25352_(5, (Goal)new FlyAroundRandomlyGoal());
    }

    public static boolean canHummingbirdSpawnOn(EntityType<HummingbirdEntity> type, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        BlockState groundState = world.m_8055_(pos.m_7495_());
        return (groundState.m_204336_(BlockTags.f_13035_) || groundState.m_60713_(Blocks.f_50440_) || groundState.m_60795_()) && world.m_45524_(pos, 0) > 8;
    }

    public boolean m_29443_() {
        return !this.m_20096_();
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    protected void m_7840_(double y, boolean onGround, BlockState state, BlockPos pos) {
    }

    public boolean m_6898_(ItemStack stack) {
        return false;
    }

    public HummingbirdEntity getBreedOffspring(ServerLevel world, AgeableMob mate) {
        return null;
    }

    private void tryPollinatePlant(BlockPos pos) {
        if (++this.pollenCollected >= 5) {
            this.pollenCollected = 0;
            this.tryGrowPlant(pos);
        }
    }

    private void tryGrowPlant(BlockPos pos) {
        BlockState state = this.m_9236_().m_8055_(pos);
        IntegerProperty age = this.getPlantAgeProperty(state);
        if (age != null) {
            int nextAge = (Integer)state.m_61143_((Property)age) + 1;
            if (age.m_6908_().contains(nextAge)) {
                this.m_9236_().m_46796_(2005, pos, 0);
                this.m_9236_().m_46597_(pos, (BlockState)state.m_61124_((Property)age, (Comparable)Integer.valueOf(nextAge)));
            }
        }
    }

    @Nullable
    private IntegerProperty getPlantAgeProperty(BlockState state) {
        if (state.m_61138_((Property)BlockStateProperties.f_61407_)) {
            return BlockStateProperties.f_61407_;
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61409_)) {
            return BlockStateProperties.f_61409_;
        }
        return null;
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128344_("pollen_collected", (byte)this.pollenCollected);
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.pollenCollected = nbt.m_128445_("pollen_collected");
    }

    final class FlyAwayInPanicGoal
    extends FlyingGoal {
        FlyAwayInPanicGoal() {
            super(1.25f);
        }

        @Override
        public boolean m_8036_() {
            return HummingbirdEntity.this.m_21188_() != null;
        }

        @Override
        @Nullable
        Vec3 generateTarget() {
            LivingEntity target = HummingbirdEntity.this.m_21188_();
            if (target == null) {
                return null;
            }
            Vec3 direction = HummingbirdEntity.this.m_20182_().m_82546_(target.m_20182_()).m_82541_();
            return this.generateTargetInDirection(direction, 1.5707963267948966);
        }
    }

    final class FeedFromPlantsGoal
    extends FlyingGoal {
        private static final int SEARCH_TRIES = 50;
        private static final int SEARCH_RADIUS = 5;
        private static final int SEARCH_RADIUS_Y = 3;
        private static final int FEEDING_TICKS = 80;
        private int feedingTicks;
        private boolean foundFood;

        FeedFromPlantsGoal() {
            super(1.0f);
        }

        @Override
        public boolean m_8036_() {
            HummingbirdEntity bird = HummingbirdEntity.this;
            return bird.f_21344_.m_26571_() && bird.f_19796_.m_188503_(20) == 0;
        }

        @Override
        public boolean m_8045_() {
            return this.feedingTicks > 0 || HummingbirdEntity.this.m_21691_();
        }

        @Override
        public void m_8041_() {
            super.m_8041_();
            this.feedingTicks = 0;
            this.foundFood = false;
        }

        public void m_8037_() {
            super.m_8037_();
            Vec3 target = this.target;
            if (target != null) {
                if (this.foundFood) {
                    this.tickFoundFood(target);
                } else {
                    this.tickFindingFood(target);
                }
            }
        }

        private void tickFoundFood(Vec3 target) {
            if (this.feedingTicks > 0) {
                HummingbirdEntity bird = HummingbirdEntity.this;
                bird.f_21365_.m_24964_(target);
                if (--this.feedingTicks == 0) {
                    bird.tryPollinatePlant(BlockPos.m_274446_((Position)target));
                }
            }
        }

        private void tickFindingFood(Vec3 target) {
            if (HummingbirdEntity.this.m_20238_(target) <= 2.25) {
                this.feedingTicks = 80;
                this.foundFood = true;
            }
        }

        @Override
        @Nullable
        Vec3 generateTarget() {
            HummingbirdEntity bird = HummingbirdEntity.this;
            Level world = bird.m_9236_();
            RandomSource random = bird.f_19796_;
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            for (int i = 0; i < 50; ++i) {
                mutablePos.m_122154_((Vec3i)bird.m_20183_(), random.m_188503_(5) - random.m_188503_(5), random.m_188503_(3) - random.m_188503_(3), random.m_188503_(5) - random.m_188503_(5));
                BlockState state = world.m_8055_((BlockPos)mutablePos);
                if (!this.canFeedFrom(world, (BlockPos)mutablePos, state)) continue;
                return Vec3.m_82512_((Vec3i)mutablePos);
            }
            return null;
        }

        private boolean canFeedFrom(Level world, BlockPos pos, BlockState state) {
            if (this.canFeedFrom(state)) {
                BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
                for (Direction direction : HORIZONTALS) {
                    mutablePos.m_122159_((Vec3i)pos, direction);
                    if (!world.m_46859_((BlockPos)mutablePos)) continue;
                    return true;
                }
                return false;
            }
            return false;
        }

        private boolean canFeedFrom(BlockState state) {
            if (state.m_60795_()) {
                return false;
            }
            return state.m_204336_(BlockTags.f_13035_) || state.m_204336_(BlockTags.f_13041_) || state.m_204336_(BlockTags.f_13074_);
        }
    }

    final class FlyAroundRandomlyGoal
    extends FlyingGoal {
        FlyAroundRandomlyGoal() {
            super(1.0f);
        }

        @Override
        public boolean m_8036_() {
            HummingbirdEntity bird = HummingbirdEntity.this;
            return bird.f_21344_.m_26571_() && bird.f_19796_.m_188503_(10) == 0;
        }

        @Override
        @Nullable
        Vec3 generateTarget() {
            Vec3 direction = HummingbirdEntity.this.m_20252_(1.0f);
            return this.generateTargetInDirection(direction, 1.5707963267948966);
        }
    }

    abstract class FlyingGoal
    extends Goal {
        final float speed;
        Vec3 target;

        FlyingGoal(float speed) {
            this.speed = speed;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return HummingbirdEntity.this.f_21344_.m_26571_();
        }

        public boolean m_8045_() {
            return HummingbirdEntity.this.f_21344_.m_26572_();
        }

        public void m_8056_() {
            this.target = this.generateTarget();
            if (this.target != null) {
                Path path = HummingbirdEntity.this.f_21344_.m_7864_(BlockPos.m_274446_((Position)this.target), 1);
                HummingbirdEntity.this.f_21344_.m_26536_(path, (double)this.speed);
            }
        }

        public void m_8041_() {
            this.target = null;
        }

        @Nullable
        abstract Vec3 generateTarget();

        @Nullable
        final Vec3 generateTargetInDirection(Vec3 direction, double maxAngle) {
            Vec3 target = HoverRandomPos.m_148465_((PathfinderMob)HummingbirdEntity.this, (int)8, (int)7, (double)direction.f_82479_, (double)direction.f_82481_, (float)((float)maxAngle), (int)2, (int)1);
            return target != null ? target : AirAndWaterRandomPos.m_148357_((PathfinderMob)HummingbirdEntity.this, (int)8, (int)4, (int)-2, (double)direction.f_82479_, (double)direction.f_82481_, (double)((float)maxAngle));
        }
    }
}

