/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.passive;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.tropicraft.core.common.Easings;
import net.tropicraft.core.common.TropicraftTags;

public class ToucanEntity
extends Animal
implements FlyingAnimal {
    private static final int FLIGHT_ANIMATION_LENGTH = 5;
    private int flightAnimation;
    private int lastFlightAnimation;

    public ToucanEntity(EntityType<? extends ToucanEntity> type, Level world) {
        super(type, world);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, false);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.COCOA, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.FENCE, -1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22280_, 0.4).m_22268_(Attributes.f_22279_, 0.2);
    }

    protected PathNavigation m_6037_(Level world) {
        FlyingPathNavigation navigator = new FlyingPathNavigation((Mob)this, world);
        navigator.m_26440_(false);
        navigator.m_7008_(true);
        navigator.m_26443_(true);
        return navigator;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_204132_(TropicraftTags.Items.FRUITS), false));
        this.f_21345_.m_25352_(3, (Goal)new WanderGoal((PathfinderMob)this, 1.0));
    }

    public static boolean canToucanSpawnOn(EntityType<ToucanEntity> type, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        BlockState groundState = world.m_8055_(pos.m_7495_());
        return (groundState.m_204336_(BlockTags.f_13035_) || groundState.m_60713_(Blocks.f_50440_) || groundState.m_60795_()) && world.m_45524_(pos, 0) > 8;
    }

    public void m_8119_() {
        super.m_8119_();
        int targetFlightAnimation = this.m_29443_() ? 5 : 0;
        this.lastFlightAnimation = this.flightAnimation;
        if (targetFlightAnimation > this.flightAnimation) {
            ++this.flightAnimation;
        } else if (targetFlightAnimation < this.flightAnimation) {
            --this.flightAnimation;
        }
    }

    public float getFlightAnimation(float partialTicks) {
        float animation = Mth.m_14179_((float)partialTicks, (float)this.lastFlightAnimation, (float)this.flightAnimation) / 5.0f;
        return Easings.inOutSine(animation);
    }

    public boolean m_29443_() {
        return !this.m_20096_();
    }

    public boolean m_6898_(ItemStack stack) {
        return false;
    }

    public ToucanEntity getBreedOffspring(ServerLevel world, AgeableMob mate) {
        return null;
    }

    public int m_6056_() {
        return 1;
    }

    public static class WanderGoal
    extends WaterAvoidingRandomFlyingGoal {
        private static final int TREE_HORIZONTAL_RANGE = 3;
        private static final int TREE_VERTICAL_RANGE = 6;

        public WanderGoal(PathfinderMob mob, double speed) {
            super(mob, speed);
        }

        @Nullable
        protected Vec3 m_7037_() {
            Vec3 target = null;
            if (this.f_25725_.m_20069_()) {
                target = LandRandomPos.m_148488_((PathfinderMob)this.f_25725_, (int)15, (int)15);
            }
            if (this.f_25725_.m_217043_().m_188501_() >= this.f_25985_) {
                target = this.findTreePos();
            }
            return target == null ? super.m_7037_() : target;
        }

        @Nullable
        private Vec3 findTreePos() {
            Level level = this.f_25725_.m_9236_();
            BlockPos currentPos = this.f_25725_.m_20183_();
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            for (BlockPos pos : BlockPos.m_121976_((int)Mth.m_14107_((double)(this.f_25725_.m_20185_() - 3.0)), (int)Mth.m_14107_((double)(this.f_25725_.m_20186_() - 6.0)), (int)Mth.m_14107_((double)(this.f_25725_.m_20189_() - 3.0)), (int)Mth.m_14107_((double)(this.f_25725_.m_20185_() + 3.0)), (int)Mth.m_14107_((double)(this.f_25725_.m_20186_() + 6.0)), (int)Mth.m_14107_((double)(this.f_25725_.m_20189_() + 3.0)))) {
                BlockState belowState;
                if (currentPos.equals((Object)pos) || !(belowState = level.m_8055_((BlockPos)mutablePos.m_122159_((Vec3i)pos, Direction.DOWN))).m_204336_(BlockTags.f_13035_) && !belowState.m_204336_(BlockTags.f_13106_)) continue;
                BlockPos.MutableBlockPos abovePos = mutablePos.m_122159_((Vec3i)pos, Direction.UP);
                if (!level.m_46859_(pos) || !level.m_46859_((BlockPos)abovePos)) continue;
                return Vec3.m_82539_((Vec3i)pos);
            }
            return null;
        }
    }
}

