/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.passive.basilisk;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.tropicraft.core.common.Easings;
import net.tropicraft.core.common.entity.passive.basilisk.WaterWalking;

public final class BasiliskLizardEntity
extends Animal {
    private static final EntityDataAccessor<Boolean> RUNNING = SynchedEntityData.m_135353_(BasiliskLizardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final float WATER_WALK_SPEED_BOOST = 1.6f;
    private static final int WATER_WALK_TIME = 10;
    private static final int RUNNING_ANIMATION_LENGTH = 10;
    private int movingTimer;
    private boolean onWaterSurface;
    private int runningAnimation;
    private int prevRunningAnimation;

    public BasiliskLizardEntity(EntityType<? extends BasiliskLizardEntity> type, Level world) {
        super(type, world);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    protected PathNavigation m_6037_(Level world) {
        return new WaterWalking.Navigator((Mob)this, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RUNNING, (Object)false);
    }

    public boolean m_6898_(ItemStack stack) {
        return false;
    }

    public BasiliskLizardEntity getBreedOffspring(ServerLevel world, AgeableMob mate) {
        return null;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            this.tickMovementTimer();
            this.tickSwimming();
            this.f_19804_.m_135381_(RUNNING, (Object)this.onWaterSurface);
        } else {
            this.tickRunningAnimation();
        }
    }

    private void tickRunningAnimation() {
        this.prevRunningAnimation = this.runningAnimation;
        if (((Boolean)this.f_19804_.m_135370_(RUNNING)).booleanValue()) {
            if (this.runningAnimation < 10) {
                ++this.runningAnimation;
            }
            this.spawnRunningParticles();
        } else if (this.runningAnimation > 0) {
            this.runningAnimation = Math.max(this.runningAnimation - 2, 0);
        }
    }

    private void spawnRunningParticles() {
        for (int i = 0; i < 2; ++i) {
            Vec3 motion = this.m_20184_();
            double surfaceY = (double)Mth.m_14107_((double)this.m_20186_()) + 1.0;
            double dx = (this.f_19796_.m_188500_() * 2.0 - 1.0) * 0.25;
            double dz = (this.f_19796_.m_188500_() * 2.0 - 1.0) * 0.25;
            this.m_9236_().m_7106_((ParticleOptions)(this.f_19796_.m_188499_() ? ParticleTypes.f_123795_ : ParticleTypes.f_123769_), this.m_20185_() + dx, surfaceY, this.m_20189_() + dz, motion.f_82479_, motion.f_82480_ - this.f_19796_.m_188500_() * (double)0.2f, motion.f_82481_);
        }
    }

    protected void m_5841_() {
        float volume = (float)(this.m_20184_().m_82542_(0.5, 1.0, 0.5).m_82553_() * (double)0.2f);
        volume = Math.min(volume, 1.0f);
        float pitch = 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.4f;
        SoundEvent sound = (double)volume < 0.25 ? this.m_5509_() : this.m_5508_();
        this.m_5496_(sound, volume, pitch);
    }

    private void tickMovementTimer() {
        if (this.f_20902_ != 0.0f) {
            this.movingTimer = 10;
        } else if (this.movingTimer > 0) {
            --this.movingTimer;
        }
    }

    private void tickSwimming() {
        boolean shouldWaterWalk;
        if (!this.onWaterSurface && this.m_20069_() && this.m_204036_(FluidTags.f_13131_) > this.m_20204_() && ((shouldWaterWalk = this.shouldWaterWalk()) || this.f_19796_.m_188501_() < 0.8f)) {
            this.m_20256_(this.m_20184_().m_82490_(0.5).m_82520_(0.0, 0.1, 0.0));
        }
    }

    protected Vec3 m_5763_(Vec3 offset, MoverType mover) {
        if (this.shouldWaterWalk()) {
            Vec3 result = WaterWalking.collide((BlockGetter)this.m_9236_(), this.m_20191_(), offset);
            this.onWaterSurface = offset.f_82480_ < 0.0 && result.f_82480_ != offset.f_82480_;
            return result;
        }
        this.onWaterSurface = false;
        return offset;
    }

    protected void m_7840_(double y, boolean onGround, BlockState state, BlockPos pos) {
        this.m_6853_(this.m_20096_() || this.onWaterSurface);
        super.m_7840_(y, this.m_20096_(), state, pos);
    }

    public float m_6113_() {
        float speed = super.m_6113_();
        return this.onWaterSurface ? speed * 1.6f : speed;
    }

    public boolean m_203441_(FluidState fluidState) {
        return WaterWalking.canWalkOn(fluidState.m_76152_());
    }

    private boolean shouldWaterWalk() {
        return this.movingTimer > 0;
    }

    public float getRunningAnimation(float partialTicks) {
        float animation = Mth.m_14179_((float)partialTicks, (float)this.prevRunningAnimation, (float)this.runningAnimation);
        return Easings.inOutSine(animation / 10.0f);
    }
}

