/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.underdasea;

import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.tropicraft.core.common.entity.underdasea.IAtlasFish;
import net.tropicraft.core.common.item.TropicraftItems;

public class TropicraftTropicalFishEntity
extends AbstractSchoolingFish
implements IAtlasFish {
    private static final EntityDataAccessor<Byte> DATA_FISH_TYPE = SynchedEntityData.m_135353_(TropicraftTropicalFishEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);

    public TropicraftTropicalFishEntity(EntityType<? extends AbstractSchoolingFish> type, Level world) {
        super(type, world);
    }

    public static AttributeSupplier.Builder m_27495_() {
        return AbstractSchoolingFish.m_27495_().m_22268_(Attributes.f_22276_, 5.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FISH_TYPE, (Object)0);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficultyInstance, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag nbt) {
        entityData = super.m_6518_(world, difficultyInstance, spawnReason, entityData, nbt);
        if (nbt != null && nbt.m_128425_("BucketVariantTag", 3)) {
            this.setFishType(FishType.getById(nbt.m_128451_("BucketVariantTag")));
        } else {
            this.setFishType(FishType.getRandomType(this.f_19796_));
        }
        return entityData;
    }

    public FishType getFishType() {
        return FishType.VALUES[(Byte)this.f_19804_.m_135370_(DATA_FISH_TYPE)];
    }

    public void setFishType(FishType type) {
        this.f_19804_.m_135381_(DATA_FISH_TYPE, (Object)((byte)type.ordinal()));
    }

    public int m_6031_() {
        return 24;
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)TropicraftItems.TROPICAL_FISH_BUCKET.get());
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12327_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12328_;
    }

    protected SoundEvent m_7975_(DamageSource dmgSrc) {
        return SoundEvents.f_12330_;
    }

    protected SoundEvent m_5699_() {
        return SoundEvents.f_12329_;
    }

    @Override
    public int getAtlasSlot() {
        return this.getFishType().ordinal();
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && stack.m_41720_() == TropicraftItems.FISHING_NET.get()) {
            boolean firstHotbarSlot = false;
            int bucketSlot = -1;
            for (int i = 0; i < Inventory.m_36059_(); ++i) {
                ItemStack s = player.m_150109_().m_8020_(0 + i);
                if (!this.isFishHolder(s)) continue;
                bucketSlot = 0 + i;
                break;
            }
            if (bucketSlot == -1 && this.isFishHolder(player.m_21206_())) {
                bucketSlot = 36;
            }
            if (bucketSlot >= 0) {
                ItemStack fishHolder = player.m_150109_().m_8020_(bucketSlot);
                if (fishHolder.m_41720_() == Items.f_42447_) {
                    fishHolder = new ItemStack((ItemLike)TropicraftItems.TROPICAL_FISH_BUCKET.get());
                    player.m_150109_().m_6836_(bucketSlot, fishHolder);
                }
                this.m_6872_(fishHolder);
                player.m_6674_(hand);
                this.m_9236_().m_5594_(player, this.m_20183_(), SoundEvents.f_11918_, SoundSource.PLAYERS, 0.25f, 1.0f + this.f_19796_.m_188501_() * 0.4f);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(player, hand);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("FishType", this.getFishType().id);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setFishType(FishType.getById(compound.m_128451_("FishType")));
    }

    public void m_6872_(ItemStack bucket) {
        super.m_6872_(bucket);
        CompoundTag compoundnbt = bucket.m_41784_();
        compoundnbt.m_128405_("BucketVariantTag", this.getFishType().id);
    }

    private boolean isFishHolder(ItemStack stack) {
        return !stack.m_41619_() && (stack.m_41720_() == Items.f_42447_ || stack.m_41720_() == TropicraftItems.TROPICAL_FISH_BUCKET.get());
    }

    static enum FishType {
        CLOWNFISH(0),
        QUEEN_ANGELFISH(1),
        YELLOW_TANG(2),
        BUTTERFLY_FISH(3),
        GEOPHAGUS_SURINAMENSIS(4),
        BETTA_FISH(5),
        REGAL_TANG(6),
        ROYAL_GAMMA(7);

        public static final FishType[] VALUES;
        private final int id;

        private FishType(int id) {
            this.id = id;
        }

        private static FishType getById(int id) {
            for (FishType type : VALUES) {
                if (type.id != id) continue;
                return type;
            }
            return CLOWNFISH;
        }

        private static FishType getRandomType(RandomSource rand) {
            return (FishType)((Object)Util.m_214670_((Object[])VALUES, (RandomSource)rand));
        }

        static {
            VALUES = FishType.values();
        }
    }
}

