/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.tropicraft.core.common.entity.projectile.SpearEntity;

public class SpearItem
extends TridentItem {
    private final Tier tier;
    private final Supplier<Multimap<Attribute, AttributeModifier>> defaultModifiers;

    public SpearItem(Tier tier, int attackDamage, float attackSpeed, Item.Properties properties) {
        super(properties.m_41499_(tier.m_6609_()));
        this.tier = tier;
        this.defaultModifiers = Suppliers.memoize(() -> ImmutableMultimap.builder().putAll(super.getAttributeModifiers(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)this))).put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)attackDamage, AttributeModifier.Operation.ADDITION)).put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)attackSpeed, AttributeModifier.Operation.ADDITION)).build());
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int i = this.m_8105_(stack) - timeLeft;
            if (i >= 10) {
                if (!level.f_46443_) {
                    stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(entity.m_7655_()));
                    SpearEntity spear = new SpearEntity(level, (LivingEntity)player, stack);
                    spear.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 2.5f, 1.0f);
                    if (player.m_150110_().f_35937_) {
                        spear.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    }
                    level.m_7967_((Entity)spear);
                    level.m_6269_(null, (Entity)spear, SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    if (!player.m_150110_().f_35937_) {
                        player.m_150109_().m_36057_(stack);
                    }
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return slot == EquipmentSlot.MAINHAND ? this.defaultModifiers.get() : super.getAttributeModifiers(slot, stack);
    }

    public int getEnchantmentValue(ItemStack stack) {
        return this.tier.m_6601_();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment != Enchantments.f_44957_ && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return this.tier.m_6282_().test(repair) || super.m_6832_(toRepair, repair);
    }
}

