/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.tterrag.registrate.Registrate;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateItemModelProvider;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.DataIngredient;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.common.Tags;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.common.Foods;
import net.tropicraft.core.common.TropicraftTags;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.block.TropicraftFlower;
import net.tropicraft.core.common.block.TropicraftWoodTypes;
import net.tropicraft.core.common.drinks.Drink;
import net.tropicraft.core.common.drinks.MixerRecipes;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.entity.placeable.BeachFloatEntity;
import net.tropicraft.core.common.entity.placeable.ChairEntity;
import net.tropicraft.core.common.entity.placeable.FurnitureEntity;
import net.tropicraft.core.common.entity.placeable.UmbrellaEntity;
import net.tropicraft.core.common.item.ArmorMaterials;
import net.tropicraft.core.common.item.AshenMaskItem;
import net.tropicraft.core.common.item.AshenMasks;
import net.tropicraft.core.common.item.BambooItemFrameItem;
import net.tropicraft.core.common.item.BlowGunItem;
import net.tropicraft.core.common.item.CocktailItem;
import net.tropicraft.core.common.item.DaggerItem;
import net.tropicraft.core.common.item.ExplodingCoconutItem;
import net.tropicraft.core.common.item.FireArmorItem;
import net.tropicraft.core.common.item.FoodDishItem;
import net.tropicraft.core.common.item.FurnitureItem;
import net.tropicraft.core.common.item.LoveTropicsShellItem;
import net.tropicraft.core.common.item.NigelStacheItem;
import net.tropicraft.core.common.item.RecordMusic;
import net.tropicraft.core.common.item.ScaleArmorItem;
import net.tropicraft.core.common.item.ShellItem;
import net.tropicraft.core.common.item.SpearItem;
import net.tropicraft.core.common.item.SunglassesItem;
import net.tropicraft.core.common.item.TropicalFertilizerItem;
import net.tropicraft.core.common.item.TropicalMusicDiscItem;
import net.tropicraft.core.common.item.TropicraftFishBucketItem;
import net.tropicraft.core.common.item.TropicraftToolTiers;
import net.tropicraft.core.common.item.WaterWandItem;
import net.tropicraft.core.common.item.scuba.PonyBottleItem;
import net.tropicraft.core.common.item.scuba.ScubaFlippersItem;
import net.tropicraft.core.common.item.scuba.ScubaGogglesItem;
import net.tropicraft.core.common.item.scuba.ScubaHarnessItem;
import net.tropicraft.core.common.item.scuba.ScubaType;

@Mod.EventBusSubscriber(modid="tropicraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class TropicraftItems {
    public static final Registrate REGISTRATE = Tropicraft.registrate();
    public static final ItemEntry<Item> AZURITE;
    public static final ItemEntry<Item> EUDIALYTE;
    public static final ItemEntry<Item> ZIRCON;
    public static final ItemEntry<Item> SHAKA;
    public static final ItemEntry<Item> MANGANESE;
    public static final ItemEntry<Item> ZIRCONIUM;
    public static final Map<DyeColor, ItemEntry<FurnitureItem<UmbrellaEntity>>> UMBRELLAS;
    public static final Map<DyeColor, ItemEntry<FurnitureItem<ChairEntity>>> CHAIRS;
    public static final Map<DyeColor, ItemEntry<FurnitureItem<BeachFloatEntity>>> BEACH_FLOATS;
    public static final ItemEntry<Item> BAMBOO_STICK;
    public static final ItemEntry<SpearItem> BAMBOO_SPEAR;
    public static final ItemEntry<ShellItem> SOLONOX_SHELL;
    public static final ItemEntry<ShellItem> FROX_CONCH;
    public static final ItemEntry<ShellItem> PAB_SHELL;
    public static final ItemEntry<ShellItem> RUBE_NAUTILUS;
    public static final ItemEntry<ShellItem> STARFISH;
    public static final ItemEntry<ShellItem> TURTLE_SHELL;
    public static final ItemEntry<LoveTropicsShellItem> LOVE_TROPICS_SHELL;
    public static final ItemEntry<Item> LEMON;
    public static final ItemEntry<Item> LIME;
    public static final ItemEntry<Item> GRAPEFRUIT;
    public static final ItemEntry<Item> ORANGE;
    public static final ItemEntry<Item> PASSIONFRUIT;
    public static final ItemEntry<Item> JOCOTE;
    public static final ItemEntry<Item> PINEAPPLE_CUBES;
    public static final ItemEntry<Item> COCONUT_CHUNK;
    public static final ItemEntry<ItemNameBlockItem> RAW_COFFEE_BEAN;
    public static final ItemEntry<Item> ROASTED_COFFEE_BEAN;
    public static final ItemEntry<Item> COFFEE_BERRY;
    public static final ItemEntry<Item> BAMBOO_MUG;
    public static final ItemEntry<Item> BAMBOO_BOWL;
    public static final ItemEntry<Item> GREEN_PLANTAIN;
    public static final ItemEntry<Item> YELLOW_PLANTAIN;
    public static final ItemEntry<Item> DRIED_PLANTAINS;
    public static final ItemEntry<FoodDishItem> MOFONGO;
    public static final ImmutableMap<Drink, ItemEntry<CocktailItem>> COCKTAILS;
    public static final ItemEntry<Item> WHITE_PEARL;
    public static final ItemEntry<Item> BLACK_PEARL;
    public static final ItemEntry<Item> SCALE;
    public static final ItemEntry<NigelStacheItem> NIGEL_STACHE;
    public static final ItemEntry<SunglassesItem> COOL_SHADES;
    public static final ItemEntry<Item> FRESH_MARLIN;
    public static final ItemEntry<Item> SEARED_MARLIN;
    public static final ItemEntry<Item> RAW_RAY;
    public static final ItemEntry<Item> COOKED_RAY;
    public static final ItemEntry<Item> FROG_LEG;
    public static final ItemEntry<Item> COOKED_FROG_LEG;
    public static final ItemEntry<Item> SEA_URCHIN_ROE;
    public static final ItemEntry<Item> TOASTED_NORI;
    public static final ItemEntry<Item> RAW_FISH;
    public static final ItemEntry<Item> COOKED_FISH;
    public static final ItemEntry<Item> POISON_FROG_SKIN;
    public static final ItemEntry<Item> IGUANA_LEATHER;
    public static final ItemEntry<TropicalFertilizerItem> TROPICAL_FERTILIZER;
    public static final ItemEntry<BambooItemFrameItem> BAMBOO_ITEM_FRAME;
    public static final ImmutableMap<RecordMusic, ItemEntry<TropicalMusicDiscItem>> MUSIC_DISCS;
    public static final ItemEntry<Item> TROPICAL_FISH_BUCKET;
    public static final ItemEntry<Item> SARDINE_BUCKET;
    public static final ItemEntry<Item> PIRANHA_BUCKET;
    public static final ItemEntry<Item> KOA_SPAWN_EGG;
    public static final ItemEntry<Item> TROPICREEPER_SPAWN_EGG;
    public static final ItemEntry<Item> IGUANA_SPAWN_EGG;
    public static final ItemEntry<Item> TROPISKELLY_SPAWN_EGG;
    public static final ItemEntry<Item> EIH_SPAWN_EGG;
    public static final ItemEntry<Item> SEA_TURTLE_SPAWN_EGG;
    public static final ItemEntry<Item> MARLIN_SPAWN_EGG;
    public static final ItemEntry<Item> FAILGULL_SPAWN_EGG;
    public static final ItemEntry<Item> DOLPHIN_SPAWN_EGG;
    public static final ItemEntry<Item> SEAHORSE_SPAWN_EGG;
    public static final ItemEntry<Item> TREE_FROG_SPAWN_EGG;
    public static final ItemEntry<Item> SEA_URCHIN_SPAWN_EGG;
    public static final ItemEntry<Item> V_MONKEY_SPAWN_EGG;
    public static final ItemEntry<Item> PIRANHA_SPAWN_EGG;
    public static final ItemEntry<Item> SARDINE_SPAWN_EGG;
    public static final ItemEntry<Item> TROPICAL_FISH_SPAWN_EGG;
    public static final ItemEntry<Item> EAGLE_RAY_SPAWN_EGG;
    public static final ItemEntry<Item> TROPI_SPIDER_SPAWN_EGG;
    public static final ItemEntry<Item> ASHEN_SPAWN_EGG;
    public static final ItemEntry<Item> HAMMERHEAD_SPAWN_EGG;
    public static final ItemEntry<Item> COWKTAIL_SPAWN_EGG;
    public static final ItemEntry<Item> MAN_O_WAR_SPAWN_EGG;
    public static final ItemEntry<Item> TROPIBEE_SPAWN_EGG;
    public static final ItemEntry<Item> TAPIR_SPAWN_EGG;
    public static final ItemEntry<Item> JAGUAR_SPAWN_EGG;
    public static final ItemEntry<Item> BROWN_BASILISK_LIZARD_SPAWN_EGG;
    public static final ItemEntry<Item> GREEN_BASILISK_LIZARD_SPAWN_EGG;
    public static final ItemEntry<Item> HUMMINGBIRD_SPAWN_EGG;
    public static final ItemEntry<Item> FIDDLER_CRAB_SPAWN_EGG;
    public static final ItemEntry<Item> SPIDER_MONKEY_SPAWN_EGG;
    public static final ItemEntry<Item> WHITE_LIPPED_PECCARY_SPAWN_EGG;
    public static final ItemEntry<Item> CUBERA_SPAWN_EGG;
    public static final ItemEntry<Item> GIBNUT_SPAWN_EGG;
    public static final ItemEntry<Item> MANATEE_SPAWN_EGG;
    public static final ItemEntry<Item> SLENDER_HARVEST_MOUSE_SPAWN_EGG;
    public static final ItemEntry<Item> TOUCAN_SPAWN_EGG;
    public static final ImmutableMap<AshenMasks, ItemEntry<AshenMaskItem>> ASHEN_MASKS;
    public static final ItemEntry<DaggerItem> DAGGER;
    public static final ItemEntry<BlowGunItem> BLOW_GUN;
    public static final ItemEntry<Item> ZIRCON_HOE;
    public static final ItemEntry<Item> ZIRCONIUM_HOE;
    public static final ItemEntry<Item> EUDIALYTE_HOE;
    public static final ItemEntry<Item> ZIRCON_AXE;
    public static final ItemEntry<Item> ZIRCONIUM_AXE;
    public static final ItemEntry<Item> EUDIALYTE_AXE;
    public static final ItemEntry<Item> ZIRCON_PICKAXE;
    public static final ItemEntry<Item> ZIRCONIUM_PICKAXE;
    public static final ItemEntry<Item> EUDIALYTE_PICKAXE;
    public static final ItemEntry<Item> ZIRCON_SHOVEL;
    public static final ItemEntry<Item> ZIRCONIUM_SHOVEL;
    public static final ItemEntry<Item> EUDIALYTE_SHOVEL;
    public static final ItemEntry<Item> ZIRCON_SWORD;
    public static final ItemEntry<Item> ZIRCONIUM_SWORD;
    public static final ItemEntry<Item> EUDIALYTE_SWORD;
    public static final ItemEntry<ArmorItem> FIRE_BOOTS;
    public static final ItemEntry<ArmorItem> FIRE_LEGGINGS;
    public static final ItemEntry<ArmorItem> FIRE_CHESTPLATE;
    public static final ItemEntry<ArmorItem> FIRE_HELMET;
    public static final ItemEntry<ArmorItem> SCALE_BOOTS;
    public static final ItemEntry<ArmorItem> SCALE_LEGGINGS;
    public static final ItemEntry<ArmorItem> SCALE_CHESTPLATE;
    public static final ItemEntry<ArmorItem> SCALE_HELMET;
    public static final ItemEntry<ScubaGogglesItem> YELLOW_SCUBA_GOGGLES;
    public static final ItemEntry<ScubaHarnessItem> YELLOW_SCUBA_HARNESS;
    public static final ItemEntry<ScubaFlippersItem> YELLOW_SCUBA_FLIPPERS;
    public static final ItemEntry<ScubaGogglesItem> PINK_SCUBA_GOGGLES;
    public static final ItemEntry<ScubaHarnessItem> PINK_SCUBA_HARNESS;
    public static final ItemEntry<ScubaFlippersItem> PINK_SCUBA_FLIPPERS;
    public static final ItemEntry<PonyBottleItem> YELLOW_PONY_BOTTLE;
    public static final ItemEntry<PonyBottleItem> PINK_PONY_BOTTLE;
    public static final ItemEntry<WaterWandItem> WATER_WAND;
    public static final ItemEntry<ExplodingCoconutItem> EXPLODING_COCONUT;
    public static final ItemEntry<Item> FISHING_NET;
    public static final ItemEntry<Item> PIANGUAS;
    public static final ItemEntry<SignItem> MAHOGANY_SIGN;
    public static final ItemEntry<SignItem> PALM_SIGN;
    public static final ItemEntry<SignItem> BAMBOO_SIGN;
    public static final ItemEntry<SignItem> THATCH_SIGN;
    public static final ItemEntry<SignItem> MANGROVE_SIGN;
    private static final List<TrimMaterial> GENERATED_TRIM_MATERIALS;

    private static <T extends FurnitureEntity> ItemBuilder<FurnitureItem<T>, Registrate> furniture(String name, Supplier<EntityType<T>> type, DyeColor color) {
        return REGISTRATE.item(name, p -> new FurnitureItem((Item.Properties)p, type, color)).color(() -> () -> (stack, tintIndex) -> tintIndex == 0 ? 0xFFFFFF : color.m_41071_());
    }

    private static ItemBuilder<ShellItem, Registrate> shell(String name) {
        return REGISTRATE.item(name, ShellItem::new).tag(new TagKey[]{TropicraftTags.Items.SHELLS});
    }

    private static <T extends AbstractFish> ItemBuilder<Item, Registrate> fishBucket(String name, Supplier<? extends EntityType<T>> entity) {
        return REGISTRATE.item(name, p -> new TropicraftFishBucketItem(entity, (Fluid)Fluids.f_76193_, (Item.Properties)p)).properties(p -> p.m_41487_(1));
    }

    private static <T extends Mob> ItemBuilder<Item, Registrate> spawnEgg(String name, RegistryEntry<EntityType<T>> entity, int backgroundColor, int highlightColor) {
        return REGISTRATE.item(name, p -> new ForgeSpawnEggItem((Supplier)entity, backgroundColor, highlightColor, p)).model((ctx, prov) -> prov.withExistingParent(ctx.getName(), prov.mcLoc("item/template_spawn_egg")));
    }

    private static <T extends Mob> ItemBuilder<Item, Registrate> customSpawnEgg(String name, RegistryEntry<EntityType<T>> entity) {
        return REGISTRATE.item(name, p -> new ForgeSpawnEggItem((Supplier)entity, 0xFFFFFF, 0xFFFFFF, p));
    }

    private static ItemBuilder<Item, Registrate> hoe(String name, TropicraftToolTiers tier, Supplier<? extends Item> input) {
        return REGISTRATE.item(name, p -> new HoeItem((Tier)tier, 0, -2.0f, p)).tag(new TagKey[]{ItemTags.f_271298_}).model((ctx, prov) -> prov.handheld((NonNullSupplier)ctx)).recipe((ctx, prov) -> ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ctx.get())).m_126130_("XX").m_126130_(" B").m_126130_(" B").m_126127_(Character.valueOf('X'), (ItemLike)input.get()).m_126127_(Character.valueOf('B'), (ItemLike)BAMBOO_STICK.get()).m_126132_("has_" + prov.safeName((ItemLike)input.get()), (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)((ItemLike)input.get()))).m_126132_("has_" + prov.safeName((ItemLike)Items.f_41911_), (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)Items.f_41911_)).m_176498_((Consumer)prov));
    }

    private static ItemBuilder<Item, Registrate> shovel(String name, Tier tier, Supplier<? extends Item> input) {
        return REGISTRATE.item(name, p -> new ShovelItem(tier, 2.0f, -3.0f, p)).tag(new TagKey[]{ItemTags.f_271138_}).model((ctx, prov) -> prov.handheld((NonNullSupplier)ctx)).recipe((ctx, prov) -> ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ctx.get())).m_126130_("X").m_126130_("B").m_126130_("B").m_126127_(Character.valueOf('X'), (ItemLike)input.get()).m_126127_(Character.valueOf('B'), (ItemLike)BAMBOO_STICK.get()).m_126132_("has_" + prov.safeName((ItemLike)input.get()), (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)((ItemLike)input.get()))).m_126132_("has_" + prov.safeName((ItemLike)Items.f_41911_), (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)Items.f_41911_)).m_176498_((Consumer)prov));
    }

    private static ItemBuilder<Item, Registrate> pickaxe(String name, Tier tier, Supplier<? extends Item> input) {
        return REGISTRATE.item(name, p -> new PickaxeItem(tier, 2, -2.0f, p)).tag(new TagKey[]{ItemTags.f_271360_}).model((ctx, prov) -> prov.handheld((NonNullSupplier)ctx)).recipe((ctx, prov) -> ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ctx.get())).m_126130_("XXX").m_126130_(" B ").m_126130_(" B ").m_126127_(Character.valueOf('X'), (ItemLike)input.get()).m_126127_(Character.valueOf('B'), (ItemLike)BAMBOO_STICK.get()).m_126132_("has_" + prov.safeName((ItemLike)input.get()), (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)((ItemLike)input.get()))).m_126132_("has_" + prov.safeName((ItemLike)Items.f_41911_), (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)Items.f_41911_)).m_176498_((Consumer)prov));
    }

    private static ItemBuilder<Item, Registrate> axe(String name, Tier tier, Supplier<? extends Item> input) {
        return REGISTRATE.item(name, p -> new AxeItem(tier, 5.0f, -2.0f, p)).tag(new TagKey[]{ItemTags.f_271207_}).model((ctx, prov) -> prov.handheld((NonNullSupplier)ctx)).recipe((ctx, prov) -> ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ctx.get())).m_126130_("XX").m_126130_("XB").m_126130_(" B").m_126127_(Character.valueOf('X'), (ItemLike)input.get()).m_126127_(Character.valueOf('B'), (ItemLike)BAMBOO_STICK.get()).m_126132_("has_" + prov.safeName((ItemLike)input.get()), (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)((ItemLike)input.get()))).m_126132_("has_" + prov.safeName((ItemLike)Items.f_41911_), (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)Items.f_41911_)).m_176498_((Consumer)prov));
    }

    private static ItemBuilder<Item, Registrate> sword(String name, Tier tier, Supplier<? extends Item> input) {
        return REGISTRATE.item(name, p -> new SwordItem(tier, 3, -3.0f, p)).tag(new TagKey[]{ItemTags.f_271388_}).model((ctx, prov) -> prov.handheld((NonNullSupplier)ctx)).recipe((ctx, prov) -> ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ctx.get())).m_126130_("X").m_126130_("X").m_126130_("B").m_126127_(Character.valueOf('X'), (ItemLike)input.get()).m_126127_(Character.valueOf('B'), (ItemLike)BAMBOO_STICK.get()).m_126132_("has_" + prov.safeName((ItemLike)input.get()), (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)((ItemLike)input.get()))).m_126132_("has_" + prov.safeName((ItemLike)Items.f_41911_), (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)Items.f_41911_)).m_176498_((Consumer)prov));
    }

    private static ItemBuilder<ArmorItem, Registrate> fireArmor(String name, ArmorItem.Type slotType) {
        return REGISTRATE.item(name, p -> new FireArmorItem(slotType, (Item.Properties)p)).properties(p -> p.m_41487_(1).m_41503_(300)).tag(new TagKey[]{ItemTags.f_265942_}).model(TropicraftItems::trimmableArmor);
    }

    private static ItemBuilder<ArmorItem, Registrate> scaleArmor(String name, ArmorItem.Type slotType) {
        return REGISTRATE.item(name, p -> new ScaleArmorItem(slotType, (Item.Properties)p)).properties(p -> p.m_41487_(1)).tag(new TagKey[]{ItemTags.f_265942_}).model(TropicraftItems::trimmableArmor);
    }

    private static ItemBuilder<ScubaGogglesItem, Registrate> scubaGoggles(String name, ScubaType type, Supplier<? extends Item> source) {
        return REGISTRATE.item(name, p -> new ScubaGogglesItem(type, (Item.Properties)p)).recipe((ctx, prov) -> ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ctx.get()), (int)1).m_126130_("YYY").m_126130_("X X").m_126130_(" Z ").m_126127_(Character.valueOf('X'), (ItemLike)Blocks.f_50185_).m_126127_(Character.valueOf('Y'), (ItemLike)ZIRCON.get()).m_126127_(Character.valueOf('Z'), (ItemLike)source.get()).m_126132_("has_" + prov.safeName((ItemLike)source.get()), (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)((ItemLike)source.get()))).m_126132_("has_" + prov.safeName((ItemLike)ZIRCON.get()), (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)((ItemLike)ZIRCON.get()))).m_176498_((Consumer)prov));
    }

    private static ItemBuilder<ScubaHarnessItem, Registrate> scubaHarness(String name, ScubaType type, Supplier<? extends Item> source) {
        return REGISTRATE.item(name, p -> new ScubaHarnessItem(type, (Item.Properties)p)).recipe((ctx, prov) -> ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ctx.get()), (int)1).m_126130_("Y Y").m_126130_("YXY").m_126130_("YZY").m_126127_(Character.valueOf('X'), (ItemLike)source.get()).m_206416_(Character.valueOf('Y'), Tags.Items.LEATHER).m_126127_(Character.valueOf('Z'), (ItemLike)AZURITE.get()).m_126132_("has_" + prov.safeName((ItemLike)AZURITE.get()), (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)((ItemLike)AZURITE.get()))).m_176498_((Consumer)prov));
    }

    private static ItemBuilder<ScubaFlippersItem, Registrate> scubaFlippers(String name, ScubaType type, Supplier<? extends Item> source) {
        return REGISTRATE.item(name, p -> new ScubaFlippersItem(type, (Item.Properties)p)).recipe((ctx, prov) -> ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ctx.get()), (int)1).m_126130_("XX").m_126130_("YY").m_126130_("XX").m_126127_(Character.valueOf('X'), (ItemLike)source.get()).m_126127_(Character.valueOf('Y'), (ItemLike)ZIRCON.get()).m_126132_("has_" + prov.safeName((ItemLike)source.get()), (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)((ItemLike)source.get()))).m_126132_("has_" + prov.safeName((ItemLike)ZIRCON.get()), (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)((ItemLike)ZIRCON.get()))).m_176498_((Consumer)prov));
    }

    private static ItemEntry<PonyBottleItem> ponyBottle(String name, Block glassPane) {
        return REGISTRATE.item(name, PonyBottleItem::new).properties(p -> p.m_41487_(1).m_41503_(32)).recipe((ctx, prov) -> ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ctx.get()), (int)1).m_126130_("Y").m_126130_("X").m_126127_(Character.valueOf('X'), (ItemLike)glassPane).m_126127_(Character.valueOf('Y'), (ItemLike)Blocks.f_50164_).m_126132_("has_" + prov.safeName((ItemLike)glassPane), (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)glassPane)).m_176498_((Consumer)prov)).register();
    }

    private static ItemBuilder<Item, Registrate> simpleItem(String name) {
        return REGISTRATE.item(name, Item::new);
    }

    private static ItemBuilder<Item, Registrate> food(String name, FoodProperties food) {
        return TropicraftItems.simpleItem(name).properties(p -> p.m_41489_(food));
    }

    private static ItemBuilder<SignItem, Registrate> sign(WoodType woodType, Supplier<? extends Block> planks, Supplier<? extends StandingSignBlock> standingSign, Supplier<? extends WallSignBlock> wallSign) {
        String woodName = new ResourceLocation(woodType.f_61839_()).m_135815_();
        return REGISTRATE.item(woodName + "_sign", p -> new SignItem(p, (Block)standingSign.get(), (Block)wallSign.get())).properties(p -> p.m_41487_(16)).tag(new TagKey[]{ItemTags.f_13157_}).recipe((ctx, prov) -> ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get())).m_126130_("###").m_126130_("###").m_126130_(" | ").m_126127_(Character.valueOf('#'), (ItemLike)planks.get()).m_206416_(Character.valueOf('|'), Tags.Items.RODS_WOODEN).m_126132_("has_" + woodName, (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)((ItemLike)planks.get()))).m_126145_("wooden_sign").m_176498_((Consumer)prov));
    }

    @SubscribeEvent
    public static void onItemRegister(RegisterEvent event) {
        if (!ForgeRegistries.ITEMS.equals(event.getForgeRegistry())) {
            return;
        }
        ForgeRegistries.BLOCKS.getEntries().forEach(entry -> {
            Object patt49933$temp = entry.getValue();
            if (patt49933$temp instanceof FlowerPotBlock) {
                FlowerPotBlock flowerPot = (FlowerPotBlock)patt49933$temp;
                FlowerPotBlock emptyPot = flowerPot.getEmptyPot();
                Block content = flowerPot.m_53560_();
                if (emptyPot.m_204297_().m_203373_(TropicraftBlocks.BAMBOO_FLOWER_POT.getId()) && emptyPot != flowerPot) {
                    TropicraftItems.addPlant((FlowerPotBlock)TropicraftBlocks.BAMBOO_FLOWER_POT.get(), flowerPot);
                } else if (content.m_204297_().m_205785_().m_135782_().m_135827_().equals("tropicraft")) {
                    TropicraftItems.addPlant((FlowerPotBlock)Blocks.f_50276_, flowerPot);
                }
            }
        });
    }

    private static void addPlant(FlowerPotBlock empty, FlowerPotBlock full) {
        empty.addPlant(full.m_53560_().m_204297_().m_205785_().m_135782_(), (Supplier)full.m_204297_());
    }

    private static DataIngredient ingredient(NonNullSupplier<? extends ItemLike> item) {
        return DataIngredient.items(item, (NonNullSupplier[])new NonNullSupplier[0]);
    }

    private static void trimmableArmor(DataGenContext<Item, ArmorItem> ctx, RegistrateItemModelProvider prov) {
        ArmorItem.Type armorType = ((ArmorItem)ctx.get()).m_266204_();
        ResourceLocation texture = prov.itemTexture(ctx);
        ItemModelBuilder builder = prov.generated(ctx, new ResourceLocation[]{texture});
        for (TrimMaterial trim : GENERATED_TRIM_MATERIALS) {
            ResourceLocation materialOverlayTexture = new ResourceLocation("trims/items/" + armorType.m_266355_() + "_trim_" + trim.name());
            prov.existingFileHelper.trackGenerated(materialOverlayTexture, PackType.CLIENT_RESOURCES, ".png", "textures");
            ItemModelBuilder trimmedModel = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)prov.getBuilder(prov.name(ctx) + "_trim_" + trim.name())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", texture)).texture("layer1", materialOverlayTexture);
            builder = builder.override().predicate(ItemModelGenerators.f_265922_, trim.itemModelIndex()).model((ModelFile)trimmedModel).end();
        }
    }

    static {
        REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, prov -> {
            prov.addTag(Tags.Items.GEMS).addTags(new TagKey[]{TropicraftTags.Items.AZURITE_GEM, TropicraftTags.Items.EUDIALYTE_GEM, TropicraftTags.Items.ZIRCON_GEM, TropicraftTags.Items.ZIRCONIUM_GEM});
            prov.addTag(Tags.Items.INGOTS).addTags(new TagKey[]{TropicraftTags.Items.MANGANESE_INGOT, TropicraftTags.Items.SHAKA_INGOT});
            prov.addTag(TropicraftTags.Items.FRUITS).m_255245_((Object)Items.f_42410_);
            prov.addTag(TropicraftTags.Items.MEATS).m_255179_((Object[])new Item[]{Items.f_42579_, Items.f_42485_, Items.f_42581_, Items.f_42697_, Items.f_42658_});
        });
        AZURITE = TropicraftItems.simpleItem("azurite_gem").tag(new TagKey[]{TropicraftTags.Items.AZURITE_GEM}).recipe((ctx, prov) -> prov.smeltingAndBlasting(DataIngredient.tag(TropicraftTags.Items.AZURITE_ORE), RecipeCategory.MISC, (Supplier)ctx, 0.3f)).register();
        EUDIALYTE = TropicraftItems.simpleItem("eudialyte_gem").tag(new TagKey[]{TropicraftTags.Items.EUDIALYTE_GEM}).recipe((ctx, prov) -> prov.smeltingAndBlasting(DataIngredient.tag(TropicraftTags.Items.EUDIALYTE_ORE), RecipeCategory.MISC, (Supplier)ctx, 0.5f)).register();
        ZIRCON = TropicraftItems.simpleItem("zircon_gem").tag(new TagKey[]{TropicraftTags.Items.ZIRCON_GEM}).recipe((ctx, prov) -> prov.smeltingAndBlasting(DataIngredient.tag(TropicraftTags.Items.ZIRCON_ORE), RecipeCategory.MISC, (Supplier)ctx, 0.5f)).register();
        SHAKA = TropicraftItems.simpleItem("shaka_ingot").tag(new TagKey[]{TropicraftTags.Items.SHAKA_INGOT}).recipe((ctx, prov) -> prov.smeltingAndBlasting(DataIngredient.tag(TropicraftTags.Items.SHAKA_ORE), RecipeCategory.MISC, (Supplier)ctx, 0.5f)).register();
        MANGANESE = TropicraftItems.simpleItem("manganese_ingot").tag(new TagKey[]{TropicraftTags.Items.MANGANESE_INGOT}).recipe((ctx, prov) -> prov.smeltingAndBlasting(DataIngredient.tag(TropicraftTags.Items.MANGANESE_ORE), RecipeCategory.MISC, (Supplier)ctx, 0.5f)).register();
        ZIRCONIUM = TropicraftItems.simpleItem("zirconium_gem").tag(new TagKey[]{TropicraftTags.Items.ZIRCONIUM_GEM}).lang("Zirconium").recipe((ctx, prov) -> ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ctx.get())).m_126211_((ItemLike)AZURITE.get(), 2).m_126211_((ItemLike)ZIRCON.get(), 2).m_126132_("has_zircon", (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)((ItemLike)ZIRCON.get()))).m_126132_("has_azurite", (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)((ItemLike)AZURITE.get()))).m_176498_((Consumer)prov)).register();
        UMBRELLAS = (Map)Arrays.stream(DyeColor.values()).collect(Maps.toImmutableEnumMap(Function.identity(), color -> TropicraftItems.furniture(color.m_7912_() + "_umbrella", TropicraftEntities.UMBRELLA, color).recipe((ctx, prov) -> {
            ItemLike wool = (ItemLike)Sheep.f_29800_.get(color);
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ctx.get())).m_126130_("WWW").m_126130_(" B ").m_126130_(" B ").m_126145_("tropicraft:umbrellas").m_126127_(Character.valueOf('W'), wool).m_126127_(Character.valueOf('B'), (ItemLike)BAMBOO_STICK.get()).m_126132_("has_" + color.m_7912_() + "_wool", (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)wool)).m_176498_((Consumer)prov);
        }).model((ctx, prov) -> prov.generated((NonNullSupplier)ctx, new ResourceLocation[]{prov.modLoc("item/umbrella"), prov.modLoc("item/umbrella_inverted")})).register()));
        CHAIRS = (Map)Arrays.stream(DyeColor.values()).collect(Maps.toImmutableEnumMap(Function.identity(), color -> TropicraftItems.furniture(color.m_7912_() + "_chair", TropicraftEntities.CHAIR, color).recipe((ctx, prov) -> {
            ItemLike wool = (ItemLike)Sheep.f_29800_.get(color);
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ctx.get())).m_126130_("BWB").m_126130_("BWB").m_126130_("BWB").m_126145_("tropicraft:chairs").m_126127_(Character.valueOf('W'), wool).m_126127_(Character.valueOf('B'), (ItemLike)BAMBOO_STICK.get()).m_126132_("has_" + color.m_7912_() + "_wool", (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)wool)).m_176498_((Consumer)prov);
        }).model((ctx, prov) -> prov.generated((NonNullSupplier)ctx, new ResourceLocation[]{prov.modLoc("item/chair"), prov.modLoc("item/chair_inverted")})).register()));
        BEACH_FLOATS = (Map)Arrays.stream(DyeColor.values()).collect(Maps.toImmutableEnumMap(Function.identity(), color -> TropicraftItems.furniture(color.m_7912_() + "_beach_float", TropicraftEntities.BEACH_FLOAT, color).recipe((ctx, prov) -> {
            ItemLike wool = (ItemLike)Sheep.f_29800_.get(color);
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ctx.get())).m_126130_("WWW").m_126130_("BBB").m_126145_("tropicraft:beach_floats").m_126127_(Character.valueOf('W'), wool).m_126127_(Character.valueOf('B'), (ItemLike)Blocks.f_50571_).m_126132_("has_" + color.m_7912_() + "_wool", (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)wool)).m_176498_((Consumer)prov);
        }).model((ctx, prov) -> prov.generated((NonNullSupplier)ctx, new ResourceLocation[]{prov.modLoc("item/beach_float"), prov.modLoc("item/beach_float_inverted")})).register()));
        BAMBOO_STICK = TropicraftItems.simpleItem("bamboo_stick").tag(new TagKey[]{Tags.Items.RODS_WOODEN}).recipe((ctx, prov) -> ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ctx.get())).m_126130_("X").m_126130_("X").m_126127_(Character.valueOf('X'), (ItemLike)Items.f_41911_).m_126132_("has_bamboo", (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)Items.f_41911_)).m_126140_((Consumer)prov, new ResourceLocation("stick_from_bamboo_item"))).model((ctx, prov) -> prov.handheld((NonNullSupplier)ctx)).register();
        BAMBOO_SPEAR = REGISTRATE.item("bamboo_spear", p -> new SpearItem(TropicraftToolTiers.BAMBOO, 3, -2.4f, (Item.Properties)p)).recipe((ctx, prov) -> ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ctx.get())).m_126130_("X ").m_126130_(" X").m_126127_(Character.valueOf('X'), (ItemLike)BAMBOO_STICK.get()).m_126132_("has_bamboo_stick", (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)((ItemLike)BAMBOO_STICK.get()))).m_176498_((Consumer)prov)).model((ctx, prov) -> {
            ItemModelBuilder throwing = (ItemModelBuilder)((ItemModelBuilder)prov.withExistingParent(ctx.getName() + "_throwing", prov.modLoc("spear_throwing"))).texture("layer0", prov.itemTexture((NonNullSupplier)ctx));
            ((ItemModelBuilder)((ItemModelBuilder)prov.withExistingParent(ctx.getName(), prov.modLoc("spear"))).texture("layer0", prov.itemTexture((NonNullSupplier)ctx))).override().predicate(prov.mcLoc("throwing"), 1.0f).model((ModelFile)throwing);
        }).register();
        SOLONOX_SHELL = TropicraftItems.shell("solonox_shell").register();
        FROX_CONCH = TropicraftItems.shell("frox_conch").register();
        PAB_SHELL = TropicraftItems.shell("pab_shell").register();
        RUBE_NAUTILUS = TropicraftItems.shell("rube_nautilus").register();
        STARFISH = TropicraftItems.shell("starfish").register();
        TURTLE_SHELL = TropicraftItems.shell("turtle_shell").register();
        LOVE_TROPICS_SHELL = ((ItemBuilder)REGISTRATE.item("love_tropics_shell", LoveTropicsShellItem::new).initialProperties(Item.Properties::new).model((ctx, prov) -> prov.generated((NonNullSupplier)ctx, new ResourceLocation[]{prov.modLoc("item/ltshell"), prov.modLoc("item/ltshell_inverted")})).color(() -> () -> LoveTropicsShellItem::getColor).addMiscData(ProviderType.LANG, prov -> {
            prov.add("item.tropicraft.shell.owned.normal", "%s's Shell");
            prov.add("item.tropicraft.shell.owned.with_s", "%s' Shell");
        })).register();
        LEMON = TropicraftItems.food("lemon", Foods.LEMON).tag(new TagKey[]{TropicraftTags.Items.FRUITS}).register();
        LIME = TropicraftItems.food("lime", Foods.LIME).tag(new TagKey[]{TropicraftTags.Items.FRUITS}).tag(new TagKey[]{TropicraftTags.Items.LIME}).register();
        GRAPEFRUIT = TropicraftItems.food("grapefruit", Foods.GRAPEFRUIT).tag(new TagKey[]{TropicraftTags.Items.FRUITS}).register();
        ORANGE = TropicraftItems.food("orange", Foods.ORANGE).tag(new TagKey[]{TropicraftTags.Items.FRUITS}).register();
        PASSIONFRUIT = TropicraftItems.food("passionfruit", Foods.PASSIONFRUIT).tag(new TagKey[]{TropicraftTags.Items.FRUITS}).register();
        JOCOTE = TropicraftItems.food("jocote", Foods.JOCOTE).tag(new TagKey[]{TropicraftTags.Items.FRUITS}).register();
        PINEAPPLE_CUBES = TropicraftItems.food("pineapple_cubes", Foods.PINEAPPLE_CUBES).register();
        COCONUT_CHUNK = TropicraftItems.food("coconut_chunk", Foods.COCONUT_CHUNK).register();
        RAW_COFFEE_BEAN = REGISTRATE.item("raw_coffee_bean", p -> new ItemNameBlockItem((Block)TropicraftBlocks.COFFEE_BUSH.get(), p)).recipe((ctx, prov) -> ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ctx.get())).m_126209_((ItemLike)COFFEE_BERRY.get()).m_126132_("has_coffee_bean", (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)((ItemLike)COFFEE_BERRY.get()))).m_176498_((Consumer)prov)).register();
        ROASTED_COFFEE_BEAN = TropicraftItems.simpleItem("roasted_coffee_bean").recipe((ctx, prov) -> prov.food(TropicraftItems.ingredient(RAW_COFFEE_BEAN), RecipeCategory.FOOD, (Supplier)ctx, 0.1f)).register();
        COFFEE_BERRY = TropicraftItems.simpleItem("coffee_berry").register();
        BAMBOO_MUG = TropicraftItems.simpleItem("bamboo_mug").recipe((ctx, prov) -> ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ctx.get())).m_126130_("X X").m_126130_("X X").m_126130_("XXX").m_126127_(Character.valueOf('X'), (ItemLike)Items.f_41911_).m_126132_("has_bamboo", (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)Items.f_41911_)).m_176498_((Consumer)prov)).register();
        BAMBOO_BOWL = TropicraftItems.simpleItem("bamboo_bowl").recipe((ctx, prov) -> ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ctx.get())).m_126130_("X X").m_126130_(" X ").m_126127_(Character.valueOf('X'), (ItemLike)Items.f_41911_).m_126132_("has_bamboo", (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)Items.f_41911_)).m_176498_((Consumer)prov)).register();
        GREEN_PLANTAIN = TropicraftItems.food("green_plantain", Foods.PLANTAIN).tag(new TagKey[]{TropicraftTags.Items.PLANTAIN}).register();
        YELLOW_PLANTAIN = TropicraftItems.food("yellow_plantain", Foods.PLANTAIN).tag(new TagKey[]{TropicraftTags.Items.PLANTAIN}).register();
        DRIED_PLANTAINS = TropicraftItems.food("dried_plantains", Foods.DRIED_PLANTAINS).recipe((ctx, prov) -> prov.food(DataIngredient.tag(TropicraftTags.Items.PLANTAIN), RecipeCategory.FOOD, (Supplier)ctx, 0.1f)).register();
        MOFONGO = REGISTRATE.item("mofongo", p -> new FoodDishItem((Item.Properties)p, (Supplier<? extends ItemLike>)BAMBOO_BOWL)).properties(p -> p.m_41489_(Foods.MOFONGO).m_41495_((Item)BAMBOO_BOWL.get())).recipe((ctx, prov) -> ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ctx.get())).m_126211_(DRIED_PLANTAINS, 2).m_126209_(BAMBOO_BOWL).m_126209_((ItemLike)Items.f_42486_).m_126132_("has_plantains", (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_(DRIED_PLANTAINS)).m_176498_((Consumer)prov)).register();
        COCKTAILS = (ImmutableMap)Drink.DRINKS.values().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), drink -> REGISTRATE.item(drink.name, p -> {
            CocktailItem item = new CocktailItem((Drink)drink, (Item.Properties)p);
            MixerRecipes.setDrinkItem(drink, item);
            return item;
        }).properties(p -> p.m_41503_(0).m_41487_(1).m_41495_((Item)BAMBOO_MUG.get())).model((ctx, prov) -> prov.generated((NonNullSupplier)ctx, new ResourceLocation[]{prov.modLoc("item/cocktail"), prov.modLoc("item/cocktail_contents")})).color(() -> () -> (stack, tintIndex) -> {
            if (tintIndex == 0) {
                return 0xFFFFFF;
            }
            return drink == Drink.COCKTAIL ? CocktailItem.getCocktailColor(stack) : drink.color;
        }).lang(drink.getName()).register()));
        REGISTRATE.addDataGenerator(ProviderType.RECIPE, prov -> ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)((ItemEntry)COCKTAILS.get((Object)Drink.PINA_COLADA)).get())).m_126209_((ItemLike)BAMBOO_MUG.get()).m_126209_((ItemLike)COCONUT_CHUNK.get()).m_126209_((ItemLike)PINEAPPLE_CUBES.get()).m_126132_("has_bamboo_mug", (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)((ItemLike)BAMBOO_MUG.get()))).m_176498_((Consumer)prov));
        WHITE_PEARL = TropicraftItems.simpleItem("white_pearl").register();
        BLACK_PEARL = TropicraftItems.simpleItem("black_pearl").register();
        SCALE = TropicraftItems.simpleItem("scale").register();
        NIGEL_STACHE = REGISTRATE.item("nigel_stache", NigelStacheItem::new).lang("Nigel's Moustache").register();
        COOL_SHADES = REGISTRATE.item("cool_shades", SunglassesItem::new).properties(p -> p.m_41487_(1)).model((ctx, prov) -> {}).register();
        FRESH_MARLIN = TropicraftItems.food("fresh_marlin", Foods.FRESH_MARLIN).register();
        SEARED_MARLIN = TropicraftItems.food("seared_marlin", Foods.SEARED_MARLIN).recipe((ctx, prov) -> prov.food(TropicraftItems.ingredient(FRESH_MARLIN), RecipeCategory.FOOD, (Supplier)ctx, 0.15f)).register();
        RAW_RAY = TropicraftItems.food("raw_ray", Foods.RAW_RAY).register();
        COOKED_RAY = TropicraftItems.food("cooked_ray", Foods.COOKED_RAY).recipe((ctx, prov) -> prov.food(TropicraftItems.ingredient(RAW_RAY), RecipeCategory.FOOD, (Supplier)ctx, 0.15f)).register();
        FROG_LEG = TropicraftItems.food("frog_leg", Foods.RAW_FROG_LEG).register();
        COOKED_FROG_LEG = TropicraftItems.food("cooked_frog_leg", Foods.COOKED_FROG_LEG).recipe((ctx, prov) -> prov.food(TropicraftItems.ingredient(FROG_LEG), RecipeCategory.FOOD, (Supplier)ctx, 0.1f)).register();
        SEA_URCHIN_ROE = TropicraftItems.food("sea_urchin_roe", Foods.SEA_URCHIN_ROE).register();
        TOASTED_NORI = TropicraftItems.food("toasted_nori", Foods.TOASTED_NORI).recipe((ctx, prov) -> prov.food(DataIngredient.items((ItemLike)Items.f_41867_, (ItemLike[])new Item[0]), RecipeCategory.FOOD, (Supplier)ctx, 0.1f)).register();
        RAW_FISH = TropicraftItems.food("raw_fish", Foods.RAW_FISH).tag(new TagKey[]{ItemTags.f_13156_}).model((ctx, prov) -> prov.generated((NonNullSupplier)ctx, new ResourceLocation[]{prov.modLoc("item/smolfish")})).register();
        COOKED_FISH = TropicraftItems.food("cooked_fish", Foods.COOKED_FISH).tag(new TagKey[]{ItemTags.f_13156_}).recipe((ctx, prov) -> prov.food(TropicraftItems.ingredient(RAW_FISH), RecipeCategory.FOOD, (Supplier)ctx, 0.1f)).model((ctx, prov) -> prov.generated((NonNullSupplier)ctx, new ResourceLocation[]{prov.modLoc("item/cooked_smolfish")})).register();
        POISON_FROG_SKIN = TropicraftItems.simpleItem("poison_frog_skin").register();
        IGUANA_LEATHER = TropicraftItems.simpleItem("iguana_leather").tag(new TagKey[]{Tags.Items.LEATHER}).register();
        TROPICAL_FERTILIZER = REGISTRATE.item("tropical_fertilizer", TropicalFertilizerItem::new).recipe((ctx, prov) -> ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ctx.get())).m_126209_((ItemLike)TropicraftFlower.MAGIC_MUSHROOM.get()).m_126209_((ItemLike)TropicraftFlower.CROTON.get()).m_126132_("has_magic_mushroom", (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)TropicraftFlower.MAGIC_MUSHROOM.get())).m_176498_((Consumer)prov)).register();
        BAMBOO_ITEM_FRAME = REGISTRATE.item("bamboo_item_frame", BambooItemFrameItem::new).recipe((ctx, prov) -> ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get()), (int)1).m_126130_("XXX").m_126130_("XYX").m_126130_("XXX").m_126127_(Character.valueOf('X'), (ItemLike)Items.f_41911_).m_126127_(Character.valueOf('Y'), (ItemLike)Items.f_42454_).m_126132_("has_bamboo", (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)Items.f_41911_)).m_126132_("has_leather", (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)Items.f_42454_)).m_176498_((Consumer)prov)).register();
        MUSIC_DISCS = (ImmutableMap)Arrays.stream(RecordMusic.values()).collect(Maps.toImmutableEnumMap(Function.identity(), type -> ((ItemBuilder)REGISTRATE.item("music_disc_" + type.name().toLowerCase(Locale.ROOT), p -> new TropicalMusicDiscItem((RecordMusic)((Object)type), (Item.Properties)p)).properties(p -> p.m_41497_(Rarity.RARE)).tag(new TagKey[]{ItemTags.f_13158_}).setData(ProviderType.LANG, (ctx, prov) -> prov.addItemWithTooltip((NonNullSupplier)ctx, "Music Disc", type.getTooltip()))).register()));
        TROPICAL_FISH_BUCKET = TropicraftItems.fishBucket("tropical_fish_bucket", TropicraftEntities.TROPICAL_FISH).register();
        SARDINE_BUCKET = TropicraftItems.fishBucket("sardine_bucket", TropicraftEntities.RIVER_SARDINE).register();
        PIRANHA_BUCKET = TropicraftItems.fishBucket("piranha_bucket", TropicraftEntities.PIRANHA).register();
        KOA_SPAWN_EGG = TropicraftItems.customSpawnEgg("koa_spawn_egg", TropicraftEntities.KOA).lang("Koa Headband").register();
        TROPICREEPER_SPAWN_EGG = TropicraftItems.customSpawnEgg("tropicreeper_spawn_egg", TropicraftEntities.TROPICREEPER).lang("TropiCreeper Hat").register();
        IGUANA_SPAWN_EGG = TropicraftItems.customSpawnEgg("iguana_spawn_egg", TropicraftEntities.IGUANA).register();
        TROPISKELLY_SPAWN_EGG = TropicraftItems.customSpawnEgg("tropiskelly_spawn_egg", TropicraftEntities.TROPISKELLY).lang("TropiSkelly Skirt").register();
        EIH_SPAWN_EGG = TropicraftItems.customSpawnEgg("eih_spawn_egg", TropicraftEntities.EIH).lang("Eye of Head").register();
        SEA_TURTLE_SPAWN_EGG = TropicraftItems.customSpawnEgg("sea_turtle_spawn_egg", TropicraftEntities.SEA_TURTLE).register();
        MARLIN_SPAWN_EGG = TropicraftItems.customSpawnEgg("marlin_spawn_egg", TropicraftEntities.MARLIN).register();
        FAILGULL_SPAWN_EGG = TropicraftItems.customSpawnEgg("failgull_spawn_egg", TropicraftEntities.FAILGULL).register();
        DOLPHIN_SPAWN_EGG = TropicraftItems.customSpawnEgg("dolphin_spawn_egg", TropicraftEntities.DOLPHIN).register();
        SEAHORSE_SPAWN_EGG = TropicraftItems.customSpawnEgg("seahorse_spawn_egg", TropicraftEntities.SEAHORSE).register();
        TREE_FROG_SPAWN_EGG = TropicraftItems.customSpawnEgg("tree_frog_spawn_egg", TropicraftEntities.TREE_FROG).register();
        SEA_URCHIN_SPAWN_EGG = TropicraftItems.customSpawnEgg("sea_urchin_spawn_egg", TropicraftEntities.SEA_URCHIN).register();
        V_MONKEY_SPAWN_EGG = TropicraftItems.customSpawnEgg("v_monkey_spawn_egg", TropicraftEntities.V_MONKEY).lang("Vervet Monkey Spawn Egg").register();
        PIRANHA_SPAWN_EGG = TropicraftItems.customSpawnEgg("piranha_spawn_egg", TropicraftEntities.PIRANHA).register();
        SARDINE_SPAWN_EGG = TropicraftItems.customSpawnEgg("sardine_spawn_egg", TropicraftEntities.RIVER_SARDINE).register();
        TROPICAL_FISH_SPAWN_EGG = TropicraftItems.customSpawnEgg("tropical_fish_spawn_egg", TropicraftEntities.TROPICAL_FISH).register();
        EAGLE_RAY_SPAWN_EGG = TropicraftItems.customSpawnEgg("eagle_ray_spawn_egg", TropicraftEntities.EAGLE_RAY).register();
        TROPI_SPIDER_SPAWN_EGG = TropicraftItems.customSpawnEgg("tropi_spider_spawn_egg", TropicraftEntities.TROPI_SPIDER).register();
        ASHEN_SPAWN_EGG = TropicraftItems.customSpawnEgg("ashen_spawn_egg", TropicraftEntities.ASHEN).lang("Ashen Ash").register();
        HAMMERHEAD_SPAWN_EGG = TropicraftItems.customSpawnEgg("hammerhead_spawn_egg", TropicraftEntities.HAMMERHEAD).register();
        COWKTAIL_SPAWN_EGG = TropicraftItems.customSpawnEgg("cowktail_spawn_egg", TropicraftEntities.COWKTAIL).register();
        MAN_O_WAR_SPAWN_EGG = TropicraftItems.customSpawnEgg("man_o_war_spawn_egg", TropicraftEntities.MAN_O_WAR).register();
        TROPIBEE_SPAWN_EGG = TropicraftItems.customSpawnEgg("tropibee_spawn_egg", TropicraftEntities.TROPI_BEE).register();
        TAPIR_SPAWN_EGG = TropicraftItems.spawnEgg("tapir_spawn_egg", TropicraftEntities.TAPIR, 0x4C4434, 13023391).register();
        JAGUAR_SPAWN_EGG = TropicraftItems.spawnEgg("jaguar_spawn_egg", TropicraftEntities.JAGUAR, 13212738, 0x443311).register();
        BROWN_BASILISK_LIZARD_SPAWN_EGG = TropicraftItems.spawnEgg("brown_basilisk_lizard_spawn_egg", TropicraftEntities.BROWN_BASILISK_LIZARD, 4997422, 11372390).register();
        GREEN_BASILISK_LIZARD_SPAWN_EGG = TropicraftItems.spawnEgg("green_basilisk_lizard_spawn_egg", TropicraftEntities.GREEN_BASILISK_LIZARD, 6802489, 3892014).register();
        HUMMINGBIRD_SPAWN_EGG = TropicraftItems.spawnEgg("hummingbird_spawn_egg", TropicraftEntities.HUMMINGBIRD, 0x53CCC3, 14607592).register();
        FIDDLER_CRAB_SPAWN_EGG = TropicraftItems.customSpawnEgg("fiddler_crab_spawn_egg", TropicraftEntities.FIDDLER_CRAB).register();
        SPIDER_MONKEY_SPAWN_EGG = TropicraftItems.spawnEgg("spider_monkey_spawn_egg", TropicraftEntities.SPIDER_MONKEY, 15893074, 7685936).register();
        WHITE_LIPPED_PECCARY_SPAWN_EGG = TropicraftItems.spawnEgg("white_lipped_peccary_spawn_egg", TropicraftEntities.WHITE_LIPPED_PECCARY, 6708564, 5524802).register();
        CUBERA_SPAWN_EGG = TropicraftItems.spawnEgg("cubera_spawn_egg", TropicraftEntities.CUBERA, 16217649, 8858648).register();
        GIBNUT_SPAWN_EGG = TropicraftItems.spawnEgg("gibnut_spawn_egg", TropicraftEntities.GIBNUT, 4730140, 8615278).register();
        MANATEE_SPAWN_EGG = TropicraftItems.spawnEgg("manatee_spawn_egg", TropicraftEntities.MANATEE, 6907736, 12432554).register();
        SLENDER_HARVEST_MOUSE_SPAWN_EGG = TropicraftItems.spawnEgg("slender_harvest_mouse_spawn_egg", TropicraftEntities.SLENDER_HARVEST_MOUSE, 11500097, 15128511).register();
        TOUCAN_SPAWN_EGG = TropicraftItems.spawnEgg("toucan_spawn_egg", TropicraftEntities.TOUCAN, 525837, 15064155).register();
        ASHEN_MASKS = (ImmutableMap)Arrays.stream(AshenMasks.values()).collect(Maps.toImmutableEnumMap(Function.identity(), type -> REGISTRATE.item("ashen_mask_" + type.name().toLowerCase(Locale.ROOT), p -> new AshenMaskItem(ArmorMaterials.ASHEN_MASK, (AshenMasks)((Object)type), (Item.Properties)p)).tag(new TagKey[]{TropicraftTags.Items.ASHEN_MASKS}).lang(type.getName()).register()));
        DAGGER = REGISTRATE.item("dagger", p -> new DaggerItem(TropicraftToolTiers.ZIRCON, (Item.Properties)p)).properties(p -> p.m_41487_(1)).recipe((ctx, prov) -> ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ctx.get())).m_126130_("X").m_126130_("I").m_126127_(Character.valueOf('X'), (ItemLike)TropicraftBlocks.CHUNK.get()).m_126127_(Character.valueOf('I'), (ItemLike)BAMBOO_STICK.get()).m_126132_("has_" + prov.safeName((ItemLike)TropicraftBlocks.CHUNK.get()), (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)((ItemLike)TropicraftBlocks.CHUNK.get()))).m_126132_("has_bamboo", (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)Items.f_41911_)).m_176498_((Consumer)prov)).register();
        BLOW_GUN = REGISTRATE.item("blow_gun", BlowGunItem::new).properties(p -> p.m_41487_(1)).recipe((ctx, prov) -> ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ctx.get())).m_126130_("X  ").m_126130_(" I ").m_126130_("  X").m_126127_(Character.valueOf('X'), (ItemLike)BAMBOO_STICK.get()).m_126127_(Character.valueOf('I'), (ItemLike)ZIRCON.get()).m_126132_("has_" + prov.safeName((ItemLike)ZIRCON.get()), (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)((ItemLike)ZIRCON.get()))).m_126132_("has_" + prov.safeName((ItemLike)BAMBOO_STICK.get()), (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)((ItemLike)BAMBOO_STICK.get()))).m_176498_((Consumer)prov)).register();
        ZIRCON_HOE = TropicraftItems.hoe("zircon_hoe", TropicraftToolTiers.ZIRCON, ZIRCON).register();
        ZIRCONIUM_HOE = TropicraftItems.hoe("zirconium_hoe", TropicraftToolTiers.ZIRCONIUM, ZIRCONIUM).register();
        EUDIALYTE_HOE = TropicraftItems.hoe("eudialyte_hoe", TropicraftToolTiers.EUDIALYTE, EUDIALYTE).register();
        ZIRCON_AXE = TropicraftItems.axe("zircon_axe", TropicraftToolTiers.ZIRCON, ZIRCON).register();
        ZIRCONIUM_AXE = TropicraftItems.axe("zirconium_axe", TropicraftToolTiers.ZIRCONIUM, ZIRCONIUM).register();
        EUDIALYTE_AXE = TropicraftItems.axe("eudialyte_axe", TropicraftToolTiers.EUDIALYTE, EUDIALYTE).register();
        ZIRCON_PICKAXE = TropicraftItems.pickaxe("zircon_pickaxe", TropicraftToolTiers.ZIRCON, ZIRCON).register();
        ZIRCONIUM_PICKAXE = TropicraftItems.pickaxe("zirconium_pickaxe", TropicraftToolTiers.ZIRCONIUM, ZIRCONIUM).register();
        EUDIALYTE_PICKAXE = TropicraftItems.pickaxe("eudialyte_pickaxe", TropicraftToolTiers.EUDIALYTE, EUDIALYTE).register();
        ZIRCON_SHOVEL = TropicraftItems.shovel("zircon_shovel", TropicraftToolTiers.ZIRCON, ZIRCON).register();
        ZIRCONIUM_SHOVEL = TropicraftItems.shovel("zirconium_shovel", TropicraftToolTiers.ZIRCONIUM, ZIRCONIUM).register();
        EUDIALYTE_SHOVEL = TropicraftItems.shovel("eudialyte_shovel", TropicraftToolTiers.EUDIALYTE, EUDIALYTE).register();
        ZIRCON_SWORD = TropicraftItems.sword("zircon_sword", TropicraftToolTiers.ZIRCON, ZIRCON).register();
        ZIRCONIUM_SWORD = TropicraftItems.sword("zirconium_sword", TropicraftToolTiers.ZIRCONIUM, ZIRCONIUM).register();
        EUDIALYTE_SWORD = TropicraftItems.sword("eudialyte_sword", TropicraftToolTiers.EUDIALYTE, EUDIALYTE).register();
        FIRE_BOOTS = TropicraftItems.fireArmor("fire_boots", ArmorItem.Type.BOOTS).register();
        FIRE_LEGGINGS = TropicraftItems.fireArmor("fire_leggings", ArmorItem.Type.LEGGINGS).register();
        FIRE_CHESTPLATE = TropicraftItems.fireArmor("fire_chestplate", ArmorItem.Type.CHESTPLATE).register();
        FIRE_HELMET = TropicraftItems.fireArmor("fire_helmet", ArmorItem.Type.HELMET).register();
        SCALE_BOOTS = TropicraftItems.scaleArmor("scale_boots", ArmorItem.Type.BOOTS).recipe((ctx, prov) -> ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ctx.get())).m_126130_("X X").m_126130_("X X").m_126127_(Character.valueOf('X'), (ItemLike)SCALE.get()).m_126132_("has_" + prov.safeName((ItemLike)SCALE.get()), (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)((ItemLike)SCALE.get()))).m_176498_((Consumer)prov)).register();
        SCALE_LEGGINGS = TropicraftItems.scaleArmor("scale_leggings", ArmorItem.Type.LEGGINGS).recipe((ctx, prov) -> ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ctx.get())).m_126130_("XXX").m_126130_("X X").m_126130_("X X").m_126127_(Character.valueOf('X'), (ItemLike)SCALE.get()).m_126132_("has_" + prov.safeName((ItemLike)SCALE.get()), (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)((ItemLike)SCALE.get()))).m_176498_((Consumer)prov)).register();
        SCALE_CHESTPLATE = TropicraftItems.scaleArmor("scale_chestplate", ArmorItem.Type.CHESTPLATE).recipe((ctx, prov) -> ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ctx.get())).m_126130_("X X").m_126130_("XXX").m_126130_("XXX").m_126127_(Character.valueOf('X'), (ItemLike)SCALE.get()).m_126132_("has_" + prov.safeName((ItemLike)SCALE.get()), (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)((ItemLike)SCALE.get()))).m_176498_((Consumer)prov)).register();
        SCALE_HELMET = TropicraftItems.scaleArmor("scale_helmet", ArmorItem.Type.HELMET).recipe((ctx, prov) -> ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ctx.get())).m_126130_("XXX").m_126130_("X X").m_126127_(Character.valueOf('X'), (ItemLike)SCALE.get()).m_126132_("has_" + prov.safeName((ItemLike)SCALE.get()), (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)((ItemLike)SCALE.get()))).m_176498_((Consumer)prov)).register();
        YELLOW_SCUBA_GOGGLES = TropicraftItems.scubaGoggles("yellow_scuba_goggles", ScubaType.YELLOW, () -> Items.f_42539_).register();
        YELLOW_SCUBA_HARNESS = TropicraftItems.scubaHarness("yellow_scuba_harness", ScubaType.YELLOW, () -> Items.f_42539_).register();
        YELLOW_SCUBA_FLIPPERS = TropicraftItems.scubaFlippers("yellow_scuba_flippers", ScubaType.YELLOW, () -> Items.f_42539_).register();
        PINK_SCUBA_GOGGLES = TropicraftItems.scubaGoggles("pink_scuba_goggles", ScubaType.PINK, () -> Items.f_42489_).register();
        PINK_SCUBA_HARNESS = TropicraftItems.scubaHarness("pink_scuba_harness", ScubaType.PINK, () -> Items.f_42489_).register();
        PINK_SCUBA_FLIPPERS = TropicraftItems.scubaFlippers("pink_scuba_flippers", ScubaType.PINK, () -> Items.f_42489_).register();
        YELLOW_PONY_BOTTLE = TropicraftItems.ponyBottle("yellow_pony_bottle", Blocks.f_50307_);
        PINK_PONY_BOTTLE = TropicraftItems.ponyBottle("pink_pony_bottle", Blocks.f_50362_);
        WATER_WAND = REGISTRATE.item("water_wand", WaterWandItem::new).properties(p -> p.m_41487_(1).m_41503_(2000)).recipe((ctx, prov) -> ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ctx.get()), (int)1).m_126130_("  X").m_126130_(" Y ").m_126130_("Y  ").m_126127_(Character.valueOf('X'), (ItemLike)AZURITE.get()).m_126127_(Character.valueOf('Y'), (ItemLike)Items.f_42417_).m_126132_("has_" + prov.safeName((ItemLike)AZURITE.get()), (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)((ItemLike)AZURITE.get()))).m_126132_("has_gold_ingot", (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)Items.f_42417_)).m_176498_((Consumer)prov)).register();
        EXPLODING_COCONUT = REGISTRATE.item("exploding_coconut", ExplodingCoconutItem::new).register();
        FISHING_NET = TropicraftItems.simpleItem("fishing_net").properties(p -> p.m_41487_(1)).register();
        PIANGUAS = TropicraftItems.simpleItem("pianguas").register();
        MAHOGANY_SIGN = TropicraftItems.sign(TropicraftWoodTypes.MAHOGANY, TropicraftBlocks.MAHOGANY_PLANKS, TropicraftBlocks.MAHOGANY_SIGN, TropicraftBlocks.MAHOGANY_WALL_SIGN).register();
        PALM_SIGN = TropicraftItems.sign(TropicraftWoodTypes.PALM, TropicraftBlocks.PALM_PLANKS, TropicraftBlocks.PALM_SIGN, TropicraftBlocks.PALM_WALL_SIGN).register();
        BAMBOO_SIGN = TropicraftItems.sign(TropicraftWoodTypes.BAMBOO, TropicraftBlocks.BAMBOO_BUNDLE, TropicraftBlocks.BAMBOO_SIGN, TropicraftBlocks.BAMBOO_WALL_SIGN).register();
        THATCH_SIGN = TropicraftItems.sign(TropicraftWoodTypes.THATCH, TropicraftBlocks.THATCH_BUNDLE, TropicraftBlocks.THATCH_SIGN, TropicraftBlocks.THATCH_WALL_SIGN).register();
        MANGROVE_SIGN = TropicraftItems.sign(TropicraftWoodTypes.MANGROVE, TropicraftBlocks.MANGROVE_PLANKS, TropicraftBlocks.MANGROVE_SIGN, TropicraftBlocks.MANGROVE_WALL_SIGN).register();
        GENERATED_TRIM_MATERIALS = List.of(new TrimMaterial("quartz", 0.1f), new TrimMaterial("iron", 0.2f), new TrimMaterial("netherite", 0.3f), new TrimMaterial("redstone", 0.4f), new TrimMaterial("copper", 0.5f), new TrimMaterial("gold", 0.6f), new TrimMaterial("emerald", 0.7f), new TrimMaterial("diamond", 0.8f), new TrimMaterial("lapis", 0.9f), new TrimMaterial("amethyst", 1.0f));
    }

    private record TrimMaterial(String name, float itemModelIndex) {
    }
}

