/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item.scuba;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.tropicraft.core.client.scuba.ModelScubaGear;
import net.tropicraft.core.common.item.ArmorMaterials;
import net.tropicraft.core.common.item.TropicraftArmorItem;
import net.tropicraft.core.common.item.scuba.ScubaGogglesItem;
import net.tropicraft.core.common.item.scuba.ScubaType;
import org.jetbrains.annotations.Nullable;

public class ScubaArmorItem
extends TropicraftArmorItem {
    private static final ResourceLocation GOGGLES_OVERLAY_TEX_PATH = new ResourceLocation("tropicraft", "textures/gui/goggles.png");
    private final ScubaType type;

    public ScubaArmorItem(ScubaType type, ArmorItem.Type slotType, Item.Properties properties) {
        super(ArmorMaterials.SCUBA, slotType, properties);
        this.type = type;
    }

    public ScubaType getScubaType() {
        return this.type;
    }

    public boolean providesAir() {
        return false;
    }

    public void tickAir(Player player, EquipmentSlot slot, ItemStack stack) {
    }

    public int addAir(int air, ItemStack stack) {
        return 0;
    }

    public int getRemainingAir(ItemStack stack) {
        return 0;
    }

    public int getMaxAir(ItemStack stack) {
        return 0;
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return ScubaArmorItem.getArmorTexture(this.type).toString();
    }

    public static ResourceLocation getArmorTexture(ScubaType material) {
        return new ResourceLocation("tropicraft:textures/models/armor/scuba_gear_" + material.getTextureName() + ".png");
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity entity, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> original) {
                if (stack.m_41619_()) {
                    return null;
                }
                HumanoidModel<?> armorModel = this.getArmorModel(slot);
                if (armorModel != null) {
                    this.prepareModel(armorModel, entity);
                    return armorModel;
                }
                return null;
            }

            @Nullable
            private HumanoidModel<?> getArmorModel(EquipmentSlot armorSlot) {
                return switch (armorSlot) {
                    case EquipmentSlot.HEAD -> ModelScubaGear.HEAD;
                    case EquipmentSlot.CHEST -> ModelScubaGear.CHEST;
                    case EquipmentSlot.FEET -> ModelScubaGear.FEET;
                    default -> null;
                };
            }

            private <E extends LivingEntity> void prepareModel(HumanoidModel<E> armorModel, LivingEntity entity) {
                armorModel.m_6839_(entity, 0.0f, 0.0f, 1.0f);
                armorModel.f_102817_ = entity.m_6144_();
                armorModel.f_102610_ = entity.m_6162_();
                armorModel.f_102816_ = entity.m_21205_() != null ? HumanoidModel.ArmPose.BLOCK : HumanoidModel.ArmPose.EMPTY;
            }

            public void renderHelmetOverlay(ItemStack stack, Player player, int width, int height, float partialTicks) {
                if (stack.m_41720_() instanceof ScubaGogglesItem) {
                    Minecraft mc = Minecraft.m_91087_();
                    GuiGraphics graphics = new GuiGraphics(mc, mc.m_91269_().m_110104_());
                    RenderSystem.disableDepthTest();
                    RenderSystem.depthMask((boolean)false);
                    RenderSystem.defaultBlendFunc();
                    graphics.m_280398_(GOGGLES_OVERLAY_TEX_PATH, 0, 0, 0, 0.0f, 0.0f, width, height, width, height);
                    RenderSystem.depthMask((boolean)true);
                    RenderSystem.enableDepthTest();
                    graphics.m_280262_();
                }
            }
        });
    }
}

