/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item.scuba;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.shaders.FogShape;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Camera;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.FogType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.tropicraft.core.client.data.TropicraftLangKeys;
import net.tropicraft.core.common.item.scuba.ScubaArmorItem;
import net.tropicraft.core.common.item.scuba.ScubaType;

@Mod.EventBusSubscriber(modid="tropicraft", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ScubaGogglesItem
extends ScubaArmorItem {
    public static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ATTRIBUTES, (String)"tropicraft");
    private static final RegistryObject<Attribute> UNDERWATER_VISIBILITY = ATTRIBUTES.register("underwater_visibility", () -> new RangedAttribute(TropicraftLangKeys.SCUBA_VISIBILITY_STAT.key(), 0.0, -1.0, 1.0));
    private static final AttributeModifier VISIBILITY_BOOST = new AttributeModifier(UUID.fromString("b09a907f-8264-455b-af81-997c06aa2268"), "tropicraft.underwater.visibility", 0.25, AttributeModifier.Operation.MULTIPLY_BASE);
    private final Supplier<Multimap<Attribute, AttributeModifier>> boostedModifiers = Suppliers.memoize(() -> ImmutableMultimap.builder().putAll(super.getAttributeModifiers(EquipmentSlot.HEAD, new ItemStack((ItemLike)this))).put((Object)((Attribute)UNDERWATER_VISIBILITY.get()), (Object)VISIBILITY_BOOST).build());

    public ScubaGogglesItem(ScubaType type, Item.Properties builder) {
        super(type, ArmorItem.Type.HELMET, builder);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void renderWaterFog(ViewportEvent.RenderFog event) {
        LocalPlayer player;
        Entity entity;
        if (event.getFogShape() == FogShape.CYLINDER) {
            return;
        }
        Camera camera = event.getCamera();
        if (camera.m_167685_() == FogType.WATER && (entity = camera.m_90592_()) instanceof LocalPlayer && (player = (LocalPlayer)entity).m_6844_(EquipmentSlot.HEAD).m_41720_() instanceof ScubaGogglesItem) {
            event.setFarPlaneDistance(event.getFarPlaneDistance() * 1.25f);
            event.setCanceled(true);
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.HEAD) {
            return this.boostedModifiers.get();
        }
        return super.getAttributeModifiers(slot, stack);
    }
}

