/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.dummyplayers.repack.registrate.builders;

import com.tterrag.dummyplayers.repack.registrate.AbstractRegistrate;
import com.tterrag.dummyplayers.repack.registrate.builders.AbstractBuilder;
import com.tterrag.dummyplayers.repack.registrate.builders.BuilderCallback;
import com.tterrag.dummyplayers.repack.registrate.builders.ItemBuilder;
import com.tterrag.dummyplayers.repack.registrate.providers.ProviderType;
import com.tterrag.dummyplayers.repack.registrate.providers.loot.RegistrateEntityLootTables;
import com.tterrag.dummyplayers.repack.registrate.providers.loot.RegistrateLootTableProvider;
import com.tterrag.dummyplayers.repack.registrate.util.OneTimeEventReceiver;
import com.tterrag.dummyplayers.repack.registrate.util.entry.EntityEntry;
import com.tterrag.dummyplayers.repack.registrate.util.entry.RegistryEntry;
import com.tterrag.dummyplayers.repack.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.dummyplayers.repack.registrate.util.nullness.NonNullConsumer;
import com.tterrag.dummyplayers.repack.registrate.util.nullness.NonNullFunction;
import com.tterrag.dummyplayers.repack.registrate.util.nullness.NonNullSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class EntityBuilder<T extends Entity, P>
extends AbstractBuilder<EntityType<?>, EntityType<T>, P, EntityBuilder<T, P>> {
    private final NonNullSupplier<EntityType.Builder<T>> builder;
    private NonNullConsumer<EntityType.Builder<T>> builderCallback = $ -> {};
    @Nullable
    private NonNullSupplier<NonNullFunction<EntityRendererProvider.Context, EntityRenderer<? super T>>> renderer;
    private boolean attributesConfigured;
    private boolean spawnConfigured;

    public static <T extends Entity, P> EntityBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, EntityType.EntityFactory<T> factory, MobCategory classification) {
        return new EntityBuilder<T, P>(owner, parent, name, callback, factory, classification).defaultLang();
    }

    protected EntityBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, EntityType.EntityFactory<T> factory, MobCategory classification) {
        super(owner, parent, name, callback, ForgeRegistries.Keys.ENTITY_TYPES);
        this.builder = () -> EntityType.Builder.m_20704_((EntityType.EntityFactory)factory, (MobCategory)classification);
    }

    public EntityBuilder<T, P> properties(NonNullConsumer<EntityType.Builder<T>> cons) {
        this.builderCallback = this.builderCallback.andThen(cons);
        return this;
    }

    public EntityBuilder<T, P> renderer(NonNullSupplier<NonNullFunction<EntityRendererProvider.Context, EntityRenderer<? super T>>> renderer) {
        if (this.renderer == null) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::registerRenderer);
        }
        this.renderer = renderer;
        return this;
    }

    protected void registerRenderer() {
        OneTimeEventReceiver.addModListener(this.getOwner(), EntityRenderersEvent.RegisterRenderers.class, evt -> {
            NonNullSupplier<NonNullFunction<EntityRendererProvider.Context, EntityRenderer<T>>> renderer = this.renderer;
            if (renderer != null) {
                try {
                    NonNullFunction<EntityRendererProvider.Context, EntityRenderer<? super T>> provider = renderer.get();
                    evt.registerEntityRenderer((EntityType)this.getEntry(), provider::apply);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to register renderer for Entity " + ((RegistryEntry)this.get()).getId(), e);
                }
            }
        });
    }

    public EntityBuilder<T, P> attributes(Supplier<AttributeSupplier.Builder> attributes) {
        if (this.attributesConfigured) {
            throw new IllegalStateException("Cannot configure attributes more than once");
        }
        this.attributesConfigured = true;
        OneTimeEventReceiver.addModListener(this.getOwner(), EntityAttributeCreationEvent.class, e -> e.put((EntityType)this.getEntry(), ((AttributeSupplier.Builder)attributes.get()).m_22265_()));
        return this;
    }

    public EntityBuilder<T, P> spawnPlacement(SpawnPlacements.Type type, Heightmap.Types heightmap, SpawnPlacements.SpawnPredicate<T> predicate) {
        if (this.spawnConfigured) {
            throw new IllegalStateException("Cannot configure spawn placement more than once");
        }
        this.spawnConfigured = true;
        this.onRegister(t -> SpawnPlacements.m_21754_((EntityType)t, (SpawnPlacements.Type)type, (Heightmap.Types)heightmap, (SpawnPlacements.SpawnPredicate)predicate));
        return this;
    }

    @Deprecated
    public EntityBuilder<T, P> defaultSpawnEgg(int primaryColor, int secondaryColor) {
        return (EntityBuilder)this.spawnEgg(primaryColor, secondaryColor).build();
    }

    @Deprecated
    public ItemBuilder<? extends SpawnEggItem, EntityBuilder<T, P>> spawnEgg(int primaryColor, int secondaryColor) {
        NonNullSupplier sup = this.asSupplier();
        return this.getOwner().item(this, this.getName() + "_spawn_egg", p -> new ForgeSpawnEggItem((Supplier)sup, primaryColor, secondaryColor, p)).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256731_).model((ctx, prov) -> prov.withExistingParent(ctx.getName(), new ResourceLocation("item/template_spawn_egg")));
    }

    public EntityBuilder<T, P> defaultLang() {
        return (EntityBuilder)this.lang(EntityType::m_20675_);
    }

    public EntityBuilder<T, P> lang(String name) {
        return (EntityBuilder)this.lang(EntityType::m_20675_, name);
    }

    public EntityBuilder<T, P> loot(NonNullBiConsumer<RegistrateEntityLootTables, EntityType<T>> cons) {
        return (EntityBuilder)this.setData(ProviderType.LOOT, (ctx, prov) -> prov.addLootAction(RegistrateLootTableProvider.LootType.ENTITY, tb -> cons.accept((RegistrateEntityLootTables)tb, (EntityType)((EntityType)ctx.getEntry()))));
    }

    @SafeVarargs
    public final EntityBuilder<T, P> tag(TagKey<EntityType<?>> ... tags) {
        return (EntityBuilder)this.tag(ProviderType.ENTITY_TAGS, tags);
    }

    @Override
    protected EntityType<T> createEntry() {
        EntityType.Builder<T> builder = this.builder.get();
        this.builderCallback.accept(builder);
        return builder.m_20712_(this.getName());
    }

    @Deprecated
    protected void injectSpawnEggType(EntityType<T> entry) {
    }

    @Override
    protected RegistryEntry<EntityType<T>> createEntryWrapper(RegistryObject<EntityType<T>> delegate) {
        return new EntityEntry<T>(this.getOwner(), delegate);
    }

    @Override
    public EntityEntry<T> register() {
        return (EntityEntry)super.register();
    }
}

