/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.tutorials;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lovetropics.tutorials.TutorialConfig;
import org.lovetropics.tutorials.network.ClientboundSendTutorialsPacket;

@EventBusSubscriber(modid="lttutorials")
public final class ServerTutorials {
    private static final Logger LOGGER = LogManager.getLogger(ServerTutorials.class);
    private static List<TutorialConfig> tutorials = new ArrayList<TutorialConfig>();
    private static boolean changed;

    @SubscribeEvent
    public static void addReloadListener(AddReloadListenerEvent event) {
        event.addListener((stage, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor) -> {
            CompletableFuture<List> future = CompletableFuture.supplyAsync(() -> {
                ArrayList tutorials = new ArrayList();
                FileToIdConverter lister = FileToIdConverter.json((String)"tutorials");
                lister.listMatchingResources(resourceManager).forEach((id, resource) -> {
                    try {
                        DataResult<TutorialConfig> result = ServerTutorials.loadTutorial(resource);
                        result.result().ifPresent(tutorials::add);
                        result.error().ifPresent(error -> LOGGER.error("Failed to load tutorial config at {}: {}", id, error));
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to load tutorial config at {}", id, (Object)e);
                    }
                });
                return tutorials;
            }, backgroundExecutor);
            return ((CompletableFuture)future.thenAcceptAsync(ServerTutorials::setTutorials, gameExecutor)).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).wait(arg_0));
        });
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ServerTutorials.sendTutorialsTo(player2, tutorials);
        }
    }

    @SubscribeEvent
    public static void tick(LevelTickEvent.Pre event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        if (!changed) {
            return;
        }
        MinecraftServer server = event.getLevel().getServer();
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            ServerTutorials.sendTutorialsTo(player, tutorials);
        }
        changed = false;
    }

    private static void setTutorials(List<TutorialConfig> tutorials) {
        ServerTutorials.tutorials = tutorials;
        changed = true;
    }

    private static void sendTutorialsTo(ServerPlayer player, List<TutorialConfig> tutorials) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientboundSendTutorialsPacket(tutorials), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static DataResult<TutorialConfig> loadTutorial(Resource resource) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.open()));){
            JsonElement json = JsonParser.parseReader((Reader)reader);
            DataResult dataResult = TutorialConfig.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
            return dataResult;
        }
    }
}

