/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.tutorials.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMaps;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4fStack;
import org.lovetropics.tutorials.TutorialConfig;
import org.lovetropics.tutorials.client.TutorialClientState;
import org.lovetropics.tutorials.client.widget.TutorialWidgetRenderer;
import org.lovetropics.tutorials.client.widget.TutorialWidgetRenderers;
import org.lovetropics.tutorials.widget.TutorialWidget;

@EventBusSubscriber(modid="lttutorials", value={Dist.CLIENT})
public final class TutorialRenderManager {
    private static final Minecraft CLIENT = Minecraft.getInstance();
    private static DisplayState displayState;

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Pre event) {
        LocalPlayer player = TutorialRenderManager.CLIENT.player;
        if (player == null) {
            return;
        }
        DisplayState displayState = TutorialRenderManager.getDisplayState();
        if (displayState != null) {
            Entity camera = CLIENT.getCameraEntity();
            if (camera == null) {
                camera = player;
            }
            displayState.tick(camera);
        }
    }

    @Nullable
    private static DisplayState getDisplayState() {
        TutorialClientState clientState = TutorialClientState.get();
        DisplayState displayState = TutorialRenderManager.displayState;
        if (clientState != null && displayState == null || displayState != null && displayState.clientState != clientState) {
            TutorialRenderManager.displayState = displayState = new DisplayState(clientState);
        } else if (clientState == null && displayState != null) {
            TutorialRenderManager.displayState = null;
        }
        return displayState;
    }

    @SubscribeEvent
    public static void onRenderWorldLast(RenderLevelStageEvent event) {
        DisplayState displayState = TutorialRenderManager.displayState;
        if (displayState == null || event.getStage() != RenderLevelStageEvent.Stage.AFTER_WEATHER) {
            return;
        }
        Camera camera = TutorialRenderManager.CLIENT.gameRenderer.getMainCamera();
        if (!camera.isInitialized()) {
            return;
        }
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.pushMatrix();
        modelViewStack.identity();
        RenderSystem.applyModelViewMatrix();
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource.BufferSource bufferSource = CLIENT.renderBuffers().bufferSource();
        for (Reference2IntMap.Entry entry : Reference2IntMaps.fastIterable(displayState.visible)) {
            TutorialConfig tutorial = (TutorialConfig)entry.getKey();
            List<TutorialWidget> widgets = tutorial.getWidgets();
            float animation = (float)entry.getIntValue() / 10.0f;
            for (TutorialWidget widget : widgets) {
                TutorialRenderManager.renderWidget(widget, event.getLevelRenderer(), poseStack, (MultiBufferSource)bufferSource, camera, event.getPartialTick().getGameTimeDeltaTicks(), animation);
            }
        }
        bufferSource.endLastBatch();
        modelViewStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
    }

    public static <T extends TutorialWidget> void renderWidget(T widget, LevelRenderer context, PoseStack poseStack, MultiBufferSource bufferSource, Camera camera, float partialTicks, float animation) {
        if (animation <= 0.01f) {
            return;
        }
        TutorialWidgetRenderer<T> renderer = TutorialWidgetRenderers.rendererFor(widget);
        if (renderer != null) {
            renderer.render(widget, context, poseStack, bufferSource, camera, partialTicks, animation);
        }
    }

    public static <T extends TutorialWidget> void tickWidget(T widget, Entity camera) {
        TutorialWidgetRenderer<T> renderer = TutorialWidgetRenderers.rendererFor(widget);
        if (renderer != null) {
            renderer.tick(widget, camera);
        }
    }

    static final class DisplayState {
        private static final int ANIMATION_TICKS = 10;
        private final TutorialClientState clientState;
        private final Set<TutorialConfig> active = new ReferenceOpenHashSet();
        private final Reference2IntMap<TutorialConfig> visible = new Reference2IntOpenHashMap();
        private BlockPos lastPlayerPos;

        DisplayState(TutorialClientState clientState) {
            this.clientState = clientState;
        }

        void tick(Entity camera) {
            Set<TutorialConfig> active = this.active;
            Reference2IntMap<TutorialConfig> visible = this.visible;
            ResourceKey dimension = camera.level().dimension();
            BlockPos pos = camera.blockPosition();
            if (!pos.equals((Object)this.lastPlayerPos)) {
                this.lastPlayerPos = pos;
                active.clear();
                for (TutorialConfig tutorial : this.clientState.getTutorialsAt((ResourceKey<Level>)dimension, pos)) {
                    active.add(tutorial);
                    visible.putIfAbsent((Object)tutorial, 0);
                }
            }
            this.tickVisibleTutorials(camera, visible);
        }

        private void tickVisibleTutorials(Entity camera, Reference2IntMap<TutorialConfig> visible) {
            ObjectIterator iterator = Reference2IntMaps.fastIterator(visible);
            while (iterator.hasNext()) {
                Reference2IntMap.Entry entry = (Reference2IntMap.Entry)iterator.next();
                TutorialConfig tutorial = (TutorialConfig)entry.getKey();
                int ticks = this.tickTutorial(camera, entry.getIntValue(), tutorial);
                entry.setValue(ticks);
                if (ticks > 0) continue;
                iterator.remove();
            }
        }

        private int tickTutorial(Entity camera, int ticks, TutorialConfig tutorial) {
            List<TutorialWidget> widgets = tutorial.getWidgets();
            for (TutorialWidget widget : widgets) {
                TutorialRenderManager.tickWidget(widget, camera);
            }
            if (this.active.contains(tutorial)) {
                return ticks < 10 ? ticks + 1 : ticks;
            }
            return ticks - 1;
        }
    }
}

