/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.tutorials.client.widget;

import com.lovetropics.lib.BlockBox;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.lovetropics.tutorials.client.widget.TutorialWidgetRenderer;
import org.lovetropics.tutorials.util.Easings;
import org.lovetropics.tutorials.widget.BlockHighlightWidget;

public final class BlockHighlightRenderer
implements TutorialWidgetRenderer<BlockHighlightWidget> {
    private static final Minecraft CLIENT = Minecraft.getInstance();

    @Override
    public void render(BlockHighlightWidget widget, LevelRenderer context, PoseStack poseStack, MultiBufferSource bufferSource, Camera camera, float partialTicks, float animation) {
        BlockBox box = widget.box();
        int color = widget.color().getValue();
        float red = (float)FastColor.ARGB32.red((int)color) / 255.0f;
        float green = (float)FastColor.ARGB32.green((int)color) / 255.0f;
        float blue = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
        float alpha = Easings.inOutSine(animation) * 0.5f;
        float time = BlockHighlightRenderer.CLIENT.player != null ? (float)BlockHighlightRenderer.CLIENT.player.tickCount + partialTicks : 0.0f;
        Vec3 view = camera.getPosition();
        DebugRenderer.renderFilledBox((PoseStack)poseStack, (MultiBufferSource)bufferSource, (double)((double)box.min().getX() - view.x), (double)((double)box.min().getY() - view.y), (double)((double)box.min().getZ() - view.z), (double)((double)box.max().getX() + 1.0 - view.x), (double)((double)box.max().getY() + 1.0 - view.y), (double)((double)box.max().getZ() + 1.0 - view.z), (float)red, (float)green, (float)blue, (float)(alpha *= Mth.sin((float)(time * 0.25f)) * 0.1f + 0.9f));
    }
}

