/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.tutorials.client.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.lovetropics.tutorials.client.widget.TutorialWidgetRenderer;
import org.lovetropics.tutorials.util.Easings;
import org.lovetropics.tutorials.widget.ImageDisplayWidget;

public final class ImageDisplayRenderer
implements TutorialWidgetRenderer<ImageDisplayWidget> {
    @Override
    public void render(ImageDisplayWidget widget, LevelRenderer context, PoseStack poseStack, MultiBufferSource bufferSource, Camera camera, float partialTicks, float animation) {
        Vec3 view = camera.getPosition();
        Vec3 pos = widget.getPos();
        ImageDisplayWidget.Texture texture = widget.getTexture();
        float scale = widget.getScale();
        Matrix4f pointAlong = widget.getPointAlongMatrix();
        poseStack.pushPose();
        poseStack.translate(pos.x - view.x, pos.y - view.y, pos.z - view.z);
        if (pointAlong != null) {
            poseStack.mulPose(pointAlong);
        } else {
            poseStack.mulPose(camera.rotation());
        }
        poseStack.scale(-scale, -scale, scale);
        float alpha = Easings.inOutSine(animation);
        VertexConsumer builder = bufferSource.getBuffer(RenderType.textSeeThrough((ResourceLocation)texture.getPath()));
        float textureWidth = texture.getWidth();
        float textureHeight = texture.getHeight();
        float minSize = Math.min(textureWidth, textureHeight);
        float width = 0.5f * textureWidth / minSize;
        float height = 0.5f * textureHeight / minSize;
        Matrix4f pose = poseStack.last().pose();
        builder.addVertex(pose, -width, -height, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha).setUv(texture.getMinU(), texture.getMinV()).setUv2(240, 240);
        builder.addVertex(pose, width, -height, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha).setUv(texture.getMaxU(), texture.getMinV()).setUv2(240, 240);
        builder.addVertex(pose, width, height, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha).setUv(texture.getMaxU(), texture.getMaxV()).setUv2(240, 240);
        builder.addVertex(pose, -width, height, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha).setUv(texture.getMinU(), texture.getMaxV()).setUv2(240, 240);
        poseStack.popPose();
    }
}

