/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.tutorials.client.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.lovetropics.tutorials.client.widget.TutorialWidgetRenderer;
import org.lovetropics.tutorials.util.Easings;
import org.lovetropics.tutorials.widget.TextDisplayWidget;

public final class TextDisplayRenderer
implements TutorialWidgetRenderer<TextDisplayWidget> {
    private static final Minecraft CLIENT = Minecraft.getInstance();

    @Override
    public void render(TextDisplayWidget widget, LevelRenderer context, PoseStack poseStack, MultiBufferSource bufferSource, Camera camera, float partialTicks, float animation) {
        Vec3 view = camera.getPosition();
        Vec3 pos = widget.getPos();
        Component text = widget.getText();
        float scale = widget.getScale();
        Matrix4f pointAlong = widget.getPointAlongMatrix();
        poseStack.pushPose();
        poseStack.translate(pos.x - view.x, pos.y - view.y, pos.z - view.z);
        if (pointAlong != null) {
            poseStack.mulPose(pointAlong);
        } else {
            poseStack.mulPose(camera.rotation());
        }
        poseStack.scale(scale, -scale, scale);
        float alpha = Easings.inOutSine(animation);
        if (alpha >= 0.1f) {
            Font font = TextDisplayRenderer.CLIENT.font;
            int textColor = TextDisplayRenderer.alphaToColor(alpha) | 0xFFFFFF;
            int backgroundColor = TextDisplayRenderer.alphaToColor(TextDisplayRenderer.CLIENT.options.getBackgroundOpacity(0.25f) * alpha);
            List lines = font.split((FormattedText)text, widget.getWrapLength());
            int n = lines.size();
            Objects.requireNonNull(font);
            float lineY = (float)(-(n * 9)) / 2.0f;
            for (FormattedCharSequence line : lines) {
                font.drawInBatch(line, (float)(-font.width(line)) / 2.0f, lineY, textColor, false, poseStack.last().pose(), bufferSource, Font.DisplayMode.NORMAL, backgroundColor, 0xF000F0);
                Objects.requireNonNull(font);
                lineY += 9.0f;
            }
        }
        poseStack.popPose();
    }

    private static int alphaToColor(float alpha) {
        return Mth.floor((float)(alpha * 255.0f)) << 24;
    }
}

