/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.tutorials.client.widget;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import org.lovetropics.tutorials.client.widget.BlockHighlightRenderer;
import org.lovetropics.tutorials.client.widget.FocusingWidgetRenderer;
import org.lovetropics.tutorials.client.widget.ImageDisplayRenderer;
import org.lovetropics.tutorials.client.widget.TextDisplayRenderer;
import org.lovetropics.tutorials.client.widget.TutorialWidgetRenderer;
import org.lovetropics.tutorials.widget.BlockHighlightWidget;
import org.lovetropics.tutorials.widget.ImageDisplayWidget;
import org.lovetropics.tutorials.widget.TextDisplayWidget;
import org.lovetropics.tutorials.widget.TutorialWidget;
import org.lovetropics.tutorials.widget.TutorialWidgetType;
import org.lovetropics.tutorials.widget.focus.FocusingTutorialWidget;

@EventBusSubscriber(modid="lttutorials", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public final class TutorialWidgetRenderers {
    private static final Map<TutorialWidgetType<?>, TutorialWidgetRenderer<?>> REGISTRY = new Reference2ObjectOpenHashMap();

    @SubscribeEvent
    public static void register(FMLClientSetupEvent event) {
        TutorialWidgetRenderers.register(BlockHighlightWidget.TYPE, new BlockHighlightRenderer());
        TutorialWidgetRenderers.register(TextDisplayWidget.TYPE, new TextDisplayRenderer());
        TutorialWidgetRenderers.register(ImageDisplayWidget.TYPE, new ImageDisplayRenderer());
        TutorialWidgetRenderers.register(FocusingTutorialWidget.TYPE, new FocusingWidgetRenderer());
    }

    public static <T extends TutorialWidget> void register(TutorialWidgetType<T> type, TutorialWidgetRenderer<T> renderer) {
        REGISTRY.put(type, renderer);
    }

    @Nullable
    public static <T extends TutorialWidget> TutorialWidgetRenderer<T> rendererFor(TutorialWidgetType<T> type) {
        return REGISTRY.get(type);
    }

    @Nullable
    public static <T extends TutorialWidget> TutorialWidgetRenderer<T> rendererFor(TutorialWidget widget) {
        return TutorialWidgetRenderers.rendererFor(widget.getType());
    }
}

