/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.tutorials.widget.focus;

import com.lovetropics.lib.codec.MoreCodecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.entity.Entity;
import org.lovetropics.tutorials.widget.TutorialWidget;
import org.lovetropics.tutorials.widget.TutorialWidgetType;
import org.lovetropics.tutorials.widget.focus.WidgetFocus;

public final class FocusingTutorialWidget
implements TutorialWidget {
    public static final MapCodec<FocusingTutorialWidget> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MoreCodecs.arrayOrUnit(TutorialWidget.CODEC, TutorialWidget[]::new).fieldOf("widget").forGetter(c -> c.widgets), (App)WidgetFocus.CODEC.fieldOf("focus").forGetter(c -> c.focus)).apply((Applicative)instance, FocusingTutorialWidget::new));
    public static TutorialWidgetType<FocusingTutorialWidget> TYPE = TutorialWidgetType.register("focusing", CODEC);
    private static final int FOCUS_TICKS = 10;
    private final TutorialWidget[] widgets;
    private final WidgetFocus focus;
    private int focusTicks;

    public FocusingTutorialWidget(TutorialWidget[] widgets, WidgetFocus focus) {
        this.widgets = widgets;
        this.focus = focus;
    }

    public void tick(Entity camera) {
        boolean focused = this.focus.test(camera);
        if (focused) {
            if (this.focusTicks < 10) {
                ++this.focusTicks;
            }
        } else if (this.focusTicks > 0) {
            --this.focusTicks;
        }
    }

    public TutorialWidget[] getInnerWidgets() {
        return this.widgets;
    }

    public WidgetFocus getFocus() {
        return this.focus;
    }

    public float getFocusAnimation() {
        return (float)this.focusTicks / 10.0f;
    }

    @Override
    public TutorialWidgetType<?> getType() {
        return TYPE;
    }
}

