/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.tutorials.widget.focus;

import com.lovetropics.lib.BlockBox;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public final class WidgetFocus {
    public static final Codec<WidgetFocus> CODEC = RecordCodecBuilder.create(i -> i.group((App)BlockBox.CODEC.fieldOf("looking_at").forGetter(c -> c.lookingAt), (App)Codec.FLOAT.optionalFieldOf("distance", (Object)Float.valueOf(10.0f)).forGetter(c -> Float.valueOf(c.distance))).apply((Applicative)i, WidgetFocus::new));
    private final BlockBox lookingAt;
    private final AABB lookingAtAabb;
    private final float distance;

    public WidgetFocus(BlockBox lookingAt, float distance) {
        this.lookingAt = lookingAt;
        this.lookingAtAabb = lookingAt.asAabb();
        this.distance = distance;
    }

    public boolean test(Entity camera) {
        Vec3 eyes = camera.getEyePosition(1.0f);
        Vec3 view = camera.getViewVector(1.0f);
        Vec3 lookingAt = eyes.add(view.scale((double)this.distance));
        return this.lookingAtAabb.clip(eyes, lookingAt).isPresent();
    }
}

