/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.dummyplayers.client.renderer.dummy;

import com.mojang.blaze3d.vertex.PoseStack;
import com.tterrag.dummyplayers.DummyPlayers;
import com.tterrag.dummyplayers.client.renderer.dummy.DummyPlayerModel;
import com.tterrag.dummyplayers.entity.DummyPlayerEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ArmorStandRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;

public class DummyStandLayer
extends RenderLayer<DummyPlayerEntity, DummyPlayerModel> {
    public static final ModelLayerLocation LAYER = new ModelLayerLocation(DummyPlayers.DUMMY_PLAYER.getId(), "stand");
    private final HierarchicalModel<DummyPlayerEntity> standModel = new HierarchicalModel<DummyPlayerEntity>(RenderType::entitySolid){

        public void setupAnim(DummyPlayerEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        }

        public ModelPart root() {
            return DummyStandLayer.this.standBase;
        }
    };
    private final ModelPart standBase;

    public DummyStandLayer(RenderLayerParent<DummyPlayerEntity, DummyPlayerModel> entityRendererIn, EntityModelSet context) {
        super(entityRendererIn);
        this.standBase = context.bakeLayer(LAYER);
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("base_plate", CubeListBuilder.create().texOffs(0, 32).addBox(-6.0f, 11.0f, -6.0f, 12.0f, 1.0f, 12.0f), PartPose.offset((float)0.0f, (float)12.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, DummyPlayerEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.isNoBasePlate()) {
            return;
        }
        this.standBase.yRot = (float)Math.PI / 180 * -Mth.rotLerp((float)partialTicks, (float)entity.yRotO, (float)entity.getYRot());
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0625f, 0.0f);
        this.standModel.renderToBuffer(poseStack, bufferSource.getBuffer(this.standModel.renderType(ArmorStandRenderer.DEFAULT_SKIN_LOCATION)), packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }
}

