/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.dummyplayers.item;

import com.tterrag.dummyplayers.DummyPlayers;
import com.tterrag.dummyplayers.entity.DummyPlayerEntity;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Rotations;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class DummyPlayerItem
extends Item {
    public DummyPlayerItem(Item.Properties builder) {
        super(builder);
    }

    public InteractionResult useOn(UseOnContext context) {
        if (context.getClickedFace() == Direction.DOWN) {
            return InteractionResult.FAIL;
        }
        Level level = context.getLevel();
        BlockPos blockPos = new BlockPlaceContext(context).getClickedPos();
        Vec3 placePos = Vec3.atBottomCenterOf((Vec3i)blockPos);
        AABB aabb = ((EntityType)DummyPlayers.DUMMY_PLAYER.get()).getDimensions().makeBoundingBox(placePos.x(), placePos.y(), placePos.z());
        if (!level.noCollision(null, aabb) || !level.getEntities(null, aabb).isEmpty()) {
            return InteractionResult.FAIL;
        }
        ItemStack itemStack = context.getItemInHand();
        if (level instanceof ServerLevel) {
            DummyPlayerEntity dummy2;
            ServerLevel serverLevel = (ServerLevel)level;
            Consumer<DummyPlayerEntity> consumer = EntityType.createDefaultStackConfig((ServerLevel)serverLevel, (ItemStack)itemStack, (Player)context.getPlayer());
            ResolvableProfile profile = (ResolvableProfile)itemStack.get(DataComponents.PROFILE);
            if (profile != null) {
                consumer = consumer.andThen(dummy -> dummy.setAndFillProfile(profile));
            }
            if ((dummy2 = (DummyPlayerEntity)((EntityType)DummyPlayers.DUMMY_PLAYER.get()).create(serverLevel, consumer, blockPos, MobSpawnType.SPAWN_EGG, true, true)) == null) {
                return InteractionResult.FAIL;
            }
            float angle = (float)Mth.floor((float)((Mth.wrapDegrees((float)(context.getRotation() - 180.0f)) + 22.5f) / 45.0f)) * 45.0f;
            dummy2.moveTo(dummy2.getX(), dummy2.getY(), dummy2.getZ(), angle, 0.0f);
            this.applyRandomRotations(dummy2, level.random);
            serverLevel.addFreshEntityWithPassengers((Entity)dummy2);
            level.playSound(null, dummy2.getX(), dummy2.getY(), dummy2.getZ(), SoundEvents.ARMOR_STAND_PLACE, SoundSource.BLOCKS, 0.75f, 0.8f);
        }
        itemStack.consume(1, (LivingEntity)context.getPlayer());
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    private void applyRandomRotations(ArmorStand armorStand, RandomSource rand) {
        Rotations rotations = armorStand.getHeadPose();
        float f = rand.nextFloat() * 5.0f;
        float f1 = rand.nextFloat() * 20.0f - 10.0f;
        Rotations rotations1 = new Rotations(rotations.getX() + f, rotations.getY() + f1, rotations.getZ());
        armorStand.setHeadPose(rotations1);
        rotations = armorStand.getBodyPose();
        f = rand.nextFloat() * 10.0f - 5.0f;
        rotations1 = new Rotations(rotations.getX(), rotations.getY() + f, rotations.getZ());
        armorStand.setBodyPose(rotations1);
    }
}

