/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client;

import java.util.function.Supplier;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.tropicraft.core.client.tileentity.SimpleItemStackRenderer;
import net.tropicraft.core.common.block.AirCompressorBlock;
import net.tropicraft.core.common.block.BambooChestBlock;
import net.tropicraft.core.common.block.DrinkMixerBlock;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.block.tileentity.AirCompressorBlockEntity;
import net.tropicraft.core.common.block.tileentity.BambooChestBlockEntity;
import net.tropicraft.core.common.block.tileentity.DrinkMixerBlockEntity;

public final class TropicraftItemRenderers {
    public static IClientItemExtensions bambooChest() {
        return TropicraftItemRenderers.renderItemAsBlockEntity(() -> new BambooChestBlockEntity((BlockEntityType<BambooChestBlockEntity>)((BlockEntityType)TropicraftBlocks.BAMBOO_CHEST_ENTITY.get()), BlockPos.ZERO, ((BambooChestBlock)((Object)((Object)TropicraftBlocks.BAMBOO_CHEST.get()))).defaultBlockState()));
    }

    public static IClientItemExtensions drinkMixer() {
        return TropicraftItemRenderers.renderItemAsBlockEntity(() -> new DrinkMixerBlockEntity((BlockEntityType<DrinkMixerBlockEntity>)((BlockEntityType)TropicraftBlocks.DRINK_MIXER_ENTITY.get()), BlockPos.ZERO, ((DrinkMixerBlock)((Object)((Object)TropicraftBlocks.DRINK_MIXER.get()))).defaultBlockState()));
    }

    public static IClientItemExtensions airCompressor() {
        return TropicraftItemRenderers.renderItemAsBlockEntity(() -> new AirCompressorBlockEntity((BlockEntityType<AirCompressorBlockEntity>)((BlockEntityType)TropicraftBlocks.AIR_COMPRESSOR_ENTITY.get()), BlockPos.ZERO, ((AirCompressorBlock)((Object)((Object)TropicraftBlocks.AIR_COMPRESSOR.get()))).defaultBlockState()));
    }

    public static IClientItemExtensions renderItemAsBlockEntity(final Supplier<BlockEntity> blockEntityFactory) {
        return new IClientItemExtensions(){

            @OnlyIn(value=Dist.CLIENT)
            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return new SimpleItemStackRenderer(blockEntityFactory);
            }
        };
    }
}

