/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.tropicraft.core.common.entity.hostile.AshenEntity;

public class AshenModel
extends HierarchicalModel<AshenEntity>
implements ArmedModel {
    private final ModelPart root;
    public final ModelPart rightLeg;
    public final ModelPart leftLeg;
    public final ModelPart body;
    public final ModelPart head;
    public final ModelPart rightArm;
    public final ModelPart leftArm;
    public final ModelPart rightArmSub;
    public final ModelPart leftArmSub;
    public boolean swinging;

    public AshenModel(ModelPart root) {
        this.root = root;
        this.rightLeg = root.getChild("right_leg");
        this.leftLeg = root.getChild("left_leg");
        this.body = root.getChild("body");
        this.head = root.getChild("head");
        this.rightArm = root.getChild("right_arm");
        this.leftArm = root.getChild("left_arm");
        this.rightArmSub = this.rightArm.getChild("right_arm_sub");
        this.leftArmSub = this.leftArm.getChild("left_arm_sub");
    }

    public static LayerDefinition create() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(25, 0).mirror().addBox(0.0f, 0.0f, 0.0f, 1.0f, 7.0f, 1.0f), PartPose.offsetAndRotation((float)1.0f, (float)17.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(25, 0).mirror().addBox(-1.0f, 0.0f, 0.0f, 1.0f, 7.0f, 1.0f), PartPose.offsetAndRotation((float)-1.0f, (float)17.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(24, 8).mirror().addBox(-2.0f, -3.0f, 0.0f, 4.0f, 7.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)13.0f, (float)2.0f, (float)0.0f, (float)((float)Math.PI), (float)0.0f));
        root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(24, 18).mirror().addBox(-2.0f, -3.0f, -1.0f, 4.0f, 3.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)10.0f, (float)1.0f, (float)0.0f, (float)((float)Math.PI), (float)0.0f));
        PartDefinition rightArm = root.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(0, 24).mirror().addBox(-6.0f, -0.5f, -0.5f, 6.0f, 1.0f, 1.0f), PartPose.offsetAndRotation((float)-2.0f, (float)10.5f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        rightArm.addOrReplaceChild("right_arm_sub", CubeListBuilder.create().texOffs(31, 0).mirror().addBox(-0.5f, -6.0f, -0.5f, 1.0f, 6.0f, 1.0f), PartPose.offsetAndRotation((float)-5.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm = root.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(0, 24).mirror().addBox(0.0f, -0.5f, -0.5f, 6.0f, 1.0f, 1.0f), PartPose.offsetAndRotation((float)2.0f, (float)10.46667f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        leftArm.addOrReplaceChild("left_arm_sub", CubeListBuilder.create().mirror(true).texOffs(31, 0).addBox(-0.5f, -6.0f, -0.5f, 1.0f, 6.0f, 1.0f), PartPose.offsetAndRotation((float)5.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32);
    }

    public void setupAnim(AshenEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float headAngle;
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.25f * limbSwingAmount;
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.25f * limbSwingAmount;
        float armRotater = 1.2472123f;
        float subStraight = 1.5707964f;
        switch (entity.getActionState()) {
            case LOST_MASK: {
                headAngle = -0.4f;
                this.rightArm.zRot = -1.2472123f;
                this.rightArmSub.zRot = -5.1f;
                this.leftArm.zRot = 1.2472123f;
                this.leftArmSub.zRot = 5.1f;
                this.leftArm.xRot = 1.5707964f;
                this.rightArm.xRot = 1.5707964f;
                this.rightArm.yRot = -0.5f;
                this.leftArm.yRot = 0.5f;
                break;
            }
            case HOSTILE: {
                headAngle = 0.0f;
                this.leftArm.xRot = 1.65f + limbSwing / 125.0f;
                this.leftArm.yRot = 0.9f + limbSwingAmount / 125.0f;
                this.leftArm.zRot = 1.2472123f;
                this.leftArmSub.zRot = 6.2f;
                this.rightArm.zRot = 0.0f - Mth.sin((float)(limbSwingAmount * 0.75f)) * 0.022f;
                this.rightArm.yRot = 0.0f;
                this.rightArmSub.zRot = 0.0f;
                if (this.swinging) {
                    this.rightArm.xRot += Mth.sin((float)(limbSwingAmount * 0.75f)) * 0.052f;
                    break;
                }
                this.rightArm.xRot = 0.0f;
                break;
            }
            default: {
                headAngle = 0.0f;
                this.rightArm.zRot = -1.2472123f;
                this.rightArmSub.zRot = -1.5707964f;
                this.leftArm.zRot = 1.2472123f;
                this.leftArmSub.zRot = 1.5707964f;
                this.rightArm.yRot = 0.0f;
                this.leftArm.yRot = 0.0f;
            }
        }
        this.head.xRot = headPitch / 125.0f + headAngle;
        this.head.yRot = netHeadYaw / 125.0f + (float)Math.PI;
        this.leftArm.zRot += Mth.sin((float)(ageInTicks * 0.25f)) * 0.02f;
        this.rightArm.zRot -= Mth.sin((float)(ageInTicks * 0.25f)) * 0.02f;
    }

    public ModelPart root() {
        return this.root;
    }

    public void translateToHand(HumanoidArm side, PoseStack stack) {
        stack.translate(0.09375f, 0.1875f, 0.0f);
    }
}

