/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.model;

import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.tropicraft.core.common.entity.egg.EggEntity;

public class EggModel
extends HierarchicalModel<EggEntity> {
    private final ModelPart root;
    private final ModelPart body;

    public EggModel(ModelPart root) {
        this.root = root;
        this.body = root.getChild("body");
    }

    public static LayerDefinition create() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("body", CubeListBuilder.create().mirror(true).texOffs(0, 16).addBox(-3.0f, -10.0f, -3.0f, 6.0f, 10.0f, 6.0f).texOffs(0, 0).addBox(-1.5f, -11.0f, -1.5f, 3.0f, 1.0f, 3.0f).texOffs(0, 7).addBox(3.0f, -7.0f, -1.5f, 1.0f, 6.0f, 3.0f).texOffs(24, 9).addBox(-1.5f, -7.0f, 3.0f, 3.0f, 6.0f, 1.0f).texOffs(16, 7).addBox(-4.0f, -7.0f, -1.5f, 1.0f, 6.0f, 3.0f).texOffs(8, 9).addBox(-1.5f, -7.0f, -4.0f, 3.0f, 6.0f, 1.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32);
    }

    public void setupAnim(EggEntity egg, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean hatching = egg.isNearHatching();
        float randRotator = (float)egg.rotationRand;
        this.body.yRot = 0.0f;
        if (hatching) {
            this.body.yRot = Mth.sin((float)(ageInTicks * 0.6f)) * 0.6f;
            this.body.xRot = Mth.sin((float)(randRotator * 4.0f)) * 0.6f;
            this.body.zRot = Mth.cos((float)(randRotator * 4.0f)) * 0.6f;
        } else {
            this.body.xRot = 0.0f;
            this.body.zRot = 0.0f;
        }
    }

    public ModelPart root() {
        return this.root;
    }
}

