/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.model;

import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.tropicraft.core.client.entity.model.ModelAnimator;
import net.tropicraft.core.common.entity.neutral.IguanaEntity;

public class IguanaModel
extends HierarchicalModel<IguanaEntity> {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart headTop1;
    private final ModelPart headTop2;
    private final ModelPart frontLeftLeg;
    private final ModelPart rearLeftLeg;
    private final ModelPart frontRightLeg;
    private final ModelPart rearRightLeg;
    private final ModelPart jaw;
    private final ModelPart dewLap;
    private final ModelPart tailBase;
    private final ModelPart tailMid;
    private final ModelPart miscPart;

    public IguanaModel(ModelPart root) {
        this.root = root;
        this.head = root.getChild("head");
        this.headTop1 = root.getChild("headTop1");
        this.headTop2 = root.getChild("headTop2");
        this.frontLeftLeg = root.getChild("frontLeftLeg");
        this.rearLeftLeg = root.getChild("rearLeftLeg");
        this.frontRightLeg = root.getChild("frontRightLeg");
        this.rearRightLeg = root.getChild("rearRightLeg");
        this.jaw = root.getChild("jaw");
        this.dewLap = root.getChild("dewLap");
        this.tailBase = root.getChild("tailBase");
        this.tailMid = root.getChild("tailMid");
        this.miscPart = root.getChild("miscPart");
    }

    public static LayerDefinition create() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(36, 23).addBox(-2.5f, -2.0f, -6.0f, 5.0f, 3.0f, 6.0f), PartPose.offset((float)0.0f, (float)20.0f, (float)-6.0f));
        root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 16).addBox(-2.5f, -1.5f, -7.5f, 5.0f, 3.0f, 13.0f), PartPose.offset((float)0.0f, (float)21.5f, (float)1.0f));
        root.addOrReplaceChild("frontLeftLeg", CubeListBuilder.create().texOffs(24, 21).addBox(0.0f, 0.0f, -1.5f, 2.0f, 3.0f, 3.0f), PartPose.offset((float)2.5f, (float)21.0f, (float)-4.0f));
        root.addOrReplaceChild("rearLeftLeg", CubeListBuilder.create().texOffs(24, 21).addBox(0.0f, 0.0f, -1.5f, 2.0f, 3.0f, 3.0f), PartPose.offset((float)2.5f, (float)21.0f, (float)4.0f));
        root.addOrReplaceChild("frontRightLeg", CubeListBuilder.create().texOffs(0, 21).addBox(-2.0f, 0.0f, -1.5f, 2.0f, 3.0f, 3.0f), PartPose.offset((float)-2.5f, (float)21.0f, (float)-4.0f));
        root.addOrReplaceChild("rearRightLeg", CubeListBuilder.create().texOffs(0, 21).addBox(-2.0f, 0.0f, -1.5f, 2.0f, 3.0f, 3.0f), PartPose.offset((float)-2.5f, (float)21.0f, (float)4.0f));
        root.addOrReplaceChild("back1", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, -1.0f, 0.0f, 3.0f, 1.0f, 10.0f), PartPose.offset((float)0.0f, (float)20.0f, (float)-5.0f));
        root.addOrReplaceChild("back2", CubeListBuilder.create().texOffs(32, 0).addBox(-0.5f, -1.0f, -3.0f, 1.0f, 1.0f, 6.0f), PartPose.offset((float)0.0f, (float)19.0f, (float)0.0f));
        root.addOrReplaceChild("headTop2", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, -4.0f, -4.0f, 1.0f, 1.0f, 2.0f), PartPose.offset((float)0.0f, (float)20.0f, (float)-6.0f));
        root.addOrReplaceChild("headTop1", CubeListBuilder.create().texOffs(32, 7).addBox(-0.5f, -3.0f, -5.0f, 1.0f, 1.0f, 4.0f), PartPose.offset((float)0.0f, (float)20.0f, (float)-6.0f));
        root.addOrReplaceChild("jaw", CubeListBuilder.create().texOffs(0, 11).addBox(-1.0f, 1.0f, -4.0f, 2.0f, 1.0f, 4.0f), PartPose.offset((float)0.0f, (float)20.0f, (float)-6.0f));
        root.addOrReplaceChild("back3", CubeListBuilder.create().texOffs(32, 7).addBox(-0.5f, 0.0f, -2.0f, 1.0f, 1.0f, 4.0f), PartPose.offset((float)0.0f, (float)17.0f, (float)0.0f));
        root.addOrReplaceChild("dewLap", CubeListBuilder.create().texOffs(0, 4).addBox(-0.5f, 2.0f, -3.0f, 1.0f, 1.0f, 3.0f), PartPose.offset((float)0.0f, (float)20.0f, (float)-6.0f));
        root.addOrReplaceChild("tailBase", CubeListBuilder.create().texOffs(46, 0).addBox(-1.5f, -0.5f, 0.0f, 3.0f, 1.0f, 6.0f), PartPose.offset((float)0.0f, (float)21.5f, (float)6.0f));
        root.addOrReplaceChild("tailMid", CubeListBuilder.create().texOffs(48, 7).addBox(-1.0f, -0.5f, 0.0f, 2.0f, 1.0f, 6.0f), PartPose.ZERO);
        root.addOrReplaceChild("miscPart", CubeListBuilder.create().texOffs(52, 14).addBox(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 5.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32);
    }

    public void setupAnim(IguanaEntity iguana, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.frontRightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.75f * limbSwingAmount;
        this.frontLeftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.75f * limbSwingAmount;
        this.rearRightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.75f * limbSwingAmount;
        this.rearLeftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.75f * limbSwingAmount;
        this.tailBase.yRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.25f * limbSwingAmount;
        this.tailMid.setPos(0.0f - Mth.cos((float)(this.tailBase.yRot + 1.5707964f)) * 6.0f, 21.5f, 12.0f + Mth.sin((float)(this.tailBase.xRot + (float)Math.PI)) * 6.0f);
        this.tailMid.yRot = this.tailBase.yRot + Mth.cos((float)(limbSwing * 0.6662f)) * 0.5f * limbSwingAmount;
        this.miscPart.setPos(0.0f - Mth.cos((float)(this.tailMid.yRot + 1.5707964f)) * 6.0f, 21.5f, 18.0f + Mth.sin((float)(this.tailMid.xRot + (float)Math.PI)) * 6.0f);
        this.miscPart.yRot = this.tailMid.yRot + Mth.cos((float)(limbSwing * 0.6662f)) * 0.75f * limbSwingAmount;
        ModelAnimator.look(this.head, netHeadYaw, headPitch);
        ModelAnimator.look(this.jaw, netHeadYaw, headPitch);
        ModelAnimator.look(this.headTop1, netHeadYaw, headPitch);
        ModelAnimator.look(this.headTop2, netHeadYaw, headPitch);
        ModelAnimator.look(this.dewLap, netHeadYaw, headPitch);
        try (ModelAnimator.Cycle idle = ModelAnimator.cycle(ageInTicks * 0.025f, 0.1f);){
            this.tailBase.yRot += idle.eval(1.0f, 1.0f, 0.0f, 0.0f);
            this.tailMid.setPos(0.0f - Mth.cos((float)(this.tailBase.yRot + 1.5707964f)) * 6.0f, 21.5f, 12.0f + Mth.sin((float)(this.tailBase.xRot + 3.14159f)) * 6.0f);
            this.tailMid.yRot += idle.eval(1.0f, 1.0f, 0.05f, 0.0f);
            this.miscPart.setPos(0.0f - Mth.cos((float)(this.tailMid.yRot + 1.5707964f)) * 6.0f, 21.5f, 18.0f + Mth.sin((float)(this.tailMid.xRot + 3.14159f)) * 6.0f);
            this.miscPart.yRot += idle.eval(1.0f, 1.0f, 0.075f, 0.0f);
        }
    }

    public ModelPart root() {
        return this.root;
    }
}

