/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.model;

import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.tropicraft.core.common.entity.underdasea.MarlinEntity;

public class MarlinModel
extends HierarchicalModel<MarlinEntity> {
    private final ModelPart root;
    private final ModelPart leftFin;
    private final ModelPart rightFin;
    private final ModelPart head;
    private final ModelPart tail1;
    private final ModelPart tail3;

    public MarlinModel(ModelPart root) {
        this.root = root;
        this.head = root.getChild("head");
        this.tail1 = root.getChild("tail1");
        ModelPart tail2 = this.tail1.getChild("tail2");
        this.tail3 = tail2.getChild("tail3");
        this.leftFin = root.getChild("leftFin");
        this.rightFin = root.getChild("rightFin");
    }

    public static LayerDefinition create() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 22).mirror().addBox(-5.0f, -3.0f, -2.0f, 7.0f, 6.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)19.0f, (float)0.0f, (float)0.0f, (float)-1.5707964f, (float)0.0f));
        root.addOrReplaceChild("dorsalFin1", CubeListBuilder.create().texOffs(24, 20).mirror().addBox(-0.5f, -0.5f, -0.5f, 1.0f, 2.0f, 10.0f), PartPose.offset((float)0.0f, (float)15.5f, (float)-5.0f));
        root.addOrReplaceChild("leftFin", CubeListBuilder.create().texOffs(12, 10).mirror().addBox(0.0f, -0.5f, -2.0f, 4.0f, 1.0f, 2.0f), PartPose.offset((float)2.0f, (float)21.0f, (float)-3.0f));
        root.addOrReplaceChild("rightFin", CubeListBuilder.create().texOffs(12, 7).mirror().addBox(-4.0f, -0.5f, -2.0f, 4.0f, 1.0f, 2.0f), PartPose.offset((float)-2.0f, (float)21.0f, (float)-3.0f));
        root.addOrReplaceChild("bottomFin", CubeListBuilder.create().texOffs(52, 0).mirror().addBox(-0.5f, 2.0f, -2.5f, 1.0f, 3.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)19.0f, (float)0.0f, (float)0.6981317f, (float)0.0f, (float)0.0f));
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().mirror().texOffs(46, 24).addBox(-1.5f, -3.0f, -3.0f, 3.0f, 5.0f, 3.0f).texOffs(28, 0).addBox(-1.0f, -1.5f, -4.0f, 2.0f, 3.0f, 1.0f).texOffs(22, 0).addBox(-0.5f, -0.5f, -6.0f, 1.0f, 2.0f, 2.0f).texOffs(23, 24).addBox(-0.5f, -6.0f, -2.5f, 1.0f, 3.0f, 2.0f), PartPose.offset((float)0.0f, (float)20.0f, (float)-5.0f));
        head.addOrReplaceChild("sword", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(4.0f, -1.5f, -0.5f, 10.0f, 1.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5707f, (float)0.0f));
        PartDefinition tail1 = root.addOrReplaceChild("tail1", CubeListBuilder.create().texOffs(0, 13).mirror().addBox(-1.5f, -2.0f, 0.0f, 3.0f, 5.0f, 4.0f), PartPose.offset((float)0.0f, (float)19.0f, (float)2.0f));
        PartDefinition tail2 = tail1.addOrReplaceChild("tail2", CubeListBuilder.create().texOffs(0, 5).mirror().addBox(-1.0f, -1.5f, 0.0f, 2.0f, 4.0f, 4.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)4.0f));
        PartDefinition tail3 = tail2.addOrReplaceChild("tail3", CubeListBuilder.create().texOffs(46, 0).mirror().addBox(-0.5f, -1.5f, 0.0f, 1.0f, 3.0f, 2.0f), PartPose.offset((float)0.0f, (float)1.0f, (float)4.0f));
        tail3.addOrReplaceChild("tailEndB", CubeListBuilder.create().texOffs(40, 0).mirror().addBox(-0.5f, 1.0f, -1.0f, 1.0f, 5.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.593411f, (float)0.0f, (float)0.0f));
        tail3.addOrReplaceChild("tailEndT", CubeListBuilder.create().texOffs(34, 0).mirror().addBox(-0.5f, 1.0f, -1.0f, 1.0f, 5.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)2.548179f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32);
    }

    public void setupAnim(MarlinEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float yAngleRot = Mth.sin((float)(ageInTicks * 0.25f));
        float zWaveFloat = yAngleRot * 0.165f;
        if (!entity.isInWater()) {
            float yWaveRot;
            this.head.yRot = yWaveRot = Mth.sin((float)(ageInTicks * 0.55f)) * 0.26f;
            this.tail1.yRot = yWaveRot;
            this.tail3.yRot = yWaveRot;
            this.leftFin.zRot = zWaveFloat + 0.523598f;
            this.rightFin.zRot = -yAngleRot * 0.165f - 0.523598f;
            this.leftFin.yRot = -1.5f;
            this.rightFin.yRot = 1.5f - zWaveFloat - 0.523598f;
        } else {
            this.head.yRot = yAngleRot * 0.135f;
            this.tail1.yRot = Mth.sin((float)(ageInTicks * 0.35f)) * 0.15f;
            this.tail3.yRot = Mth.sin((float)(ageInTicks * 0.45f)) * 0.16f;
            this.leftFin.zRot = zWaveFloat + 0.523598f;
            this.rightFin.zRot = -yAngleRot * 0.165f - 0.523598f;
            this.leftFin.yRot = -0.392699f;
            this.rightFin.yRot = 0.392699f;
        }
    }

    public ModelPart root() {
        return this.root;
    }
}

