/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.LivingEntity;
import net.tropicraft.core.client.entity.TropicraftSpecialRenderHelper;

public class PlayerHeadpieceModel
extends HumanoidModel<LivingEntity> {
    private final int textureIndex;
    private final double xOffset;
    private final double yOffset;
    private final TropicraftSpecialRenderHelper renderer;

    public PlayerHeadpieceModel(ModelPart modelPart, int textureIndex, double xOffset, double yOffset) {
        super(modelPart, RenderType::entityCutoutNoCull);
        this.textureIndex = textureIndex;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.renderer = new TropicraftSpecialRenderHelper();
    }

    public static LayerDefinition create() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.ZERO);
        root.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.ZERO);
        root.addOrReplaceChild("right_arm", CubeListBuilder.create(), PartPose.ZERO);
        root.addOrReplaceChild("left_arm", CubeListBuilder.create(), PartPose.ZERO);
        root.addOrReplaceChild("right_leg", CubeListBuilder.create(), PartPose.ZERO);
        root.addOrReplaceChild("left_leg", CubeListBuilder.create(), PartPose.ZERO);
        CubeDeformation dilation_hat = new CubeDeformation(0.5f);
        root.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, dilation_hat), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32);
    }

    public static PlayerHeadpieceModel createModel(ModelLayerLocation entityModelLayer, @Nullable EntityModelSet entityModelLoader, int textureIndex, double xOffset, double yOffset) {
        return new PlayerHeadpieceModel(entityModelLoader == null ? PlayerHeadpieceModel.create().bakeRoot() : entityModelLoader.bakeLayer(entityModelLayer), textureIndex, xOffset, yOffset);
    }

    public void renderToBuffer(PoseStack stack, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, int color) {
        stack.pushPose();
        this.head.translateAndRotate(stack);
        stack.mulPose(Axis.YP.rotationDegrees(180.0f));
        stack.translate(0.0 - this.xOffset, (double)0.1745f - this.yOffset, (double)0.2501f);
        this.renderer.renderMask(stack, bufferIn, this.textureIndex, packedLightIn, packedOverlayIn);
        stack.popPose();
    }
}

