/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.tropicraft.core.common.entity.underdasea.SeaUrchinEntity;

public class SeaUrchinModel
extends ListModel<SeaUrchinEntity> {
    private static final int VERTICAL_SPINES = 12;
    private static final int HORIZONTAL_SPINES = 12;
    private final ModelPart base;
    private final ModelPart top1;
    private final ModelPart top2;
    private final ModelPart front1;
    private final ModelPart front2;
    private final ModelPart left1;
    private final ModelPart left2;
    private final ModelPart back1;
    private final ModelPart back2;
    private final ModelPart right1;
    private final ModelPart right2;
    private final ModelPart bottom1;
    private final ModelPart bottom2;
    private final ModelPart spine;

    public SeaUrchinModel(ModelPart root) {
        this.base = root.getChild("base");
        this.top1 = root.getChild("top1");
        this.top2 = root.getChild("top2");
        this.front1 = root.getChild("front1");
        this.front2 = root.getChild("front2");
        this.left1 = root.getChild("left1");
        this.left2 = root.getChild("left2");
        this.back1 = root.getChild("back1");
        this.back2 = root.getChild("back2");
        this.right1 = root.getChild("right1");
        this.right2 = root.getChild("right2");
        this.bottom1 = root.getChild("bottom1");
        this.bottom2 = root.getChild("bottom2");
        this.spine = root.getChild("spine");
    }

    public static LayerDefinition create() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("base", CubeListBuilder.create().mirror().texOffs(0, 0).addBox(-3.0f, 16.0f, -3.0f, 6.0f, 6.0f, 6.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("top1", CubeListBuilder.create().mirror().texOffs(0, 38).addBox(-2.0f, 15.0f, -2.0f, 4.0f, 1.0f, 4.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("top2", CubeListBuilder.create().mirror().texOffs(16, 38).addBox(-1.0f, 14.0f, -1.0f, 2.0f, 1.0f, 2.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("front1", CubeListBuilder.create().mirror().texOffs(0, 12).addBox(-2.0f, 17.0f, -4.0f, 4.0f, 4.0f, 1.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("front2", CubeListBuilder.create().mirror().texOffs(10, 12).addBox(-1.0f, 18.0f, -5.0f, 2.0f, 2.0f, 1.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("left1", CubeListBuilder.create().mirror().texOffs(0, 17).addBox(3.0f, 17.0f, -2.0f, 1.0f, 4.0f, 4.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("left2", CubeListBuilder.create().mirror().texOffs(10, 17).addBox(4.0f, 18.0f, -1.0f, 1.0f, 2.0f, 2.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("back1", CubeListBuilder.create().mirror().texOffs(0, 25).addBox(-2.0f, 17.0f, 3.0f, 4.0f, 4.0f, 1.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("back2", CubeListBuilder.create().mirror().texOffs(10, 25).addBox(-1.0f, 18.0f, 4.0f, 2.0f, 2.0f, 1.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("right1", CubeListBuilder.create().mirror().texOffs(0, 30).addBox(-4.0f, 17.0f, -2.0f, 1.0f, 4.0f, 4.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("right2", CubeListBuilder.create().mirror().texOffs(10, 30).addBox(-5.0f, 18.0f, -1.0f, 1.0f, 2.0f, 2.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("bottom1", CubeListBuilder.create().mirror().texOffs(0, 38).addBox(-2.0f, 22.0f, -2.0f, 4.0f, 1.0f, 4.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("bottom2", CubeListBuilder.create().mirror().texOffs(16, 38).addBox(-1.0f, 23.0f, -1.0f, 2.0f, 1.0f, 2.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("spine", CubeListBuilder.create().mirror().texOffs(24, 0).addBox(-0.5f, -9.0f, -0.5f, 1.0f, 6.0f, 1.0f), PartPose.offset((float)0.0f, (float)19.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    public void setupAnim(SeaUrchinEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        super.renderToBuffer(poseStack, buffer, packedLight, packedOverlay, color);
        for (int v = 0; v < 12; ++v) {
            for (int h = 0; h < 12; ++h) {
                poseStack.pushPose();
                poseStack.translate(0.0f, 1.25f, 0.0f);
                poseStack.mulPose(Axis.ZP.rotationDegrees(360.0f * (float)v / 12.0f));
                poseStack.mulPose(Axis.XP.rotationDegrees(360.0f * (float)h / 12.0f));
                poseStack.translate(0.0f, -0.4f, 0.0f);
                poseStack.scale(0.33f, 1.0f, 0.33f);
                this.spine.render(poseStack, buffer, packedLight, packedOverlay, color);
                poseStack.popPose();
            }
        }
    }

    public Iterable<ModelPart> parts() {
        return List.of(this.base, this.top1, this.top2, this.front1, this.front2, this.left1, this.left2, this.back1, this.back2, this.right1, this.right2, this.bottom1, this.bottom2);
    }
}

