/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.model;

import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Mob;
import net.tropicraft.core.client.entity.model.ModelAnimator;
import net.tropicraft.core.client.entity.model.TwoJointSolver;
import net.tropicraft.core.common.entity.IkWalker;
import net.tropicraft.core.common.entity.passive.ShoebillStorkEntity;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class ShoebillStorkModel
extends HierarchicalModel<ShoebillStorkEntity> {
    private final ModelPart body;
    private final ModelPart wingLeft1a;
    private final ModelPart wingLeft1b;
    private final ModelPart wingLeft1c;
    private final ModelPart wingLeftTip;
    private final ModelPart buttocks;
    private final ModelPart tailTop;
    private final ModelPart tailBottom;
    private final ModelPart tailMidLeft;
    private final ModelPart tailMidRight;
    private final ModelPart neckBase;
    private final ModelPart neckTop;
    private final ModelPart head;
    private final ModelPart beakTop;
    private final ModelPart beakBottom;
    private final ModelPart fancyLad;
    private final ModelPart legLeft1a;
    private final ModelPart legLeft1b;
    private final ModelPart clawLeft;
    private final ModelPart legRight1a;
    private final ModelPart legRight1b;
    private final ModelPart clawRight;
    private final ModelPart wingRight1a;
    private final ModelPart wingRight1b;
    private final ModelPart wingRight1c;
    private final ModelPart wingRightTip;
    private final ModelPart[] neckChain;
    private final TwoJointSolver leftLegSolver;
    private final TwoJointSolver rightLegSolver;
    private final TwoJointSolver headSolver;

    public ShoebillStorkModel(ModelPart root) {
        this.body = root.getChild("body_main");
        this.wingLeft1a = this.body.getChild("wing_left1a");
        this.wingLeft1b = this.wingLeft1a.getChild("wing_left1b");
        this.wingLeft1c = this.wingLeft1b.getChild("wing_left1c");
        this.wingLeftTip = this.wingLeft1c.getChild("wing_left_tip");
        this.buttocks = this.body.getChild("bird_buttocks");
        this.tailTop = this.buttocks.getChild("tail_top");
        this.tailBottom = this.buttocks.getChild("tail_bottom");
        this.tailMidLeft = this.buttocks.getChild("tail_mid_left");
        this.tailMidRight = this.buttocks.getChild("tail_mid_right");
        this.neckBase = this.body.getChild("neck_base");
        this.neckTop = this.neckBase.getChild("neck_top");
        this.head = this.neckTop.getChild("head_main");
        this.beakTop = this.head.getChild("beak_top");
        this.beakBottom = this.head.getChild("beak_bottom");
        this.fancyLad = this.head.getChild("fancy_lad");
        this.legLeft1a = this.body.getChild("leg_left1a");
        this.legLeft1b = this.legLeft1a.getChild("leg_left1b");
        this.clawLeft = this.legLeft1b.getChild("claw_left");
        this.legRight1a = this.body.getChild("leg_right1a");
        this.legRight1b = this.legRight1a.getChild("leg_right1b");
        this.clawRight = this.legRight1b.getChild("claw_right");
        this.wingRight1a = this.body.getChild("wing_right1a");
        this.wingRight1b = this.wingRight1a.getChild("wing_right1b");
        this.wingRight1c = this.wingRight1b.getChild("wing_right1c");
        this.wingRightTip = this.wingRight1c.getChild("wing_right_tip");
        this.neckChain = new ModelPart[]{this.body, this.neckBase, this.neckTop};
        this.leftLegSolver = new TwoJointSolver(new ModelPart[]{this.body}, this.legLeft1a, this.legLeft1b, this.clawLeft);
        this.rightLegSolver = new TwoJointSolver(new ModelPart[]{this.body}, this.legRight1a, this.legRight1b, this.clawRight);
        this.headSolver = new TwoJointSolver(new ModelPart[]{this.body}, this.neckBase, this.neckTop, this.head);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition body = mesh.getRoot().addOrReplaceChild("body_main", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -4.0f, -8.0f, 5.0f, 4.0f, 10.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)12.9f, (float)1.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition wingLeft1a = body.addOrReplaceChild("wing_left1a", CubeListBuilder.create(), PartPose.offsetAndRotation((float)2.0f, (float)-2.4f, (float)-5.45f, (float)0.0f, (float)-0.48f, (float)0.0873f));
        wingLeft1a.addOrReplaceChild("wing_left1a_r1", CubeListBuilder.create().texOffs(0, 34).addBox(0.0f, -0.9f, -1.0f, 1.0f, 4.0f, 3.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-0.6f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition wingLeft1b = wingLeft1a.addOrReplaceChild("wing_left1b", CubeListBuilder.create(), PartPose.offsetAndRotation((float)1.0f, (float)-0.6f, (float)2.0f, (float)0.0f, (float)-2.5744f, (float)0.0f));
        wingLeft1b.addOrReplaceChild("wing_left1b_r1", CubeListBuilder.create().texOffs(8, 33).addBox(-1.0f, -0.9f, -1.0f, 1.0f, 4.0f, 4.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition wingLeft1c = wingLeft1b.addOrReplaceChild("wing_left1c", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)4.0f, (float)0.0f, (float)2.9671f, (float)0.0f));
        wingLeft1c.addOrReplaceChild("wing_left1c_r1", CubeListBuilder.create().texOffs(18, 29).addBox(0.0f, -0.9f, -1.0f, 1.0f, 4.0f, 8.0f, new CubeDeformation(0.02f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition wingLeftTip = wingLeft1c.addOrReplaceChild("wing_left_tip", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)1.0f, (float)8.0f));
        wingLeftTip.addOrReplaceChild("wing_left_tip_r1", CubeListBuilder.create().texOffs(36, 36).addBox(0.0f, -0.9f, -1.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.02f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition buttocks = body.addOrReplaceChild("bird_buttocks", CubeListBuilder.create().texOffs(30, 8).addBox(-2.0f, 0.0f, 0.0f, 4.0f, 3.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)2.0f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        buttocks.addOrReplaceChild("tail_top", CubeListBuilder.create().texOffs(12, 0).addBox(-2.0f, 0.0f, 0.0f, 4.0f, 0.0f, 8.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        buttocks.addOrReplaceChild("tail_bottom", CubeListBuilder.create().texOffs(30, 0).addBox(-2.0f, 0.0f, 0.0f, 4.0f, 0.0f, 6.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)1.5f, (float)2.0f, (float)0.6545f, (float)0.0f, (float)0.0f));
        buttocks.addOrReplaceChild("tail_mid_left", CubeListBuilder.create().texOffs(22, 0).addBox(-2.5f, 0.0f, 0.0f, 4.0f, 0.0f, 6.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)2.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        buttocks.addOrReplaceChild("tail_mid_right", CubeListBuilder.create().texOffs(22, 0).mirror().addBox(-1.5f, 0.0f, 0.0f, 4.0f, 0.0f, 6.0f, CubeDeformation.NONE).mirror(false), PartPose.offsetAndRotation((float)-0.5f, (float)0.05f, (float)2.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition neckBase = body.addOrReplaceChild("neck_base", CubeListBuilder.create().texOffs(0, 14).addBox(-1.5f, -3.0f, -4.0f, 3.0f, 3.0f, 4.0f, new CubeDeformation(0.005f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-8.0f, (float)-0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition neckTop = neckBase.addOrReplaceChild("neck_top", CubeListBuilder.create().texOffs(0, 21).addBox(-1.5f, -2.0f, -4.0f, 3.0f, 2.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-4.0f, (float)-0.829f, (float)0.0f, (float)0.0f));
        PartDefinition head = neckTop.addOrReplaceChild("head_main", CubeListBuilder.create().texOffs(14, 14).addBox(-2.0f, -1.0f, -1.8f, 4.0f, 4.0f, 3.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-0.5f, (float)-4.0f, (float)0.9163f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("beak_top", CubeListBuilder.create().texOffs(14, 21).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)-1.8f, (float)0.5672f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("beak_bottom", CubeListBuilder.create().texOffs(16, 29).addBox(-1.5f, -0.25f, 0.0f, 3.0f, 4.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)0.2f, (float)0.4363f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("fancy_lad", CubeListBuilder.create().texOffs(0, 4).addBox(-2.0f, -2.0f, 0.0f, 4.0f, 2.0f, 0.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)-1.8f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition legLeft1a = body.addOrReplaceChild("leg_left1a", CubeListBuilder.create().texOffs(52, 0).addBox(-0.5f, -1.0f, 0.0f, 1.0f, 5.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)1.5f, (float)0.0f, (float)-1.0f, (float)0.8727f, (float)-0.0436f, (float)-0.0873f));
        PartDefinition legLeft1b = legLeft1a.addOrReplaceChild("leg_left1b", CubeListBuilder.create().texOffs(53, 6).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 8.0f, 0.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)1.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        legLeft1b.addOrReplaceChild("claw_left", CubeListBuilder.create().texOffs(48, 14).addBox(-2.0f, 0.0f, -3.0f, 4.0f, 0.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)0.0f, (float)0.1745f, (float)-0.1745f, (float)0.0f));
        PartDefinition legRight1a = body.addOrReplaceChild("leg_right1a", CubeListBuilder.create().texOffs(44, 0).addBox(-0.5f, -1.0f, 0.0f, 1.0f, 5.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-1.5f, (float)0.0f, (float)-1.0f, (float)0.8727f, (float)0.0436f, (float)0.0873f));
        PartDefinition legRight1b = legRight1a.addOrReplaceChild("leg_right1b", CubeListBuilder.create().texOffs(45, 6).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 8.0f, 0.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)1.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        legRight1b.addOrReplaceChild("claw_right", CubeListBuilder.create().texOffs(40, 14).addBox(-2.0f, 0.0f, -3.0f, 4.0f, 0.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)0.0f, (float)0.1745f, (float)0.1745f, (float)0.0f));
        PartDefinition wingRight1a = body.addOrReplaceChild("wing_right1a", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-2.0f, (float)-2.4f, (float)-5.45f, (float)0.0f, (float)0.48f, (float)-0.0873f));
        wingRight1a.addOrReplaceChild("wing_right1a_r1", CubeListBuilder.create().texOffs(0, 46).addBox(-1.0f, -0.9f, -1.0f, 1.0f, 4.0f, 3.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-0.6f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition wingRight1b = wingRight1a.addOrReplaceChild("wing_right1b", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-1.0f, (float)-0.6f, (float)2.0f, (float)0.0f, (float)2.5744f, (float)0.0f));
        wingRight1b.addOrReplaceChild("wing_right1b_r1", CubeListBuilder.create().texOffs(8, 45).addBox(0.0f, -0.9f, -1.0f, 1.0f, 4.0f, 4.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition wingRight1c = wingRight1b.addOrReplaceChild("wing_right1c", CubeListBuilder.create(), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)4.0f, (float)0.0f, (float)-2.9671f, (float)0.0f));
        wingRight1c.addOrReplaceChild("wing_right1c_r1", CubeListBuilder.create().texOffs(18, 41).addBox(-1.0f, -0.9f, -1.0f, 1.0f, 4.0f, 8.0f, new CubeDeformation(0.02f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition wingRightTip = wingRight1c.addOrReplaceChild("wing_right_tip", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)1.0f, (float)8.0f));
        wingRightTip.addOrReplaceChild("wing_right_tip_r1", CubeListBuilder.create().texOffs(36, 48).addBox(-1.0f, -0.9f, -1.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.02f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    public ModelPart root() {
        return this.body;
    }

    public void setupAnim(ShoebillStorkEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        this.body.getAllParts().forEach(ModelPart::resetPose);
        float partialTicks = ageInTicks - (float)entity.tickCount;
        float flightAnimation = entity.getFlightAnimation(partialTicks);
        float groundAnimation = 1.0f - flightAnimation;
        float headRoll = 0.0f;
        if (groundAnimation > 0.0f) {
            try (ModelAnimator.Cycle idle = ModelAnimator.cycle(ageInTicks, 1.0f);){
                headRoll += idle.periodic(400.0f, 5.0f, 20.0f, 20.0f);
                headRoll += idle.periodic(500.0f, 5.0f, 20.0f, -20.0f);
                this.body.y += idle.eval(0.01f, 0.075f);
                float wingTwitch = idle.twitchAsymmetric(100.0f, 0.1f, 0.5f);
                this.wingLeft1a.yRot += wingTwitch;
                this.wingRight1a.yRot -= wingTwitch;
            }
            IkWalker.EntitySpace entitySpace = IkWalker.EntitySpace.from((Mob)entity, partialTicks);
            Vector3f leftFootPos = entity.leftFoot().solveModelPosition(entitySpace, partialTicks);
            Vector3f rightFootPos = entity.rightFoot().solveModelPosition(entitySpace, partialTicks);
            float footDeltaX = (leftFootPos.x + rightFootPos.x) / 2.0f;
            float footDeltaZ = (leftFootPos.z + rightFootPos.z) / 2.0f - 0.0152f;
            this.body.xRot += footDeltaZ * 0.6f * groundAnimation;
            this.body.zRot += footDeltaX * 0.6f * groundAnimation;
            this.leftLegSolver.apply(leftFootPos, groundAnimation);
            this.rightLegSolver.apply(rightFootPos, groundAnimation);
        }
        this.headSolver.applyRelativeToBase(0.35f, 0.0f, 0.0f, 0.0f);
        Quaternionf neckRotation = new Quaternionf().rotationZYX(0.0f, headYaw * ((float)Math.PI / 180) * 0.75f, headPitch * ((float)Math.PI / 180) * 0.75f);
        Quaternionf headRotation = new Quaternionf().rotationZYX(headRoll * ((float)Math.PI / 180), headYaw * ((float)Math.PI / 180) * 0.25f, headPitch * ((float)Math.PI / 180) * 0.25f);
        ModelAnimator.rotateByInModelSpace(new ModelPart[]{this.body}, this.neckBase, neckRotation);
        ModelAnimator.rotateByInModelSpace(this.neckChain, this.head, headRotation);
    }
}

