/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.Entity;

public abstract class TropicraftAgeableHierarchicalModel<T extends Entity>
extends EntityModel<T> {
    private static final double MODEL_OFFSET = 1.5;
    private static final float CHILD_SCALE = 0.5f;

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        if (!this.young) {
            this.renderAdult(poseStack, buffer, packedLight, packedOverlay, color);
        } else {
            this.renderChild(poseStack, buffer, packedLight, packedOverlay, color);
        }
    }

    protected void renderAdult(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.root().render(poseStack, buffer, packedLight, packedOverlay, color);
    }

    protected void renderChild(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        poseStack.pushPose();
        poseStack.translate(0.0, 0.75, 0.0);
        poseStack.scale(0.5f, 0.5f, 0.5f);
        this.setScale(this.head(), 2.0f);
        this.root().render(poseStack, buffer, packedLight, packedOverlay, color);
        this.setScale(this.head(), 1.0f);
        poseStack.popPose();
    }

    private void setScale(ModelPart part, float scale) {
        part.xScale = scale;
        part.yScale = scale;
        part.zScale = scale;
    }

    protected abstract ModelPart root();

    protected abstract ModelPart head();
}

