/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.model;

import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.tropicraft.core.client.entity.model.ModelAnimator;
import org.joml.Matrix4x3f;
import org.joml.Matrix4x3fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class TwoJointSolver {
    private final ModelPart[] body;
    private final ModelPart hip;
    private final ModelPart knee;
    private final ModelPart foot;
    private final Vector3f hipOrigin;
    private final Vector3f footOrigin;
    private final Vector3f worldFootOrigin;
    private final Quaternionf worldFootRotation;
    private final float baseHipAngle;
    private final float baseKneeAngle;
    private final Vector3f hipBendAxis;
    private final Vector3f kneeBendAxis;
    private final float hipToKneeLength;
    private final float kneeToFootLength;

    public TwoJointSolver(ModelPart[] body, ModelPart hip, ModelPart knee, ModelPart foot) {
        this.body = body;
        this.hip = hip;
        this.knee = knee;
        this.foot = foot;
        Matrix4x3f localToWorld = this.getLocalToWorld();
        Quaternionf localToWorldRotation = localToWorld.getNormalizedRotation(new Quaternionf());
        Matrix4x3f hipToLocal = new Matrix4x3f();
        TwoJointSolver.translateAndRotate(hip, hipToLocal);
        Matrix4x3f kneeToLocal = new Matrix4x3f((Matrix4x3fc)hipToLocal);
        TwoJointSolver.translateAndRotate(knee, kneeToLocal);
        Matrix4x3f footToLocal = new Matrix4x3f((Matrix4x3fc)kneeToLocal);
        TwoJointSolver.translateAndRotate(foot, footToLocal);
        this.hipOrigin = hipToLocal.transformPosition(new Vector3f());
        Vector3f kneeOrigin = kneeToLocal.transformPosition(new Vector3f());
        this.footOrigin = footToLocal.transformPosition(new Vector3f());
        this.worldFootOrigin = localToWorld.transformPosition((Vector3fc)this.footOrigin, new Vector3f());
        this.worldFootRotation = footToLocal.getNormalizedRotation(new Quaternionf()).premul((Quaternionfc)localToWorldRotation);
        Vector3f hipToKnee = kneeOrigin.sub((Vector3fc)this.hipOrigin, new Vector3f());
        Vector3f kneeToFoot = this.footOrigin.sub((Vector3fc)kneeOrigin, new Vector3f());
        Vector3f hipToFoot = this.footOrigin.sub((Vector3fc)this.hipOrigin, new Vector3f());
        Vector3f bendAxis = hipToFoot.cross((Vector3fc)hipToKnee, new Vector3f());
        this.hipBendAxis = hipToLocal.invert().transformDirection((Vector3fc)bendAxis, new Vector3f()).normalize();
        this.kneeBendAxis = kneeToLocal.invert().transformDirection((Vector3fc)bendAxis, new Vector3f()).normalize();
        this.hipToKneeLength = this.hipOrigin.distance((Vector3fc)kneeOrigin);
        this.kneeToFootLength = kneeOrigin.distance((Vector3fc)this.footOrigin);
        this.baseHipAngle = hipToFoot.angle((Vector3fc)hipToKnee);
        this.baseKneeAngle = hipToKnee.negate(new Vector3f()).angle((Vector3fc)kneeToFoot);
    }

    public void apply(Vector3f target, float factor) {
        this.applyInWorldSpace(new Vector3f(target.x, 1.5f - target.y, target.z), factor);
    }

    public void applyRelativeToBase(float factor, float offsetX, float offsetY, float offsetZ) {
        this.applyInWorldSpace(this.worldFootOrigin.add(offsetX, offsetY, offsetZ, new Vector3f()), factor);
    }

    private void applyInWorldSpace(Vector3f footTargetWorld, float factor) {
        if (factor < 1.0E-5f) {
            return;
        }
        Vector3f footTargetLocal = this.getWorldToLocal().transformPosition(footTargetWorld);
        footTargetLocal.lerp((Vector3fc)this.footOrigin, 1.0f - factor);
        this.applyInLocalSpace(footTargetLocal);
    }

    private void applyInLocalSpace(Vector3f footTarget) {
        if (footTarget.distanceSquared((Vector3fc)this.footOrigin) < 1.0E-5f) {
            return;
        }
        Vector3f hipToFoot = this.footOrigin.sub((Vector3fc)this.hipOrigin, new Vector3f());
        Vector3f hipToTarget = footTarget.sub((Vector3fc)this.hipOrigin, new Vector3f());
        float hipToTargetLength = Mth.clamp((float)hipToTarget.length(), (float)1.0E-5f, (float)(this.hipToKneeLength + this.kneeToFootLength - 1.0E-5f));
        float newHipAngle = TwoJointSolver.angleForSideLengths(this.hipToKneeLength, hipToTargetLength, this.kneeToFootLength);
        float newKneeAngle = TwoJointSolver.angleForSideLengths(this.hipToKneeLength, this.kneeToFootLength, hipToTargetLength);
        ModelAnimator.rotateAround(this.hip, this.hipBendAxis, newHipAngle - this.baseHipAngle);
        ModelAnimator.rotateAround(this.knee, this.kneeBendAxis, newKneeAngle - this.baseKneeAngle);
        Quaternionf localToHip = new Quaternionf().rotationZYX(this.hip.zRot, this.hip.yRot, this.hip.xRot).conjugate();
        Vector3f finalAxis = hipToFoot.cross((Vector3fc)hipToTarget, new Vector3f()).rotate((Quaternionfc)localToHip).normalize();
        float finalAngle = hipToFoot.angle((Vector3fc)hipToTarget);
        ModelAnimator.rotateAround(this.hip, finalAxis, finalAngle);
        Quaternionf footRotation = this.getWorldKneeRotation(new Quaternionf()).conjugate().mul((Quaternionfc)this.worldFootRotation);
        ModelAnimator.setRotation(this.foot, footRotation);
    }

    private Matrix4x3f getLocalToWorld() {
        Matrix4x3f localToWorld = new Matrix4x3f();
        for (ModelPart part : this.body) {
            TwoJointSolver.translateAndRotate(part, localToWorld);
        }
        return localToWorld;
    }

    private Matrix4x3f getWorldToLocal() {
        Matrix4x3f worldToLocal = new Matrix4x3f();
        for (int i = this.body.length - 1; i >= 0; --i) {
            TwoJointSolver.translateAndRotateInverse(this.body[i], worldToLocal);
        }
        return worldToLocal;
    }

    private static float angleForSideLengths(float a, float b, float c) {
        return (float)Math.acos(Mth.clamp((float)((a * a + b * b - c * c) / (2.0f * a * b)), (float)-1.0f, (float)1.0f));
    }

    private Quaternionf getWorldKneeRotation(Quaternionf result) {
        for (ModelPart part : this.body) {
            result.rotateZYX(part.zRot, part.yRot, part.xRot);
        }
        result.rotateZYX(this.hip.zRot, this.hip.yRot, this.hip.xRot);
        result.rotateZYX(this.knee.zRot, this.knee.yRot, this.knee.xRot);
        return result;
    }

    private static void translateAndRotate(ModelPart part, Matrix4x3f matrix) {
        matrix.translate(part.x / 16.0f, part.y / 16.0f, part.z / 16.0f);
        if (part.xRot != 0.0f || part.yRot != 0.0f || part.zRot != 0.0f) {
            matrix.rotateZYX(part.zRot, part.yRot, part.xRot);
        }
        if (part.xScale != 1.0f || part.yScale != 1.0f || part.zScale != 1.0f) {
            matrix.scale(part.xScale, part.yScale, part.zScale);
        }
    }

    private static void translateAndRotateInverse(ModelPart part, Matrix4x3f worldToLocal) {
        if (part.xScale != 1.0f || part.yScale != 1.0f || part.zScale != 1.0f) {
            worldToLocal.scale(1.0f / part.xScale, 1.0f / part.yScale, 1.0f / part.zScale);
        }
        if (part.xRot != 0.0f || part.yRot != 0.0f || part.zRot != 0.0f) {
            worldToLocal.rotate((Quaternionfc)new Quaternionf().rotationZYX(part.zRot, part.yRot, part.xRot).conjugate());
        }
        worldToLocal.translate(-part.x / 16.0f, -part.y / 16.0f, -part.z / 16.0f);
    }
}

