/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.model;

import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;
import net.tropicraft.core.client.entity.model.ModelAnimator;
import net.tropicraft.core.client.entity.model.TropicraftAgeableHierarchicalModel;

public class WhiteLippedPeccaryModel<T extends Entity>
extends TropicraftAgeableHierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart head_base;
    private final ModelPart body_base;
    private final ModelPart leg_left_ba;
    private final ModelPart leg_right_ba;
    private final ModelPart leg_left_fr;
    private final ModelPart leg_right_fr;

    public WhiteLippedPeccaryModel(ModelPart root) {
        this.root = root;
        this.body_base = root.getChild("body_base");
        this.head_base = root.getChild("head_base");
        this.leg_left_ba = this.body_base.getChild("leg_left_ba");
        this.leg_right_ba = this.body_base.getChild("leg_right_ba");
        this.leg_left_fr = this.body_base.getChild("leg_left_fr");
        this.leg_right_fr = this.body_base.getChild("leg_right_fr");
    }

    public static LayerDefinition create() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        PartDefinition modelPartBody = root.addOrReplaceChild("body_base", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -1.0f, -9.0f, 6.0f, 7.0f, 12.0f, false), PartPose.offset((float)0.0f, (float)12.0f, (float)4.0f));
        PartDefinition modelPartHead = root.addOrReplaceChild("head_base", CubeListBuilder.create().texOffs(0, 20).addBox(-2.5f, -3.0f, -3.0f, 5.0f, 7.0f, 4.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)14.0f, (float)-5.5f, (float)0.0873f, (float)0.0f, (float)0.0f));
        modelPartHead.addOrReplaceChild("head_connection", CubeListBuilder.create().mirror(false).texOffs(0, 32).addBox(-1.5f, -1.0f, -5.0f, 3.0f, 3.0f, 5.0f, new CubeDeformation(0.005f)), PartPose.offset((float)0.0f, (float)2.0f, (float)-3.0f));
        modelPartHead.addOrReplaceChild("ear_right", CubeListBuilder.create().texOffs(27, 41).addBox(-1.0f, -2.0f, 0.0f, 1.0f, 2.0f, 2.0f, false), PartPose.offsetAndRotation((float)-1.5f, (float)-3.0f, (float)-1.0f, (float)-0.829f, (float)-0.2618f, (float)-0.3491f));
        modelPartHead.addOrReplaceChild("ear_left", CubeListBuilder.create().texOffs(0, 50).addBox(0.0f, -2.0f, 0.0f, 1.0f, 2.0f, 2.0f, false), PartPose.offsetAndRotation((float)1.5f, (float)-3.0f, (float)-1.0f, (float)-0.829f, (float)0.2618f, (float)0.3491f));
        PartDefinition modelPartHeadSnoutBridge = modelPartHead.addOrReplaceChild("head_snout_bridge", CubeListBuilder.create().texOffs(19, 20).addBox(-1.5f, 0.0f, -6.0f, 3.0f, 4.0f, 6.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)-3.0f, (float)0.48f, (float)0.0f, (float)0.0f));
        PartDefinition modelPartHeadSnout = modelPartHeadSnoutBridge.addOrReplaceChild("head_snout", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-6.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        modelPartHeadSnout.addOrReplaceChild("head_snout_r1", CubeListBuilder.create().mirror(false).texOffs(18, 41).addBox(-1.5f, 0.0f, -0.5f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.006f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        modelPartBody.addOrReplaceChild("hair_base_right", CubeListBuilder.create().texOffs(37, 14).addBox(-1.5f, -3.0f, 0.0f, 1.0f, 3.0f, 10.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)-9.0f, (float)-0.1309f, (float)0.0f, (float)-0.2182f));
        modelPartBody.addOrReplaceChild("hair_base_left", CubeListBuilder.create().texOffs(37, 0).addBox(0.5f, -3.0f, 0.0f, 1.0f, 3.0f, 10.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)-9.0f, (float)-0.1309f, (float)0.0f, (float)0.2182f));
        modelPartBody.addOrReplaceChild("leg_left_ba", CubeListBuilder.create().texOffs(26, 32).addBox(-1.005f, 0.1f, -1.0f, 2.0f, 6.0f, 2.0f, false), PartPose.offset((float)2.0f, (float)5.9f, (float)2.0f));
        modelPartBody.addOrReplaceChild("leg_right_ba", CubeListBuilder.create().texOffs(17, 32).addBox(-0.995f, 0.1f, -1.0f, 2.0f, 6.0f, 2.0f, false), PartPose.offset((float)-2.0f, (float)5.9f, (float)2.0f));
        modelPartBody.addOrReplaceChild("leg_left_fr", CubeListBuilder.create().texOffs(9, 41).addBox(-1.005f, 0.1f, -1.0f, 2.0f, 6.0f, 2.0f, false), PartPose.offset((float)2.0f, (float)5.9f, (float)-8.0f));
        modelPartBody.addOrReplaceChild("leg_right_fr", CubeListBuilder.create().texOffs(0, 41).addBox(-0.995f, 0.1f, -1.0f, 2.0f, 6.0f, 2.0f, false), PartPose.offset((float)-2.0f, (float)5.9f, (float)-8.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float age, float headYaw, float headPitch) {
        ModelAnimator.look(this.head_base, headYaw, headPitch);
        try (ModelAnimator.Cycle walk = ModelAnimator.cycle(limbSwing * 0.2f, limbSwingAmount);){
            this.leg_left_fr.xRot = walk.eval(1.0f, 1.0f);
            this.leg_right_fr.xRot = walk.eval(-1.0f, 1.0f);
            this.leg_left_ba.xRot = walk.eval(-1.0f, 1.0f);
            this.leg_right_ba.xRot = walk.eval(1.0f, 1.0f);
        }
    }

    @Override
    protected ModelPart root() {
        return this.root;
    }

    @Override
    protected ModelPart head() {
        return this.head_base;
    }
}

