/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.client.entity.TropicraftSpecialRenderHelper;
import net.tropicraft.core.client.entity.model.EggModel;
import net.tropicraft.core.common.entity.egg.EggEntity;

public class EggRenderer
extends LivingEntityRenderer<EggEntity, EggModel> {
    public EggRenderer(EntityRendererProvider.Context context, ModelLayerLocation modelLayerLocation) {
        super(context, (EntityModel)new EggModel(context.bakeLayer(modelLayerLocation)), 1.0f);
        this.shadowStrength = 0.5f;
    }

    public void render(EggEntity egg, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource bufferIn, int packedLightIn) {
        stack.pushPose();
        if (egg.shouldEggRenderFlat()) {
            this.shadowRadius = 0.0f;
            stack.translate(0.0, 0.05, 0.0);
            this.drawFlatEgg(egg, partialTicks, stack, bufferIn, packedLightIn);
        } else {
            this.shadowRadius = 0.2f;
            stack.scale(0.5f, 0.5f, 0.5f);
            super.render((LivingEntity)egg, entityYaw, partialTicks, stack, bufferIn, packedLightIn);
        }
        stack.popPose();
    }

    public void drawFlatEgg(EggEntity ent, float partialTicks, PoseStack stack, MultiBufferSource bufferIn, int packedLightIn) {
        stack.pushPose();
        stack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        stack.mulPose(Axis.YP.rotationDegrees(180.0f));
        stack.scale(0.25f, 0.25f, 0.25f);
        ResourceLocation resourceLocation = this.getTextureLocation(ent);
        VertexConsumer buffer = bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)resourceLocation));
        int overlay = EggRenderer.getOverlayCoords((LivingEntity)ent, (float)this.getWhiteOverlayProgress(ent, partialTicks));
        PoseStack.Pose pose = stack.last();
        TropicraftSpecialRenderHelper.vertex(buffer, pose, -0.5, -0.25, 0.0, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, Direction.UP, packedLightIn, overlay);
        TropicraftSpecialRenderHelper.vertex(buffer, pose, 0.5, -0.25, 0.0, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, Direction.UP, packedLightIn, overlay);
        TropicraftSpecialRenderHelper.vertex(buffer, pose, 0.5, 0.75, 0.0, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, Direction.UP, packedLightIn, overlay);
        TropicraftSpecialRenderHelper.vertex(buffer, pose, -0.5, 0.75, 0.0, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, Direction.UP, packedLightIn, overlay);
        stack.popPose();
    }

    protected boolean shouldShowName(EggEntity entity) {
        return entity.hasCustomName();
    }

    public ResourceLocation getTextureLocation(EggEntity entity) {
        return Tropicraft.location("textures/entity/" + entity.getEggTexture() + ".png");
    }
}

