/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.common.entity.placeable.FurnitureEntity;
import org.joml.Quaternionf;

public class FurnitureRenderer<T extends FurnitureEntity>
extends EntityRenderer<T> {
    private static final Axis DEFAULT_ROCKING_AXIS = angle -> new Quaternionf().rotationAxis(angle, 1.0f, 0.0f, 1.0f);
    private final ResourceLocation baseTexture;
    private final ResourceLocation colorTexture;
    private final EntityModel<T> model;
    private final float scale;

    public FurnitureRenderer(EntityRendererProvider.Context context, String textureName, EntityModel<T> model) {
        this(context, textureName, model, 1.0f);
    }

    public FurnitureRenderer(EntityRendererProvider.Context context, String textureName, EntityModel<T> model, float scale) {
        super(context);
        this.baseTexture = Tropicraft.location("textures/entity/" + textureName + "_base_layer.png");
        this.colorTexture = Tropicraft.location("textures/entity/" + textureName + "_color_layer.png");
        this.model = model;
        this.scale = scale;
    }

    public void render(T furniture, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLightIn) {
        stack.pushPose();
        stack.translate(0.0, this.getYOffset(), 0.0);
        stack.mulPose(Axis.YP.rotationDegrees(180.0f - entityYaw));
        stack.scale(this.scale, this.scale, this.scale);
        this.setupTransforms(stack);
        float rockingAngle = this.getRockingAngle(furniture, partialTicks);
        if (!Mth.equal((float)rockingAngle, (float)0.0f)) {
            stack.mulPose(this.getRockingAxis().rotationDegrees(rockingAngle));
        }
        int color = ((FurnitureEntity)((Object)furniture)).getColor().getTextureDiffuseColor();
        VertexConsumer builder = buffer.getBuffer(this.model.renderType(this.baseTexture));
        stack.scale(-1.0f, -1.0f, 1.0f);
        this.model.renderToBuffer(stack, builder, this.getPackedLightCoords((Entity)furniture, partialTicks), OverlayTexture.NO_OVERLAY);
        builder = buffer.getBuffer(this.model.renderType(this.colorTexture));
        this.model.renderToBuffer(stack, builder, this.getPackedLightCoords((Entity)furniture, partialTicks), OverlayTexture.NO_OVERLAY, color);
        super.render(furniture, entityYaw, partialTicks, stack, buffer, packedLightIn);
        stack.popPose();
    }

    protected double getYOffset() {
        return 0.3125;
    }

    protected void setupTransforms(PoseStack stack) {
    }

    protected float getRockingAngle(T entity, float partialTicks) {
        float f2 = (float)((FurnitureEntity)((Object)entity)).getTimeSinceHit() - partialTicks;
        float f3 = ((FurnitureEntity)((Object)entity)).getDamage() - partialTicks;
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f2 > 0.0f) {
            return Mth.sin((float)f2) * f2 * f3 / this.getRockAmount() * (float)((FurnitureEntity)((Object)entity)).getForwardDirection();
        }
        return 0.0f;
    }

    protected Axis getRockingAxis() {
        return DEFAULT_ROCKING_AXIS;
    }

    protected float getRockAmount() {
        return 10.0f;
    }

    public ResourceLocation getTextureLocation(T furniture) {
        return null;
    }
}

