/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render;

import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.client.TropicraftRenderLayers;
import net.tropicraft.core.client.entity.model.KoaModel;
import net.tropicraft.core.common.entity.passive.EntityKoaBase;

public class KoaRenderer
extends HumanoidMobRenderer<EntityKoaBase, KoaModel> {
    private static final ResourceLocation MALE_FISHER = Tropicraft.location("textures/entity/koa/koa_man_fisher.png");
    private static final ResourceLocation FEMALE_FISHER = Tropicraft.location("textures/entity/koa/koa_woman_fisher.png");
    private static final ResourceLocation MALE_HUNTER = Tropicraft.location("textures/entity/koa/koa_man_hunter.png");
    private static final ResourceLocation FEMALE_HUNTER = Tropicraft.location("textures/entity/koa/koa_woman_hunter.png");

    public KoaRenderer(EntityRendererProvider.Context context) {
        super(context, (HumanoidModel)new KoaModel(context.bakeLayer(TropicraftRenderLayers.KOA_HUNTER_LAYER)), 0.5f);
        this.shadowStrength = 0.5f;
    }

    public ResourceLocation getTextureLocation(EntityKoaBase entity) {
        if (entity.getGender() == EntityKoaBase.Genders.MALE) {
            if (entity.getRole() == EntityKoaBase.Roles.HUNTER) {
                return MALE_HUNTER;
            }
            return MALE_FISHER;
        }
        if (entity.getRole() == EntityKoaBase.Roles.HUNTER) {
            return FEMALE_HUNTER;
        }
        return FEMALE_FISHER;
    }

    public Vec3 getRenderOffset(EntityKoaBase pEntity, float pPartialTicks) {
        if (pEntity.isSitting()) {
            if (pEntity.isBaby()) {
                return new Vec3(0.0, -0.3, 0.0);
            }
            return new Vec3(0.0, -0.7, 0.0);
        }
        return super.getRenderOffset((Entity)pEntity, pPartialTicks);
    }

    @Nullable
    protected RenderType getRenderType(EntityKoaBase entity, boolean p_230496_2_, boolean p_230496_3_, boolean p_230496_4_) {
        return RenderType.entityCutout((ResourceLocation)this.getTextureLocation(entity));
    }
}

