/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.tropicraft.core.common.entity.projectile.SpearEntity;

public class SpearRenderer<T extends SpearEntity>
extends EntityRenderer<T> {
    private final ItemRenderer itemRenderer;

    public SpearRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemRenderer = context.getItemRenderer();
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)((SpearEntity)((Object)entity)).yRotO, (float)entity.getYRot())));
        poseStack.mulPose(Axis.XP.rotationDegrees(-Mth.lerp((float)partialTicks, (float)((SpearEntity)((Object)entity)).xRotO, (float)entity.getXRot())));
        poseStack.mulPose(Axis.YP.rotationDegrees(-45.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
        poseStack.scale(2.5f, 2.5f, 2.5f);
        BakedModel model = this.itemRenderer.getModel(entity.getPickupItemStackOrigin(), entity.level(), null, entity.getId());
        this.itemRenderer.render(entity.getPickupItemStackOrigin(), ItemDisplayContext.GROUND, false, poseStack, bufferSource, packedLight, OverlayTexture.NO_OVERLAY, model);
        poseStack.popPose();
        super.render(entity, entityYaw, partialTicks, poseStack, bufferSource, packedLight);
    }

    public ResourceLocation getTextureLocation(T entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

