/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.tropicraft.core.client.entity.TropicraftSpecialRenderHelper;
import net.tropicraft.core.common.entity.underdasea.StarfishEntity;
import net.tropicraft.core.common.entity.underdasea.StarfishType;

public class StarfishRenderer
extends EntityRenderer<StarfishEntity> {
    public static final float BABY_RENDER_SCALE = 0.25f;
    public static final float ADULT_RENDER_SCALE = 1.0f;

    public StarfishRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(StarfishEntity starfish, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLightIn) {
        StarfishType type = starfish.getStarfishType();
        float f = 0.0f;
        float f1 = 1.0f;
        float f2 = 0.0f;
        float f3 = 1.0f;
        float f1shifted = 1.0f;
        float f3shifted = 1.0f;
        stack.pushPose();
        stack.translate(-0.5, 0.0, -0.5);
        stack.mulPose(Axis.XP.rotationDegrees(90.0f));
        float scale = 0.25f + starfish.getGrowthProgress() * 0.75f;
        stack.scale(scale, scale, scale);
        for (int i = 0; i < type.getLayerCount(); ++i) {
            ResourceLocation texture = type.getTextures().get(i);
            VertexConsumer ivertexbuilder = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)texture));
            float red = 1.0f;
            float green = starfish.hurtTime > 0 ? 0.0f : 1.0f;
            float blue = starfish.hurtTime > 0 ? 0.0f : 1.0f;
            float alpha = 1.0f;
            float layerHeight = type.getLayerHeights()[i];
            TropicraftSpecialRenderHelper.popper(f1, f2, f, f3, f1shifted, f3shifted, layerHeight, stack, ivertexbuilder, packedLightIn, LivingEntityRenderer.getOverlayCoords((LivingEntity)starfish, (float)0.0f), 1.0f, green, blue, 1.0f);
            stack.translate(0.0f, 0.0f, -layerHeight);
        }
        stack.popPose();
    }

    public ResourceLocation getTextureLocation(StarfishEntity starfishEntity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

