/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.function.Predicate;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.client.entity.TropicraftSpecialRenderHelper;

public class SunglassesLayer<T extends Entity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation TEXTURE = Tropicraft.location("textures/entity/sunglasses.png");
    private final TropicraftSpecialRenderHelper mask;
    private final M model;
    private final Predicate<T> predicate;
    private final Transform<T, M> transform;

    public SunglassesLayer(RenderLayerParent<T, M> parent, Predicate<T> predicate, Transform<T, M> transform) {
        super(parent);
        this.model = parent.getModel();
        this.mask = new TropicraftSpecialRenderHelper();
        this.predicate = predicate;
        this.transform = transform;
    }

    public void render(PoseStack stack, MultiBufferSource bufferIn, int packedLightIn, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!this.predicate.test(entity)) {
            return;
        }
        stack.pushPose();
        this.model.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.transform.apply(stack, entity, this.model);
        stack.mulPose(Axis.YP.rotation((float)Math.PI));
        VertexConsumer consumer = bufferIn.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)TEXTURE));
        this.mask.renderMask(stack, consumer, 0, packedLightIn, OverlayTexture.NO_OVERLAY);
        stack.popPose();
    }

    public static interface Transform<T, M> {
        public void apply(PoseStack var1, T var2, M var3);
    }
}

