/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.tileentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemEntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.tropicraft.core.common.block.tileentity.SifterBlockEntity;

public class SifterRenderer
implements BlockEntityRenderer<SifterBlockEntity> {
    public static final float ITEM_SCALE = 1.3125f;
    private final ItemRenderer itemRenderer;

    public SifterRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.getItemRenderer();
    }

    public void render(SifterBlockEntity sifter, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Level level = sifter.getLevel();
        ItemStack item = sifter.getSiftItem();
        if (!sifter.isSifting() || item.isEmpty()) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.5, 0.2, 0.5);
        poseStack.rotateAround(Axis.YP.rotationDegrees((float)Mth.rotLerp((double)partialTicks, (double)sifter.yaw2, (double)sifter.yaw)), 0.0f, -0.4f, 0.0f);
        poseStack.mulPose(Axis.XP.rotationDegrees(-20.0f));
        poseStack.scale(1.3125f, 1.3125f, 1.3125f);
        ItemEntityRenderer.renderMultipleFromCount((ItemRenderer)this.itemRenderer, (PoseStack)poseStack, (MultiBufferSource)bufferSource, (int)packedLight, (ItemStack)item, (RandomSource)level.random, (Level)level);
        poseStack.popPose();
    }
}

