/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common;

import net.minecraft.util.Mth;

public class BinaryAnimation {
    private final int totalSteps;
    private final int stepIn;
    private final int stepOut;
    private final Easing easing;
    private int value;
    private int lastValue;

    public BinaryAnimation(int lengthIn, int lengthOut, Easing easing) {
        this.totalSteps = lengthIn * lengthOut;
        this.stepIn = this.totalSteps / lengthIn;
        this.stepOut = this.totalSteps / lengthOut;
        this.easing = easing;
    }

    public BinaryAnimation(int length, Easing easing) {
        this.totalSteps = length;
        this.stepIn = 1;
        this.stepOut = 1;
        this.easing = easing;
    }

    public void tick(boolean active) {
        this.lastValue = this.value;
        if (active) {
            if (this.value < this.totalSteps) {
                this.value = Math.min(this.value + this.stepIn, this.totalSteps);
            }
        } else if (this.value > 0) {
            this.value = Math.max(this.value - this.stepOut, 0);
        }
    }

    public void setImmediate(boolean active) {
        this.value = active ? this.totalSteps : 0;
    }

    public float get(float partialTicks) {
        return this.easing.apply(Mth.lerp((float)partialTicks, (float)this.lastValue, (float)this.value) / (float)this.totalSteps);
    }

    public static interface Easing {
        public float apply(float var1);
    }
}

